/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.path;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.integrateddynamics.api.path.IPathElement;
import org.cyclops.integrateddynamics.core.path.Cluster;

public final class PathFinder {
    protected static TreeSet<IPathElement> getConnectedElements(IPathElement head, Set<DimPos> visitedPositions) {
        TreeSet elements = Sets.newTreeSet();
        if (!visitedPositions.contains(head.getPosition())) {
            elements.add(head);
            visitedPositions.add(head.getPosition());
        }
        for (IPathElement neighbour : head.getReachableElements()) {
            if (visitedPositions.contains(neighbour.getPosition())) continue;
            elements.add(neighbour);
            visitedPositions.add(neighbour.getPosition());
        }
        HashSet neighbourElements = Sets.newHashSet();
        for (IPathElement addedElement : elements) {
            neighbourElements.addAll(PathFinder.getConnectedElements(addedElement, visitedPositions));
        }
        elements.addAll(neighbourElements);
        return elements;
    }

    public static Cluster getConnectedCluster(IPathElement head) {
        return new Cluster(PathFinder.getConnectedElements(head, Sets.newTreeSet()));
    }
}

