/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.jei.mechanicalsqueezer;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.block.BlockMechanicalSqueezer;
import org.cyclops.integrateddynamics.block.BlockMechanicalSqueezerConfig;
import org.cyclops.integrateddynamicscompat.IntegratedDynamicsCompat;
import org.cyclops.integrateddynamicscompat.modcompat.jei.mechanicalsqueezer.MechanicalSqueezerRecipeJEI;

public class MechanicalSqueezerRecipeCategory
implements IRecipeCategory {
    public static final String NAME = "integrateddynamicscompat:mechanicalSqueezer";
    private static final int INPUT_SLOT = 0;
    private static final int FLUIDOUTPUT_SLOT = 1;
    private static final int OUTPUT_SLOT = 2;
    private final IDrawable background;
    private final IDrawableAnimated arrowDrawable;

    public MechanicalSqueezerRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation resourceLocation = new ResourceLocation("integrateddynamicscompat:" + (String)IntegratedDynamicsCompat._instance.getReferenceValue(ModBase.REFKEY_TEXTURE_PATH_GUI) + BlockMechanicalSqueezerConfig._instance.getNamedId() + "_gui_jei.png");
        this.background = guiHelper.createDrawable(resourceLocation, 0, 0, 116, 53);
        this.arrowDrawable = guiHelper.createAnimatedDrawable(guiHelper.createDrawable(resourceLocation, 116, 0, 4, 11), 20, IDrawableAnimated.StartDirection.TOP, false);
    }

    @Nonnull
    public String getUid() {
        return NAME;
    }

    @Nonnull
    public String getTitle() {
        return L10NHelpers.localize((String)(BlockMechanicalSqueezer.getInstance().func_149739_a() + ".name"), (Object[])new Object[0]);
    }

    public String getModName() {
        return "Integrated Dynamics";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return null;
    }

    public void drawExtras(Minecraft minecraft) {
        this.arrowDrawable.draw(minecraft, 45, 21);
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        if (recipeWrapper instanceof MechanicalSqueezerRecipeJEI) {
            int i;
            MechanicalSqueezerRecipeJEI recipe = (MechanicalSqueezerRecipeJEI)recipeWrapper;
            recipeLayout.getItemStacks().init(0, true, 1, 17);
            int offset = 0;
            for (i = 0; i < recipe.getOutputItems().size(); ++i) {
                int index = 2 + i;
                recipeLayout.getItemStacks().init(2 + i, false, 75 + (i > 0 ? 22 : 0), 7 + offset + (i > 1 ? 22 : 0));
                float chance = recipe.getOutputChances().get(i).floatValue();
                if (chance == 1.0f) continue;
                recipeLayout.getItemStacks().addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
                    if (slotIndex == index) {
                        tooltip.add(TextFormatting.GRAY + "Chance: " + chance + "%");
                    }
                });
            }
            recipeLayout.getItemStacks().init(1, false, 75, 30);
            if (!recipe.getInputItem().isEmpty()) {
                recipeLayout.getItemStacks().set(0, recipe.getInputItem());
            }
            i = 0;
            for (List<ItemStack> outputItem : recipe.getOutputItems()) {
                recipeLayout.getItemStacks().set(2 + i++, outputItem);
            }
            recipeLayout.getFluidStacks().init(1, true, 76, 30, 16, 16, 1000, false, null);
            if (recipe.getOutputFluid() != null) {
                recipeLayout.getFluidStacks().set(1, recipe.getOutputFluid());
            }
        }
    }
}

