/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.sync.client.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import me.ichun.mods.ichunutil.client.keybind.KeyEvent;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import me.ichun.mods.sync.client.model.ModelShellConstructor;
import me.ichun.mods.sync.client.render.TileRendererDualVertical;
import me.ichun.mods.sync.client.render.item.RenderItemShellConstructor;
import me.ichun.mods.sync.client.render.item.RenderItemShellStorage;
import me.ichun.mods.sync.client.render.item.RenderItemTreadmill;
import me.ichun.mods.sync.common.Sync;
import me.ichun.mods.sync.common.packet.PacketSyncRequest;
import me.ichun.mods.sync.common.packet.PacketUpdatePlayerOnZoomFinish;
import me.ichun.mods.sync.common.shell.ShellState;
import me.ichun.mods.sync.common.tileentity.TileEntityShellStorage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class EventHandlerClient {
    public static final ResourceLocation txHome = new ResourceLocation("sync", "textures/icon/home.png");
    public HashMap<String, Integer> refusePlayerRender = new HashMap();
    public boolean forceRender;
    public boolean radialShow;
    public float radialPlayerYaw;
    public float radialPlayerPitch;
    public double radialDeltaX;
    public double radialDeltaY;
    public int radialTime;
    public EnumFacing zoomFace;
    public int zoomTimer;
    public int zoomTimeout;
    public boolean zoom;
    public BlockPos zoomPos;
    public int zoomDimension;
    public float zoomPrevYaw;
    public float zoomPrevPitch;
    public double zoomPrevX;
    public double zoomPrevY;
    public double zoomPrevZ;
    public boolean zoomDeath;
    public boolean hideGui;
    public int lockTime;
    public TileEntityShellStorage lockedStorage = null;
    public ArrayList<ShellState> shells = new ArrayList();
    public ModelShellConstructor modelShellConstructor = new ModelShellConstructor();

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        EventHandlerClient.registerItemWithTESR(Sync.itemShellConstructor, RenderItemShellConstructor.ItemShellConstructorRenderHack.class, new RenderItemShellConstructor());
        EventHandlerClient.registerItemWithTESR(Sync.itemShellStorage, RenderItemShellStorage.ItemShellStorageRenderHack.class, new RenderItemShellStorage());
        EventHandlerClient.registerItemWithTESR(Sync.itemTreadmill, RenderItemTreadmill.ItemTreadmillRenderHack.class, new RenderItemTreadmill());
        ModelLoader.setCustomModelResourceLocation((Item)Sync.itemSyncCore, (int)0, (ModelResourceLocation)new ModelResourceLocation("sync:sync_core", "inventory"));
    }

    private static void registerItemWithTESR(Item item, Class<? extends TileEntity> tileEntityClass, TileEntitySpecialRenderer<?> renderer) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("minecraft:shield"));
        TileEntityRendererDispatcher.field_147556_a.field_147559_m.put(tileEntityClass, renderer);
        ForgeHooksClient.registerTESRItemStack((Item)item, (int)0, tileEntityClass);
    }

    @SubscribeEvent
    public void onKeyEvent(KeyEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r == null && event.keyBind.isPressed() && event.keyBind.isMinecraftBind()) {
            if (event.keyBind.keyIndex == mc.field_71474_y.field_74312_F.func_151463_i()) {
                double mag = Math.sqrt(Sync.eventHandlerClient.radialDeltaX * Sync.eventHandlerClient.radialDeltaX + Sync.eventHandlerClient.radialDeltaY * Sync.eventHandlerClient.radialDeltaY);
                double magAcceptance = 0.8;
                double radialAngle = -720.0;
                if (mag > magAcceptance) {
                    double aSin = Math.toDegrees(Math.asin(Sync.eventHandlerClient.radialDeltaX));
                    if (Sync.eventHandlerClient.radialDeltaY >= 0.0 && Sync.eventHandlerClient.radialDeltaX >= 0.0) {
                        radialAngle = aSin;
                    } else if (Sync.eventHandlerClient.radialDeltaY < 0.0 && Sync.eventHandlerClient.radialDeltaX >= 0.0) {
                        radialAngle = 90.0 + (90.0 - aSin);
                    } else if (Sync.eventHandlerClient.radialDeltaY < 0.0 && Sync.eventHandlerClient.radialDeltaX < 0.0) {
                        radialAngle = 180.0 - aSin;
                    } else if (Sync.eventHandlerClient.radialDeltaY >= 0.0 && Sync.eventHandlerClient.radialDeltaX < 0.0) {
                        radialAngle = 270.0 + (90.0 + aSin);
                    }
                }
                if (mag > 0.9999999) {
                    mag = Math.round(mag);
                }
                ArrayList<ShellState> selectedShells = new ArrayList<ShellState>(Sync.eventHandlerClient.shells);
                Collections.sort(selectedShells);
                for (int i = selectedShells.size() - 1; i >= 0; --i) {
                    ShellState state = selectedShells.get(i);
                    if (state.playerState == null || state.dimension != mc.field_71441_e.field_73011_w.getDimension() && (Sync.config.allowCrossDimensional == 0 || Sync.config.allowCrossDimensional == 1 && (state.dimension == 1 && mc.field_71441_e.field_73011_w.getDimension() != 1 || state.dimension != 1 && mc.field_71441_e.field_73011_w.getDimension() == 1))) {
                        selectedShells.remove(i);
                    }
                    if (Sync.eventHandlerClient.lockedStorage == null || !Sync.eventHandlerClient.lockedStorage.func_174877_v().equals((Object)state.pos) || Sync.eventHandlerClient.lockedStorage.func_145831_w().field_73011_w.getDimension() != state.dimension) continue;
                    selectedShells.remove(i);
                }
                ShellState selected = null;
                for (int i = 0; i < selectedShells.size(); ++i) {
                    float leeway = 360.0f / (float)selectedShells.size();
                    if (!(mag > magAcceptance * 0.75) || !(i == 0 && (radialAngle < (double)(leeway / 2.0f) && radialAngle >= 0.0 || radialAngle > (double)(360.0f - leeway / 2.0f))) && (i == 0 || !(radialAngle < (double)(leeway * (float)i + leeway / 2.0f)) || !(radialAngle > (double)(leeway * (float)i - leeway / 2.0f)))) continue;
                    selected = selectedShells.get(i);
                    break;
                }
                if (selected != null && selected.buildProgress >= (float)Sync.config.shellConstructionPowerRequirement && Sync.eventHandlerClient.lockedStorage != null) {
                    Sync.channel.sendToServer((AbstractPacket)new PacketSyncRequest(Sync.eventHandlerClient.lockedStorage.func_174877_v(), Sync.eventHandlerClient.lockedStorage.func_145831_w().field_73011_w.getDimension(), selected.pos, selected.dimension));
                }
                Sync.eventHandlerClient.radialShow = false;
                Sync.eventHandlerClient.lockedStorage = null;
            } else if (event.keyBind.keyIndex == mc.field_71474_y.field_74313_G.func_151463_i()) {
                Sync.eventHandlerClient.radialShow = false;
                Sync.eventHandlerClient.lockedStorage = null;
            }
        }
    }

    @SubscribeEvent
    public void onMouseEvent(MouseEvent event) {
        if (Sync.eventHandlerClient.radialShow) {
            if (!Sync.eventHandlerClient.shells.isEmpty()) {
                Sync.eventHandlerClient.radialDeltaX += (double)event.getDx() / 100.0;
                Sync.eventHandlerClient.radialDeltaY += (double)event.getDy() / 100.0;
                double mag = Math.sqrt(Sync.eventHandlerClient.radialDeltaX * Sync.eventHandlerClient.radialDeltaX + Sync.eventHandlerClient.radialDeltaY * Sync.eventHandlerClient.radialDeltaY);
                if (mag > 1.0) {
                    Sync.eventHandlerClient.radialDeltaX /= mag;
                    Sync.eventHandlerClient.radialDeltaY /= mag;
                }
            }
            if (event.getButton() == 0 || event.getButton() == 1) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Pre event) {
        if (Sync.eventHandlerClient.refusePlayerRender.containsKey(event.getEntityPlayer().func_70005_c_()) && !Sync.eventHandlerClient.forceRender && Sync.eventHandlerClient.refusePlayerRender.get(event.getEntityPlayer().func_70005_c_()) < 118) {
            event.getEntityPlayer().field_70142_S = event.getEntityPlayer().field_70169_q = event.getEntityPlayer().field_70165_t;
            event.getEntityPlayer().field_70167_r = event.getEntityPlayer() != Minecraft.func_71410_x().field_71439_g && Sync.eventHandlerClient.refusePlayerRender.get(event.getEntityPlayer().func_70005_c_()) > 60 ? 500.0 : event.getEntityPlayer().field_70163_u;
            event.getEntityPlayer().field_70137_T = event.getEntityPlayer().field_70167_r;
            event.getEntityPlayer().field_70136_U = event.getEntityPlayer().field_70166_s = event.getEntityPlayer().field_70161_v;
            event.getEntityPlayer().field_70761_aq = event.getEntityPlayer().field_70177_z;
            event.getEntityPlayer().field_70725_aQ = 0;
            if (!event.getEntityPlayer().func_70089_S()) {
                event.getEntityPlayer().func_70606_j(1.0f);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onClientConnect(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        Sync.config.resetSession();
        Sync.eventHandlerClient.radialShow = false;
        Sync.eventHandlerClient.zoom = false;
        Sync.eventHandlerClient.lockTime = 0;
        Sync.eventHandlerClient.zoomTimer = -10;
        Sync.eventHandlerClient.zoomTimeout = 0;
        Sync.eventHandlerClient.shells.clear();
        Sync.eventHandlerClient.refusePlayerRender.clear();
        Sync.eventHandlerClient.lockedStorage = null;
    }

    @SubscribeEvent
    public void onRenderGameOverlayPre(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS && Sync.eventHandlerClient.radialShow) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void worldTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.func_71410_x().field_71441_e != null) {
            Minecraft mc = Minecraft.func_71410_x();
            WorldClient world = mc.field_71441_e;
            if (this.radialTime > 0) {
                --this.radialTime;
            }
            if (mc.field_71462_r != null) {
                this.radialShow = false;
                this.lockedStorage = null;
            }
            if (!mc.func_147113_T()) {
                double d5;
                double d4;
                double d3;
                double dist;
                for (ShellState state : this.shells) {
                    state.tick();
                }
                Iterator<Map.Entry<String, Integer>> ite = this.refusePlayerRender.entrySet().iterator();
                while (ite.hasNext()) {
                    Map.Entry<String, Integer> e = ite.next();
                    e.setValue(e.getValue() - 1);
                    if (e.getValue() > 0) continue;
                    ite.remove();
                }
                if (this.lockTime > 0) {
                    --this.lockTime;
                    if (this.lockedStorage != null) {
                        mc.field_71439_g.func_70012_b((double)this.lockedStorage.func_174877_v().func_177958_n() + 0.5, (double)this.lockedStorage.func_174877_v().func_177956_o(), (double)this.lockedStorage.func_174877_v().func_177952_p() + 0.5, this.lockedStorage.face.func_176734_d().func_185119_l(), 0.0f);
                    }
                }
                if (this.zoomDimension == world.field_73011_w.getDimension()) {
                    TileEntity te;
                    if (this.zoomTimer == 60 && (te = world.func_175625_s(this.zoomPos)) instanceof TileEntityShellStorage) {
                        TileEntityShellStorage ss = (TileEntityShellStorage)te;
                        ss.occupied = true;
                    }
                    if (this.zoomTimer > -5 && !this.zoomDeath) {
                        mc.field_71439_g.func_70012_b((double)Sync.eventHandlerClient.zoomPos.func_177958_n() + 0.5, (double)Sync.eventHandlerClient.zoomPos.func_177956_o(), (double)Sync.eventHandlerClient.zoomPos.func_177952_p() + 0.5, Sync.eventHandlerClient.zoomFace.func_176734_d().func_185119_l(), 0.0f);
                    }
                    if (this.zoomTimer > -10) {
                        --this.zoomTimer;
                    }
                    if (this.zoomTimer == 0) {
                        Sync.channel.sendToServer((AbstractPacket)new PacketUpdatePlayerOnZoomFinish(mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70163_u, mc.field_71439_g.field_70161_v, mc.field_71439_g.field_70177_z, mc.field_71439_g.field_70125_A));
                        mc.field_71439_g.func_71016_p();
                    }
                } else if (this.zoomTimer > -10) {
                    if (this.zoomTimer > 60 && this.zoomTimer < 70) {
                        this.zoomTimer = 60;
                    }
                    ++this.zoomTimeout;
                    if (this.zoomTimeout >= 100) {
                        this.zoomTimer = -10;
                        this.zoomTimeout = 0;
                        this.zoom = false;
                    }
                }
                if (this.lockedStorage != null && ((dist = (double)MathHelper.func_76133_a((double)((d3 = mc.field_71439_g.field_70165_t - ((double)this.lockedStorage.func_174877_v().func_177958_n() + 0.5)) * d3 + (d4 = mc.field_71439_g.func_174813_aQ().field_72338_b - (double)this.lockedStorage.func_174877_v().func_177956_o()) * d4 + (d5 = mc.field_71439_g.field_70161_v - ((double)this.lockedStorage.func_174877_v().func_177952_p() + 0.5)) * d5))) >= 0.3 || world.func_175625_s(this.lockedStorage.func_174877_v()) != this.lockedStorage)) {
                    this.radialShow = false;
                    this.lockedStorage = null;
                }
            }
        }
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null) {
            if (event.phase == TickEvent.Phase.START) {
                if (this.radialShow) {
                    Mouse.getDX();
                    Mouse.getDY();
                    mc.field_71417_B.field_74375_b = 0;
                    mc.field_71417_B.field_74377_a = 0;
                    if (mc.func_175606_aa() instanceof EntityLivingBase) {
                        ((EntityLivingBase)mc.func_175606_aa()).field_70758_at = ((EntityLivingBase)mc.func_175606_aa()).field_70759_as = this.radialPlayerYaw;
                    }
                    mc.func_175606_aa().field_70126_B = mc.func_175606_aa().field_70177_z = this.radialPlayerYaw;
                    mc.func_175606_aa().field_70127_C = mc.func_175606_aa().field_70125_A = this.radialPlayerPitch;
                }
                this.updateZoom(mc.func_175606_aa(), event.renderTickTime, false);
            } else {
                this.updateZoom(mc.func_175606_aa(), event.renderTickTime, true);
                if (this.radialShow) {
                    int i;
                    double mag = Math.sqrt(Sync.eventHandlerClient.radialDeltaX * Sync.eventHandlerClient.radialDeltaX + Sync.eventHandlerClient.radialDeltaY * Sync.eventHandlerClient.radialDeltaY);
                    double magAcceptance = 0.8;
                    ScaledResolution reso = new ScaledResolution(mc);
                    float prog = MathHelper.func_76131_a((float)((3.0f - (float)this.radialTime + event.renderTickTime) / 3.0f), (float)0.0f, (float)1.0f);
                    int radius = 80;
                    radius = (int)((double)radius * Math.pow(prog, 0.5));
                    if (!mc.field_71474_y.field_74319_N) {
                        float rad;
                        GlStateManager.func_179090_x();
                        GlStateManager.func_179147_l();
                        GlStateManager.func_179112_b((int)770, (int)771);
                        GlStateManager.func_179128_n((int)5888);
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179096_D();
                        GlStateManager.func_179128_n((int)5889);
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179096_D();
                        int roundness = 100;
                        double zLev = 0.05;
                        int stencilBit = MinecraftForgeClient.reserveStencilBit();
                        if (stencilBit >= 0) {
                            double angle;
                            int i2;
                            GL11.glEnable((int)2960);
                            GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                            int stencilMask = 1 << stencilBit;
                            GL11.glStencilMask((int)stencilMask);
                            GL11.glStencilFunc((int)519, (int)stencilMask, (int)stencilMask);
                            GL11.glStencilOp((int)7680, (int)7680, (int)7681);
                            GL11.glClear((int)1024);
                            rad = (mag > magAcceptance ? 0.85f : 0.82f) * prog * (257.0f / (float)reso.func_78328_b());
                            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            GL11.glBegin((int)6);
                            GL11.glVertex3d((double)0.0, (double)0.0, (double)zLev);
                            for (i2 = 0; i2 <= roundness; ++i2) {
                                angle = Math.PI * 2 * (double)i2 / (double)roundness;
                                GL11.glVertex3d((double)(Math.cos(angle) * reso.func_78324_d() / reso.func_78327_c() * (double)rad), (double)(Math.sin(angle) * (double)rad), (double)zLev);
                            }
                            GL11.glEnd();
                            GL11.glStencilFunc((int)519, (int)0, (int)stencilMask);
                            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            rad = 0.44f * prog * (257.0f / (float)reso.func_78328_b());
                            GL11.glBegin((int)6);
                            GL11.glVertex3d((double)0.0, (double)0.0, (double)zLev);
                            for (i2 = 0; i2 <= roundness; ++i2) {
                                angle = Math.PI * 2 * (double)i2 / (double)roundness;
                                GL11.glVertex3d((double)(Math.cos(angle) * reso.func_78324_d() / reso.func_78327_c() * (double)rad), (double)(Math.sin(angle) * (double)rad), (double)zLev);
                            }
                            GL11.glEnd();
                            GL11.glStencilMask((int)0);
                            GL11.glStencilFunc((int)514, (int)stencilMask, (int)stencilMask);
                            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                        }
                        rad = (mag > magAcceptance ? 0.85f : 0.82f) * prog * (257.0f / (float)reso.func_78328_b());
                        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)(mag > magAcceptance ? 0.6f : 0.4f));
                        GL11.glBegin((int)6);
                        GL11.glVertex3d((double)0.0, (double)0.0, (double)zLev);
                        for (i = 0; i <= roundness; ++i) {
                            double angle = Math.PI * 2 * (double)i / (double)roundness;
                            GL11.glVertex3d((double)(Math.cos(angle) * reso.func_78324_d() / reso.func_78327_c() * (double)rad), (double)(Math.sin(angle) * (double)rad), (double)zLev);
                        }
                        GL11.glEnd();
                        if (stencilBit >= 0) {
                            GL11.glDisable((int)2960);
                        }
                        MinecraftForgeClient.releaseStencilBit((int)stencilBit);
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        GlStateManager.func_179121_F();
                        GlStateManager.func_179128_n((int)5888);
                        GlStateManager.func_179121_F();
                        GlStateManager.func_179084_k();
                        GlStateManager.func_179098_w();
                    }
                    GlStateManager.func_179094_E();
                    double radialAngle = -720.0;
                    if (mag > magAcceptance) {
                        double aSin = Math.toDegrees(Math.asin(Sync.eventHandlerClient.radialDeltaX));
                        if (Sync.eventHandlerClient.radialDeltaY >= 0.0 && Sync.eventHandlerClient.radialDeltaX >= 0.0) {
                            radialAngle = aSin;
                        } else if (Sync.eventHandlerClient.radialDeltaY < 0.0 && Sync.eventHandlerClient.radialDeltaX >= 0.0) {
                            radialAngle = 90.0 + (90.0 - aSin);
                        } else if (Sync.eventHandlerClient.radialDeltaY < 0.0 && Sync.eventHandlerClient.radialDeltaX < 0.0) {
                            radialAngle = 180.0 - aSin;
                        } else if (Sync.eventHandlerClient.radialDeltaY >= 0.0 && Sync.eventHandlerClient.radialDeltaX < 0.0) {
                            radialAngle = 270.0 + (90.0 + aSin);
                        }
                    }
                    if (mag > 0.9999999) {
                        mag = Math.round(mag);
                    }
                    GlStateManager.func_179126_j();
                    GL11.glEnable((int)2929);
                    GL11.glEnable((int)3008);
                    ArrayList<ShellState> selectedShells = new ArrayList<ShellState>(this.shells);
                    Collections.sort(selectedShells);
                    for (int i3 = selectedShells.size() - 1; i3 >= 0; --i3) {
                        ShellState state = selectedShells.get(i3);
                        if (state.playerState == null || state.dimension != mc.field_71441_e.field_73011_w.getDimension() && (Sync.config.allowCrossDimensional == 0 || Sync.config.allowCrossDimensional == 1 && (state.dimension == 1 && mc.field_71441_e.field_73011_w.getDimension() != 1 || state.dimension != 1 && mc.field_71441_e.field_73011_w.getDimension() == 1))) {
                            selectedShells.remove(i3);
                        }
                        if (this.lockedStorage == null || !this.lockedStorage.func_174877_v().equals((Object)state.pos) || this.lockedStorage.func_145831_w().field_73011_w.getDimension() != state.dimension) continue;
                        selectedShells.remove(i3);
                    }
                    ShellState selected = null;
                    Sync.eventHandlerClient.forceRender = true;
                    for (i = 0; i < selectedShells.size(); ++i) {
                        double angle = Math.PI * 2 * (double)i / (double)selectedShells.size();
                        angle -= Math.toRadians(90.0);
                        float leeway = 360.0f / (float)selectedShells.size();
                        boolean selectedState = false;
                        if (mag > magAcceptance * 0.75 && (i == 0 && (radialAngle < (double)(leeway / 2.0f) && radialAngle >= 0.0 || radialAngle > (double)(360.0f - leeway / 2.0f)) || i != 0 && radialAngle < (double)(leeway * (float)i + leeway / 2.0f) && radialAngle > (double)(leeway * (float)i - leeway / 2.0f))) {
                            selectedState = true;
                            selected = selectedShells.get(i);
                        }
                        this.drawEntityOnScreen(selectedShells.get(i), (EntityLivingBase)selectedShells.get((int)i).playerState, reso.func_78326_a() / 2 + (int)((double)radius * Math.cos(angle)), (reso.func_78328_b() + 32) / 2 + (int)((double)radius * Math.sin(angle)), 16.0f * prog + (float)(selectedState ? 6.0 * mag : 0.0), 2.0f, 2.0f, event.renderTickTime, selectedState);
                    }
                    Sync.eventHandlerClient.forceRender = false;
                    this.drawSelectedShellText(reso, selected);
                    GlStateManager.func_179121_F();
                }
            }
        }
    }

    public void updateZoom(Entity ent, float f, boolean revert) {
        if (this.zoom && this.zoomTimer <= 0 || this.zoomTimer <= -10) {
            return;
        }
        if (this.zoomDeath && Minecraft.func_71410_x().field_71462_r instanceof GuiGameOver) {
            Minecraft.func_71410_x().field_71439_g.func_70606_j(1.0f);
            Minecraft.func_71410_x().field_71439_g.field_70725_aQ = 0;
            Minecraft.func_71410_x().func_147108_a(null);
        }
        if (!(revert || Minecraft.func_71410_x().field_71462_r == null || Minecraft.func_71410_x().field_71462_r instanceof GuiGameOver || Minecraft.func_71410_x().field_71462_r instanceof GuiChat)) {
            Minecraft.func_71410_x().func_147108_a(null);
        }
        float prog = MathHelper.func_76131_a((float)(((float)(60 - this.zoomTimer) + f) / 60.0f), (float)0.0f, (float)1.0f);
        if (this.zoom) {
            prog = 1.0f - prog;
        }
        float rotProg = 1.0f - MathHelper.func_76131_a((float)((float)Math.pow(1.0f - MathHelper.func_76131_a((float)(prog / (this.zoomDeath ? 0.2f : 0.333f)), (float)0.0f, (float)1.0f), 4.0)), (float)0.0f, (float)1.0f);
        float disProg = 1.0f - MathHelper.func_76131_a((float)((float)Math.pow(1.0f - MathHelper.func_76131_a((float)(prog / (this.zoomDeath ? 0.2f : 0.333f)), (float)0.0f, (float)1.0f), 2.0)), (float)0.0f, (float)1.0f);
        float posYProg = (float)Math.pow(MathHelper.func_76131_a((float)((prog - 0.25f) / 0.75f), (float)0.0f, (float)1.0f), 2.0);
        float pitchProg = (float)Math.pow(MathHelper.func_76131_a((float)((prog - 0.1f) / 0.2f), (float)0.0f, (float)1.0f), 2.0);
        if (!revert) {
            Mouse.getDX();
            Mouse.getDY();
            this.zoomPrevYaw = ent.field_70177_z;
            this.zoomPrevPitch = ent.field_70125_A;
            this.zoomPrevX = ent.field_70165_t;
            this.zoomPrevY = ent.field_70163_u;
            this.zoomPrevZ = ent.field_70161_v;
            this.hideGui = Minecraft.func_71410_x().field_71474_y.field_74319_N;
            Minecraft.func_71410_x().field_71474_y.field_74319_N = true;
        }
        ent.field_70126_B = ent.field_70126_B + (float)(revert ? -1 : 1) * (this.zoomDeath ? 180.0f * rotProg : this.zoomFace.func_176734_d().func_185119_l() + 180.0f * rotProg - this.zoomPrevYaw);
        ent.field_70177_z = ent.field_70177_z + (float)(revert ? -1 : 1) * (this.zoomDeath ? 180.0f * rotProg : this.zoomFace.func_176734_d().func_185119_l() + 180.0f * rotProg - this.zoomPrevYaw);
        if (ent instanceof EntityLivingBase) {
            ((EntityLivingBase)ent).field_70758_at = ent.field_70126_B;
            ((EntityLivingBase)ent).field_70759_as = ent.field_70177_z;
        }
        ent.field_70127_C = ent.field_70127_C + (float)(revert ? -1 : 1) * (90.0f * pitchProg);
        ent.field_70125_A = ent.field_70125_A + (float)(revert ? -1 : 1) * (90.0f * pitchProg);
        if (revert) {
            ent.field_70127_C = ent.field_70125_A = this.zoomPrevPitch;
            Minecraft.func_71410_x().field_71474_y.field_74319_N = this.hideGui;
        }
        ent.field_70137_T = ent.field_70137_T + (double)(revert ? -1 : 1) * (600.0 * (double)posYProg);
        ent.field_70167_r = ent.field_70167_r + (double)(revert ? -1 : 1) * (600.0 * (double)posYProg);
        ent.field_70163_u = ent.field_70163_u + (double)(revert ? -1 : 1) * (600.0 * (double)posYProg);
        switch (this.zoomFace) {
            case SOUTH: {
                ent.field_70136_U = ent.field_70136_U - (double)(revert ? -1 : 1) * (1.5 * (double)disProg);
                ent.field_70166_s = ent.field_70166_s - (double)(revert ? -1 : 1) * (1.5 * (double)disProg);
                ent.field_70161_v = ent.field_70161_v - (double)(revert ? -1 : 1) * (1.5 * (double)disProg);
                break;
            }
            case WEST: {
                ent.field_70142_S = ent.field_70142_S + (double)(revert ? -1 : 1) * (1.5 * (double)disProg);
                ent.field_70169_q = ent.field_70169_q + (double)(revert ? -1 : 1) * (1.5 * (double)disProg);
                ent.field_70165_t = ent.field_70165_t + (double)(revert ? -1 : 1) * (1.5 * (double)disProg);
                break;
            }
            case NORTH: {
                ent.field_70136_U = ent.field_70136_U + (double)(revert ? -1 : 1) * (1.5 * (double)disProg);
                ent.field_70166_s = ent.field_70166_s + (double)(revert ? -1 : 1) * (1.5 * (double)disProg);
                ent.field_70161_v = ent.field_70161_v + (double)(revert ? -1 : 1) * (1.5 * (double)disProg);
                break;
            }
            case EAST: {
                ent.field_70142_S = ent.field_70142_S - (double)(revert ? -1 : 1) * (1.5 * (double)disProg);
                ent.field_70169_q = ent.field_70169_q - (double)(revert ? -1 : 1) * (1.5 * (double)disProg);
                ent.field_70165_t = ent.field_70165_t - (double)(revert ? -1 : 1) * (1.5 * (double)disProg);
            }
        }
        if (this.zoomDeath) {
            double motionX = -MathHelper.func_76126_a((float)(this.zoomPrevYaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.zoomPrevPitch / 180.0f * (float)Math.PI));
            double motionZ = MathHelper.func_76134_b((float)(this.zoomPrevYaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.zoomPrevPitch / 180.0f * (float)Math.PI));
            ent.field_70142_S = ent.field_70142_S + (double)(revert ? -1 : 1) * (motionX * 2.0 * (double)disProg);
            ent.field_70169_q = ent.field_70169_q + (double)(revert ? -1 : 1) * (motionX * 2.0 * (double)disProg);
            ent.field_70165_t = ent.field_70165_t + (double)(revert ? -1 : 1) * (motionX * 2.0 * (double)disProg);
            ent.field_70136_U = ent.field_70136_U + (double)(revert ? -1 : 1) * (motionZ * 2.0 * (double)disProg);
            ent.field_70166_s = ent.field_70166_s + (double)(revert ? -1 : 1) * (motionZ * 2.0 * (double)disProg);
            ent.field_70161_v = ent.field_70161_v + (double)(revert ? -1 : 1) * (motionZ * 2.0 * (double)disProg);
        }
    }

    private void drawShellInfo(ShellState state, boolean selected) {
        if (Sync.config.showAllShellInfoInGui <= 0) {
            return;
        }
        if (this.radialShow) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)100.0f);
            if (state != null) {
                String string;
                String prefix;
                float scaleee = 0.75f;
                GlStateManager.func_179152_a((float)scaleee, (float)scaleee, (float)scaleee);
                String string2 = prefix = selected ? TextFormatting.YELLOW.toString() : "";
                if (!state.name.equalsIgnoreCase("")) {
                    string = state.name;
                    Minecraft.func_71410_x().field_71466_p.func_175063_a(prefix + string, (float)((int)(-5.0f - (float)(Minecraft.func_71410_x().field_71466_p.func_78256_a(prefix + string) / 2) * scaleee)), 5.0f, 0xFFFFFF);
                }
                if (Sync.config.showAllShellInfoInGui == 2) {
                    GlStateManager.func_179152_a((float)scaleee, (float)scaleee, (float)scaleee);
                    string = Integer.toString(state.pos.func_177958_n());
                    Minecraft.func_71410_x().field_71466_p.func_175063_a(prefix + string, state.pos.func_177958_n() < 0 ? 2.0f : 8.0f, -52.0f, 0xFFFFFF);
                    string = Integer.toString(state.pos.func_177956_o());
                    Minecraft.func_71410_x().field_71466_p.func_175063_a(prefix + string, state.pos.func_177956_o() < 0 ? 2.0f : 8.0f, -42.0f, 0xFFFFFF);
                    string = Integer.toString(state.pos.func_177952_p());
                    Minecraft.func_71410_x().field_71466_p.func_175063_a(prefix + string, state.pos.func_177952_p() < 0 ? 2.0f : 8.0f, -32.0f, 0xFFFFFF);
                    string = state.dimName;
                    Minecraft.func_71410_x().field_71466_p.func_175063_a(prefix + string, 8.0f, -22.0f, 0xFFFFFF);
                }
                if (state.isHome) {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(txHome);
                    double pX = 10.5;
                    double pY = -10.5;
                    double size = 12.0;
                    GlStateManager.func_179131_c((float)0.95f, (float)0.95f, (float)0.95f, (float)1.0f);
                    Tessellator tessellator = Tessellator.func_178181_a();
                    BufferBuilder buffer = tessellator.func_178180_c();
                    buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                    buffer.func_181662_b(pX, pY + size, 0.0).func_187315_a(0.0, 0.999).func_181669_b(240, 240, 240, 255).func_181675_d();
                    buffer.func_181662_b(pX + size, pY + size, 0.0).func_187315_a(1.0, 0.999).func_181669_b(240, 240, 240, 255).func_181675_d();
                    buffer.func_181662_b(pX + size, pY, 0.0).func_187315_a(1.0, 0.0).func_181669_b(240, 240, 240, 255).func_181675_d();
                    buffer.func_181662_b(pX, pY, 0.0).func_187315_a(0.0, 0.0).func_181669_b(240, 240, 240, 255).func_181675_d();
                    tessellator.func_78381_a();
                }
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    private void drawShellConstructionPercentage(ShellState state) {
        if (this.radialShow) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)100.0f);
            if (state != null) {
                if (state.buildProgress < (float)Sync.config.shellConstructionPowerRequirement) {
                    GlStateManager.func_179094_E();
                    float scaleee = 1.5f;
                    GlStateManager.func_179152_a((float)scaleee, (float)scaleee, (float)scaleee);
                    String name = TextFormatting.RED.toString() + (int)Math.floor(state.buildProgress / (float)Sync.config.shellConstructionPowerRequirement * 100.0f) + "%";
                    Minecraft.func_71410_x().field_71466_p.func_175063_a(name, (float)((int)(6.0f - (float)(Minecraft.func_71410_x().field_71466_p.func_78256_a(name) / 2) * scaleee)), -14.0f, 0xFFFFFF);
                    GlStateManager.func_179121_F();
                } else if (state.isConstructor) {
                    GlStateManager.func_179094_E();
                    float scaleee = 0.75f;
                    GlStateManager.func_179152_a((float)scaleee, (float)scaleee, (float)scaleee);
                    String name = I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]);
                    Minecraft.func_71410_x().field_71466_p.func_175063_a(name, (float)((int)(-3.0f - (float)(Minecraft.func_71410_x().field_71466_p.func_78256_a(name) / 2) * scaleee)), -14.0f, 16762880);
                    GlStateManager.func_179121_F();
                }
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    private void drawSelectedShellText(ScaledResolution reso, ShellState state) {
        if (this.radialShow) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179109_b((float)((float)reso.func_78326_a() / 2.0f), (float)((float)(reso.func_78328_b() - 20) / 2.0f), (float)100.0f);
            if (state != null) {
                GlStateManager.func_179094_E();
                float scaleee = 1.0f;
                GlStateManager.func_179152_a((float)scaleee, (float)scaleee, (float)scaleee);
                int height = 5;
                if (state.name.equalsIgnoreCase("")) {
                    String name = TextFormatting.YELLOW.toString() + state.pos.toString();
                    Minecraft.func_71410_x().field_71466_p.func_175063_a(name, (float)((int)(0.0f - (float)(Minecraft.func_71410_x().field_71466_p.func_78256_a(name) / 2) * scaleee)), (float)height, 0xFFFFFF);
                    name = TextFormatting.YELLOW.toString() + state.dimName;
                    Minecraft.func_71410_x().field_71466_p.func_175063_a(name, (float)((int)(0.0f - (float)(Minecraft.func_71410_x().field_71466_p.func_78256_a(name) / 2) * scaleee)), (float)(height + 10), 0xFFFFFF);
                } else {
                    String name = TextFormatting.YELLOW.toString() + state.pos.toString();
                    Minecraft.func_71410_x().field_71466_p.func_175063_a(name, (float)((int)(0.0f - (float)(Minecraft.func_71410_x().field_71466_p.func_78256_a(name) / 2) * scaleee)), (float)(height - 5), 0xFFFFFF);
                    name = TextFormatting.YELLOW.toString() + state.name;
                    Minecraft.func_71410_x().field_71466_p.func_175063_a(name, (float)((int)(0.0f - (float)(Minecraft.func_71410_x().field_71466_p.func_78256_a(name) / 2) * scaleee)), (float)(height + 5), 0xFFFFFF);
                    name = TextFormatting.YELLOW.toString() + state.dimName;
                    Minecraft.func_71410_x().field_71466_p.func_175063_a(name, (float)((int)(0.0f - (float)(Minecraft.func_71410_x().field_71466_p.func_78256_a(name) / 2) * scaleee)), (float)(height + 15), 0xFFFFFF);
                }
                GlStateManager.func_179121_F();
            } else {
                String name = I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]);
                Minecraft.func_71410_x().field_71466_p.func_175063_a(name, (float)((int)(0.0f - (float)(Minecraft.func_71410_x().field_71466_p.func_78256_a(name) / 2) * 1.0f)), 10.0f, 0xFFFFFF);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    private void drawEntityOnScreen(ShellState state, EntityLivingBase ent, int posX, int posY, float scale, float par4, float par5, float renderTick, boolean isSelected) {
        if (ent != null) {
            boolean hideGui = Minecraft.func_71410_x().field_71474_y.field_74319_N;
            Minecraft.func_71410_x().field_71474_y.field_74319_N = true;
            GL11.glEnable((int)2903);
            GlStateManager.func_179094_E();
            GL11.glDisable((int)3008);
            GlStateManager.func_179109_b((float)posX, (float)posY, (float)50.0f);
            if (Sync.config.showAllShellInfoInGui == 2) {
                GlStateManager.func_179109_b((float)-8.0f, (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            float f2 = ent.field_70761_aq;
            float f3 = ent.field_70177_z;
            float f4 = ent.field_70125_A;
            float f5 = ent.field_70759_as;
            GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            RenderHelper.func_74519_b();
            GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-((float)Math.atan(par5 / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)15.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)25.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            ent.field_70761_aq = (float)Math.atan(par4 / 40.0f) * 20.0f;
            ent.field_70177_z = (float)Math.atan(par4 / 40.0f) * 40.0f;
            ent.field_70125_A = -((float)Math.atan(par5 / 40.0f)) * 20.0f;
            ent.field_70759_as = ent.field_70761_aq;
            GlStateManager.func_179109_b((float)0.0f, (float)((float)ent.func_70033_W()), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float viewY = Minecraft.func_71410_x().func_175598_ae().field_78735_i;
            Minecraft.func_71410_x().func_175598_ae().field_78735_i = 180.0f;
            if (!state.isConstructor || !(state.buildProgress < (float)Sync.config.shellConstructionPowerRequirement)) {
                Minecraft.func_71410_x().func_175598_ae().func_188391_a((Entity)ent, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
            } else {
                GlStateManager.func_179094_E();
                float bodyScale = 0.5f;
                GlStateManager.func_179152_a((float)bodyScale, (float)(-bodyScale), (float)(-bodyScale));
                GlStateManager.func_179109_b((float)0.0f, (float)-1.48f, (float)0.0f);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TileRendererDualVertical.txShellConstructor);
                this.modelShellConstructor.rand.setSeed(Minecraft.func_71410_x().field_71439_g.func_70005_c_().hashCode());
                this.modelShellConstructor.txBiped = Minecraft.func_71410_x().field_71439_g.func_110306_p();
                this.modelShellConstructor.renderConstructionProgress(Sync.config.shellConstructionPowerRequirement > 0 ? MathHelper.func_76131_a((float)(state.buildProgress + state.powerReceived * renderTick), (float)0.0f, (float)Sync.config.shellConstructionPowerRequirement) / (float)Sync.config.shellConstructionPowerRequirement : 1.0f, 0.0625f, false, true);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179109_b((float)0.0f, (float)-0.22f, (float)0.0f);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)204.0f, (float)204.0f);
            Minecraft.func_71410_x().func_175598_ae().field_78735_i = viewY;
            ent.field_70761_aq = f2;
            ent.field_70177_z = f3;
            ent.field_70125_A = f4;
            ent.field_70759_as = f5;
            GlStateManager.func_179121_F();
            RenderHelper.func_74518_a();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)posX, (float)posY, (float)50.0f);
            this.drawShellInfo(state, isSelected);
            this.drawShellConstructionPercentage(state);
            GlStateManager.func_179121_F();
            GL11.glEnable((int)3008);
            GlStateManager.func_179101_C();
            OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_179090_x();
            OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
            Minecraft.func_71410_x().field_71474_y.field_74319_N = hideGui;
        }
    }
}

