/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.sync.common.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import me.ichun.mods.ichunutil.common.core.util.EntityHelper;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.morph.api.MorphApi;
import me.ichun.mods.sync.common.Sync;
import me.ichun.mods.sync.common.block.EnumType;
import me.ichun.mods.sync.common.packet.PacketPlayerEnterStorage;
import me.ichun.mods.sync.common.packet.PacketShellDeath;
import me.ichun.mods.sync.common.shell.ShellHandler;
import me.ichun.mods.sync.common.tileentity.TileEntityDualVertical;
import me.ichun.mods.sync.common.tileentity.TileEntityShellConstructor;
import me.ichun.mods.sync.common.tileentity.TileEntityShellStorage;
import me.ichun.mods.sync.common.tileentity.TileEntityTreadmill;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemBed;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemNameTag;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDualVertical
extends BlockContainer {
    public static int renderPass;
    private AxisAlignedBB boundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static final PropertyEnum<EnumType> TYPE;

    public BlockDualVertical() {
        super(Material.field_151573_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)EnumType.CONSTRUCTOR)));
    }

    public TileEntity func_149915_a(World world, int meta) {
        switch (meta) {
            case 0: {
                return new TileEntityShellConstructor();
            }
            case 1: {
                return new TileEntityShellStorage();
            }
            case 2: {
                return new TileEntityTreadmill();
            }
        }
        return this.func_149915_a(world, meta);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityDualVertical && !(player instanceof FakePlayer)) {
            TileEntity tileEntityPair;
            TileEntityDualVertical dualVertical = (TileEntityDualVertical)tileEntity;
            boolean top = dualVertical.top;
            if (top && (tileEntityPair = world.func_175625_s(pos.func_177977_b())) instanceof TileEntityDualVertical) {
                dualVertical = (TileEntityDualVertical)tileEntityPair;
            }
            if (dualVertical instanceof TileEntityShellConstructor) {
                TileEntityShellConstructor shellConstructor = (TileEntityShellConstructor)dualVertical;
                if (shellConstructor.getPlayerName().equalsIgnoreCase("")) {
                    if (iChunUtil.hasMorphMod() && MorphApi.getApiImpl().hasMorph(player.func_70005_c_(), Side.SERVER)) {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("sync.isMorphed", new Object[0]));
                        return true;
                    }
                    shellConstructor.setPlayerName(player.func_70005_c_());
                    if (!world.field_72995_K && !player.func_184812_l_()) {
                        String name = DamageSource.field_76380_i.field_76373_n;
                        DamageSource.field_76380_i.field_76373_n = "shellConstruct";
                        player.func_70097_a(DamageSource.field_76380_i, (float)Sync.config.damageGivenOnShellConstruction);
                        DamageSource.field_76380_i.field_76373_n = name;
                    }
                    BlockDualVertical.notifyThisAndAbove(state, EnumType.CONSTRUCTOR, pos, world, top);
                    return true;
                }
                if (shellConstructor.getPlayerName().equalsIgnoreCase(player.func_70005_c_()) && player.func_184812_l_()) {
                    if (!world.field_72995_K) {
                        shellConstructor.constructionProgress = Sync.config.shellConstructionPowerRequirement;
                        ShellHandler.updatePlayerOfShells(player, null, true);
                        BlockDualVertical.notifyThisAndAbove(state, EnumType.CONSTRUCTOR, pos, world, top);
                    }
                    return true;
                }
            } else if (dualVertical instanceof TileEntityShellStorage) {
                TileEntityShellStorage shellStorage = (TileEntityShellStorage)dualVertical;
                ItemStack itemStack = player.func_184586_b(hand);
                if (!itemStack.func_190926_b()) {
                    if (itemStack.func_77973_b() instanceof ItemNameTag) {
                        EntityPlayerMP entityPlayerMP;
                        if (!itemStack.func_82837_s() && dualVertical.getName().equalsIgnoreCase("") || itemStack.func_82837_s() && dualVertical.getName().equalsIgnoreCase(itemStack.func_82833_r())) {
                            return false;
                        }
                        dualVertical.setName(itemStack.func_82837_s() ? itemStack.func_82833_r() : "");
                        itemStack.func_190918_g(1);
                        if (!player.func_184812_l_() && itemStack.func_190926_b()) {
                            player.func_184201_a(hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                        }
                        BlockDualVertical.notifyThisAndAbove(state, EnumType.STORAGE, pos, world, top);
                        if (!world.field_72995_K && (entityPlayerMP = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(dualVertical.getPlayerName())) != null) {
                            ShellHandler.updatePlayerOfShells((EntityPlayer)entityPlayerMP, null, true);
                        }
                        return true;
                    }
                    if (itemStack.func_77973_b() instanceof ItemBed) {
                        EntityPlayerMP entityPlayerMP;
                        shellStorage.isHomeUnit = !shellStorage.isHomeUnit;
                        BlockDualVertical.notifyThisAndAbove(state, EnumType.STORAGE, pos, world, top);
                        if (!world.field_72995_K && (entityPlayerMP = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(dualVertical.getPlayerName())) != null) {
                            ShellHandler.updatePlayerOfShells((EntityPlayer)entityPlayerMP, null, true);
                        }
                        return true;
                    }
                }
            }
        } else if (tileEntity instanceof TileEntityTreadmill) {
            TileEntityTreadmill treadmill = (TileEntityTreadmill)tileEntity;
            if (treadmill.back) {
                treadmill = treadmill.pair;
            }
            if (treadmill != null && treadmill.latchedEnt == null) {
                double radius = 7.0;
                List list = world.func_72872_a(EntityLiving.class, new AxisAlignedBB((double)pos.func_177958_n() - radius, (double)pos.func_177956_o() - radius, (double)pos.func_177952_p() - radius, (double)pos.func_177958_n() + radius, (double)pos.func_177956_o() + radius, (double)pos.func_177952_p() + radius));
                if (!list.isEmpty()) {
                    for (EntityLiving obj : list) {
                        if (!obj.func_110167_bD() || obj.func_110166_bE() != player || !TileEntityTreadmill.isEntityValidForTreadmill((Entity)obj)) continue;
                        if (!world.field_72995_K) {
                            treadmill.latchedEnt = obj;
                            treadmill.latchedHealth = obj.func_110143_aJ();
                            obj.func_70012_b(treadmill.getMidCoord(0), (double)pos.func_177956_o() + 0.175, treadmill.getMidCoord(1), treadmill.face.func_176734_d().func_185119_l(), 0.0f);
                            world.func_184138_a(pos, state, state.func_177226_a(TYPE, (Comparable)((Object)EnumType.TREADMILL)), 3);
                            obj.func_110160_i(true, !player.func_184812_l_());
                        }
                        return true;
                    }
                }
                ItemStack itemStack = player.func_184586_b(hand);
                if (!world.field_72995_K && !itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ItemMonsterPlacer) {
                    Entity entity;
                    ResourceLocation mob = ItemMonsterPlacer.func_190908_h((ItemStack)itemStack);
                    if (("Pig".equalsIgnoreCase(mob.field_110625_b) || "Wolf".equalsIgnoreCase(mob.field_110625_b)) && TileEntityTreadmill.isEntityValidForTreadmill(entity = ItemMonsterPlacer.func_77840_a((World)world, (ResourceLocation)mob, (double)treadmill.getMidCoord(0), (double)((double)pos.func_177956_o() + 0.175), (double)treadmill.getMidCoord(1)))) {
                        treadmill.latchedEnt = (EntityLiving)entity;
                        treadmill.latchedHealth = ((EntityLiving)entity).func_110143_aJ();
                        entity.func_70012_b(treadmill.getMidCoord(0), (double)pos.func_177956_o() + 0.175, treadmill.getMidCoord(1), treadmill.face.func_176734_d().func_185119_l(), 0.0f);
                        world.func_184138_a(pos, state, state.func_177226_a(TYPE, (Comparable)((Object)EnumType.TREADMILL)), 3);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityShellStorage) {
            TileEntityShellStorage shellStorage = (TileEntityShellStorage)tileEntity;
            if ((shellStorage.top && shellStorage.pair != null && ((TileEntityShellStorage)shellStorage.pair).occupied || shellStorage.occupied) && shellStorage.func_145831_w().field_72995_K && this.isLocalPlayer(shellStorage.getPlayerName())) {
                double dist = this.getDistance(pos);
                double d = shellStorage.top ? 1.1 : 0.6;
                if (dist < d) {
                    this.boundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
                }
            }
        } else if (tileEntity instanceof TileEntityTreadmill) {
            this.boundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.4, 1.0);
        }
        return this.boundingBox;
    }

    @SideOnly(value=Side.CLIENT)
    public double getDistance(BlockPos pos) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        double d3 = player.field_70165_t - ((double)pos.func_177958_n() + 0.5);
        double d4 = player.func_174813_aQ().field_72338_b - (double)pos.func_177956_o();
        double d5 = player.field_70161_v - ((double)pos.func_177952_p() + 0.5);
        return MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!(entity instanceof EntityPlayer) || entity instanceof FakePlayer) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityDualVertical) {
            TileEntityDualVertical dualVertical = (TileEntityDualVertical)tileEntity;
            if (dualVertical.top) {
                TileEntity tileEntityPair = world.func_175625_s(pos.func_177977_b());
                if (tileEntityPair instanceof TileEntityDualVertical) {
                    this.func_180634_a(world, pos.func_177977_b(), state, entity);
                }
            } else if (dualVertical instanceof TileEntityShellStorage) {
                double d5;
                double d4;
                double d3;
                double dist;
                TileEntityShellStorage shellStorage = (TileEntityShellStorage)dualVertical;
                if (!shellStorage.occupied && !world.field_72995_K && !shellStorage.syncing && shellStorage.resyncPlayer <= -10 && (dist = (double)MathHelper.func_76133_a((double)((d3 = entity.field_70165_t - ((double)pos.func_177958_n() + 0.5)) * d3 + (d4 = entity.func_174813_aQ().field_72338_b - (double)pos.func_177956_o()) * d4 + (d5 = entity.field_70161_v - ((double)pos.func_177952_p() + 0.5)) * d5))) < 0.3 && shellStorage.isPowered()) {
                    EntityPlayer player = (EntityPlayer)entity;
                    if (iChunUtil.hasMorphMod() && MorphApi.getApiImpl().hasMorph(player.func_70005_c_(), Side.SERVER)) {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("sync.isMorphed", new Object[0]));
                    } else {
                        Sync.channel.sendTo((AbstractPacket)new PacketPlayerEnterStorage(pos), player);
                        player.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, shellStorage.face.func_176734_d().func_185119_l(), 0.0f);
                    }
                    shellStorage.setPlayerName(player.func_70005_c_());
                    shellStorage.occupied = true;
                    world.func_184138_a(pos, state, state, 3);
                }
            }
        }
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB aabb, List<AxisAlignedBB> list, Entity entity, boolean p_185477_7_) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityDualVertical) {
            TileEntityDualVertical dualVertical = (TileEntityDualVertical)tileEntity;
            boolean top = false;
            if (dualVertical.top) {
                TileEntity tileEntityPair = world.func_175625_s(pos.func_177982_a(0, -1, 0));
                if (tileEntityPair instanceof TileEntityDualVertical) {
                    dualVertical = (TileEntityDualVertical)tileEntityPair;
                }
                top = true;
            }
            if (dualVertical instanceof TileEntityShellConstructor) {
                TileEntityShellConstructor shellConstructor = (TileEntityShellConstructor)dualVertical;
                if (shellConstructor.doorOpen) {
                    this.setDualVerticalCollisionBoxes(dualVertical, 0.05f, top, world, pos, aabb, list, entity, p_185477_7_);
                } else {
                    super.func_185477_a(state, world, pos, aabb, list, entity, p_185477_7_);
                }
            } else if (dualVertical instanceof TileEntityShellStorage) {
                TileEntityShellStorage shellStorage = (TileEntityShellStorage)dualVertical;
                if ((!shellStorage.occupied || world.field_72995_K && this.isLocalPlayer(shellStorage.getPlayerName())) && !shellStorage.syncing) {
                    this.setDualVerticalCollisionBoxes(dualVertical, 0.05f, top, world, pos, aabb, list, entity, p_185477_7_);
                } else {
                    super.func_185477_a(state, world, pos, aabb, list, entity, p_185477_7_);
                }
            }
        } else if (tileEntity instanceof TileEntityTreadmill) {
            this.boundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.175f, 1.0);
            super.func_185477_a(state, world, pos, aabb, list, entity, p_185477_7_);
        }
        this.boundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    private void setDualVerticalCollisionBoxes(TileEntityDualVertical dualVertical, float thickness, boolean isTop, World world, BlockPos pos, AxisAlignedBB aabb, List<AxisAlignedBB> list, Entity entity, boolean p_185477_7_) {
        if (dualVertical.face != EnumFacing.SOUTH) {
            this.boundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, (double)thickness);
            super.func_185477_a(world.func_180495_p(pos), world, pos, aabb, list, entity, p_185477_7_);
        }
        if (dualVertical.face != EnumFacing.WEST) {
            this.boundingBox = new AxisAlignedBB((double)(1.0f - thickness), 0.0, 0.0, 1.0, 1.0, 1.0);
            super.func_185477_a(world.func_180495_p(pos), world, pos, aabb, list, entity, p_185477_7_);
        }
        if (dualVertical.face != EnumFacing.NORTH) {
            this.boundingBox = new AxisAlignedBB(0.0, 0.0, (double)(1.0f - thickness), 1.0, 1.0, 1.0);
            super.func_185477_a(world.func_180495_p(pos), world, pos, aabb, list, entity, p_185477_7_);
        }
        if (dualVertical.face != EnumFacing.EAST) {
            this.boundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, (double)thickness, 1.0, 1.0);
            super.func_185477_a(world.func_180495_p(pos), world, pos, aabb, list, entity, p_185477_7_);
        }
        if (isTop) {
            this.boundingBox = new AxisAlignedBB(0.0, (double)(1.0f - thickness / 2.0f), 0.0, 1.0, 1.0, 1.0);
            super.func_185477_a(world.func_180495_p(pos), world, pos, aabb, list, entity, p_185477_7_);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isLocalPlayer(String playerName) {
        return playerName != null && Minecraft.func_71410_x().field_71439_g != null && playerName.equalsIgnoreCase(Minecraft.func_71410_x().field_71439_g.func_70005_c_());
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityDualVertical) {
            TileEntityDualVertical dualVertical = (TileEntityDualVertical)tileEntity;
            if (!dualVertical.top && !world.func_180495_p(pos.func_177982_a(0, -1, 0)).func_177230_c().func_149662_c(world.func_180495_p(pos.func_177982_a(0, -1, 0)))) {
                world.func_175698_g(pos);
            }
        }
        if (tileEntity instanceof TileEntityTreadmill && world.func_175625_s(pos.func_177982_a(0, -1, 0)) instanceof TileEntityTreadmill) {
            world.func_175698_g(pos);
        }
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityDualVertical) {
            TileEntityDualVertical dualVertical = (TileEntityDualVertical)tileEntity;
            BlockPos newPos = dualVertical.top ? pos.func_177977_b() : pos.func_177984_a();
            TileEntity tileEntityPair = world.func_175625_s(newPos);
            if (tileEntityPair instanceof TileEntityDualVertical) {
                TileEntityDualVertical bottom;
                TileEntityDualVertical dualVerticalPair = (TileEntityDualVertical)tileEntityPair;
                if (dualVerticalPair.pair == dualVertical) {
                    world.func_175718_b(2001, newPos, Block.func_149682_b((Block)Sync.blockDualVertical));
                    world.func_175698_g(newPos);
                }
                TileEntityDualVertical tileEntityDualVertical = bottom = dualVerticalPair.top ? dualVertical : dualVerticalPair;
                if (!bottom.getPlayerName().equalsIgnoreCase("") && !bottom.getPlayerName().equalsIgnoreCase(player.func_70005_c_())) {
                    FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148539_a((ITextComponent)new TextComponentTranslation("sync.breakShellUnit", new Object[]{player.func_70005_c_(), bottom.getPlayerName()}));
                }
                if (!player.func_184812_l_()) {
                    float f = 0.5f;
                    double d = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    BlockPos dualVerticalPos = dualVertical.func_174877_v();
                    EntityItem entityitem = new EntityItem(world, (double)dualVerticalPos.func_177958_n() + d, (double)dualVerticalPos.func_177956_o() + d1, (double)dualVerticalPos.func_177952_p() + d2, new ItemStack(dualVertical instanceof TileEntityShellConstructor ? Sync.itemShellConstructor : Sync.itemShellStorage, 1));
                    entityitem.func_174867_a(10);
                    world.func_72838_d((Entity)entityitem);
                }
            }
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180663_b(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityDualVertical) {
            TileEntityDualVertical dualVertical = (TileEntityDualVertical)tileEntity;
            BlockPos newPos = dualVertical.top ? pos.func_177977_b() : pos.func_177984_a();
            TileEntity tileEntityPair = world.func_175625_s(newPos);
            if (tileEntityPair instanceof TileEntityDualVertical) {
                TileEntityDualVertical dualVerticalBottom;
                TileEntityDualVertical dualVerticalPair = (TileEntityDualVertical)tileEntityPair;
                if (dualVerticalPair.pair == dualVertical) {
                    world.func_175718_b(2001, newPos, Block.func_149682_b((Block)Sync.blockDualVertical));
                    world.func_175698_g(newPos);
                }
                TileEntityDualVertical tileEntityDualVertical = dualVerticalBottom = dualVerticalPair.top ? dualVertical : dualVerticalPair;
                if (!world.field_72995_K) {
                    TileEntityShellConstructor shellConstructor;
                    if (dualVerticalBottom instanceof TileEntityShellStorage && dualVerticalBottom.resyncPlayer == -10 && ((TileEntityShellStorage)dualVertical).syncing && dualVertical.getPlayerNBT().func_74764_b("Inventory")) {
                        FakePlayer fake = new FakePlayer((WorldServer)world, EntityHelper.getGameProfile((String)dualVertical.getPlayerName()));
                        fake.func_70020_e(dualVertical.getPlayerNBT());
                        fake.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, dualVertical.face.func_176734_d().func_185119_l(), 0.0f);
                        fake.captureDrops = true;
                        fake.capturedDrops.clear();
                        fake.field_71071_by.func_70436_m();
                        fake.captureDrops = false;
                        PlayerDropsEvent event = new PlayerDropsEvent((EntityPlayer)fake, DamageSource.field_76380_i, (List)fake.capturedDrops, false);
                        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                            for (EntityItem item : fake.capturedDrops) {
                                fake.func_184816_a(item);
                            }
                        }
                        Sync.channel.sendToAllAround((AbstractPacket)new PacketShellDeath(pos, dualVerticalBottom.face), new NetworkRegistry.TargetPoint(dualVertical.func_145831_w().field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 64.0));
                    } else if (dualVerticalBottom instanceof TileEntityShellConstructor && !(shellConstructor = (TileEntityShellConstructor)dualVerticalBottom).getPlayerName().equalsIgnoreCase("") && shellConstructor.constructionProgress >= (float)Sync.config.shellConstructionPowerRequirement) {
                        Sync.channel.sendToAllAround((AbstractPacket)new PacketShellDeath(dualVerticalBottom.func_174877_v(), dualVerticalBottom.face), new NetworkRegistry.TargetPoint(dualVertical.func_145831_w().field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 64.0));
                    }
                    ShellHandler.removeShell(dualVerticalBottom.getPlayerName(), dualVerticalBottom);
                    if (dualVerticalBottom.resyncPlayer > 25 && dualVerticalBottom.resyncPlayer < 120) {
                        ShellHandler.syncInProgress.remove(dualVerticalBottom.getPlayerName());
                        EntityPlayerMP syncingPlayer = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(dualVertical.getPlayerName());
                        if (syncingPlayer != null) {
                            String name = DamageSource.field_76380_i.field_76373_n;
                            DamageSource.field_76380_i.field_76373_n = "syncFail";
                            syncingPlayer.func_70097_a(DamageSource.field_76380_i, Float.MAX_VALUE);
                            DamageSource.field_76380_i.field_76373_n = name;
                        }
                    }
                }
            }
        } else if (tileEntity instanceof TileEntityTreadmill) {
            TileEntityTreadmill treadmill = (TileEntityTreadmill)tileEntity;
            BlockPos toClean = new BlockPos(treadmill.back ? (treadmill.face == EnumFacing.WEST ? pos.func_177958_n() + 1 : (treadmill.face == EnumFacing.EAST ? pos.func_177958_n() - 1 : pos.func_177958_n())) : (treadmill.face == EnumFacing.WEST ? pos.func_177958_n() - 1 : (treadmill.face == EnumFacing.EAST ? pos.func_177958_n() + 1 : pos.func_177958_n())), pos.func_177956_o(), treadmill.back ? (treadmill.face == EnumFacing.SOUTH ? pos.func_177952_p() - 1 : (treadmill.face == EnumFacing.NORTH ? pos.func_177952_p() + 1 : pos.func_177952_p())) : (treadmill.face == EnumFacing.SOUTH ? pos.func_177952_p() + 1 : (treadmill.face == EnumFacing.NORTH ? pos.func_177952_p() - 1 : pos.func_177952_p())));
            TileEntity tileEntityPair = world.func_175625_s(toClean);
            if (tileEntityPair instanceof TileEntityTreadmill) {
                TileEntityTreadmill treadmillPair = (TileEntityTreadmill)tileEntityPair;
                if (treadmillPair.pair == treadmill) {
                    world.func_175718_b(2001, pos, Block.func_149682_b((Block)Sync.blockDualVertical));
                    world.func_175698_g(toClean);
                }
                if (!treadmillPair.back && !world.field_72995_K) {
                    float f = 0.5f;
                    double d = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + d, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, new ItemStack(Sync.itemTreadmill, 1));
                    entityitem.func_174867_a(10);
                    world.func_72838_d((Entity)entityitem);
                }
            }
        }
        super.func_180663_b(world, pos, state);
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        return new ItemStack(EnumType.getItemForType((EnumType)((Object)world.func_180495_p(pos).func_177229_b(TYPE))), 1);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        if (world.func_175625_s(pos) instanceof TileEntityDualVertical) {
            TileEntityDualVertical tileEntityDualVertical = (TileEntityDualVertical)world.func_175625_s(pos);
            return (int)Math.floor(tileEntityDualVertical.getBuildProgress() / (float)(Sync.config.shellConstructionPowerRequirement / 15));
        }
        return 0;
    }

    public boolean isSideSolid(IBlockState base_state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing side) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityDualVertical) {
            TileEntityDualVertical dualVertical = (TileEntityDualVertical)tileEntity;
            if (side == EnumFacing.DOWN || side == EnumFacing.UP) {
                return true;
            }
            if (!(tileEntity instanceof TileEntityShellConstructor)) {
                return side == dualVertical.face;
            }
        }
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public int func_176201_c(IBlockState state) {
        switch ((EnumType)((Object)state.func_177229_b(TYPE))) {
            case CONSTRUCTOR: {
                return 0;
            }
            case STORAGE: {
                return 1;
            }
            case TREADMILL: {
                return 2;
            }
        }
        throw new RuntimeException("Unknown state value " + state.func_177229_b(TYPE));
    }

    public IBlockState func_176203_a(int meta) {
        switch (meta) {
            case 0: {
                return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.CONSTRUCTOR));
            }
            case 1: {
                return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.STORAGE));
            }
            case 2: {
                return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.TREADMILL));
            }
        }
        throw new RuntimeException("Don't know how to convert " + meta + " to state");
    }

    private static void notifyThisAndAbove(IBlockState oldState, EnumType newType, BlockPos thisPos, World world, boolean isTop) {
        BlockPos other = isTop ? thisPos.func_177977_b() : thisPos.func_177984_a();
        IBlockState above = world.func_180495_p(other);
        world.func_184138_a(thisPos, oldState, oldState.func_177226_a(TYPE, (Comparable)((Object)newType)), 3);
        world.func_184138_a(other, above, above.func_177226_a(TYPE, (Comparable)((Object)newType)), 3);
    }

    static {
        TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);
    }
}

