/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.sync.common.core;

import java.util.ArrayList;
import java.util.Map;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import me.ichun.mods.sync.common.Sync;
import me.ichun.mods.sync.common.packet.PacketPlayerDeath;
import me.ichun.mods.sync.common.packet.PacketZoomCamera;
import me.ichun.mods.sync.common.shell.ShellHandler;
import me.ichun.mods.sync.common.tileentity.TileEntityDualVertical;
import me.ichun.mods.sync.common.tileentity.TileEntityShellConstructor;
import me.ichun.mods.sync.common.tileentity.TileEntityTreadmill;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;

public class EventHandlerServer {
    @SubscribeEvent
    public void registerItem(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.registerAll((IForgeRegistryEntry[])new Item[]{Sync.itemSyncCore, Sync.itemShellConstructor, Sync.itemShellStorage, Sync.itemTreadmill});
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)Sync.blockDualVertical);
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ShellHandler.updatePlayerOfShells(event.player, null, true);
        EntityPlayerMP entityPlayerMP = (EntityPlayerMP)event.player;
        if (entityPlayerMP.getEntityData().func_74764_b("isDeathSyncing") && entityPlayerMP.getEntityData().func_74767_n("isDeathSyncing")) {
            TileEntityDualVertical tpPosition = EventHandlerServer.getClosestRespawnShell((EntityPlayer)entityPlayerMP);
            if (tpPosition != null) {
                Sync.channel.sendTo((AbstractPacket)new PacketZoomCamera((int)Math.floor(entityPlayerMP.field_70165_t), (int)Math.floor(entityPlayerMP.field_70163_u), (int)Math.floor(entityPlayerMP.field_70161_v), entityPlayerMP.field_71093_bK, EnumFacing.UP, false, true), event.player);
                tpPosition.resyncPlayer = 120;
                Sync.channel.sendToAll((AbstractPacket)new PacketPlayerDeath(entityPlayerMP.func_70005_c_(), true));
                entityPlayerMP.func_70606_j(20.0f);
                if (!ShellHandler.syncInProgress.containsKey(entityPlayerMP.func_70005_c_())) {
                    ShellHandler.syncInProgress.put(entityPlayerMP.func_70005_c_(), tpPosition);
                }
            } else {
                entityPlayerMP.func_70106_y();
                entityPlayerMP.func_70606_j(0.0f);
                entityPlayerMP.getEntityData().func_74757_a("isDeathSyncing", false);
                ShellHandler.syncInProgress.remove(entityPlayerMP.func_70005_c_());
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (ShellHandler.syncInProgress.containsKey(event.player.func_70005_c_())) {
            TileEntityDualVertical tileEntityDualVertical = ShellHandler.syncInProgress.get(event.player.func_70005_c_());
            Sync.LOGGER.log(Level.INFO, String.format("%s logged out mid-sync whilst sync process was at %s", event.player.func_70005_c_(), tileEntityDualVertical.resyncPlayer));
            if (tileEntityDualVertical.resyncPlayer > 60) {
                tileEntityDualVertical.resyncPlayer = -10;
                if (tileEntityDualVertical.resyncOrigin != null) {
                    World world = tileEntityDualVertical.func_145831_w();
                    tileEntityDualVertical.reset();
                    IBlockState thisState = world.func_180495_p(tileEntityDualVertical.func_174877_v());
                    world.func_184138_a(tileEntityDualVertical.func_174877_v(), thisState, thisState, 3);
                    BlockPos up = tileEntityDualVertical.func_174877_v().func_177984_a();
                    IBlockState above = world.func_180495_p(up);
                    world.func_184138_a(up, above, above, 3);
                }
            }
            ShellHandler.syncInProgress.remove(event.player.func_70005_c_());
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        EntityPlayerMP player;
        TileEntityDualVertical tpPosition;
        if (Sync.config.overrideDeathIfThereAreAvailableShells > 0 && event.getEntityLiving() instanceof EntityPlayerMP && !(event.getEntityLiving() instanceof FakePlayer) && !event.getEntityLiving().field_70170_p.field_72995_K && (tpPosition = EventHandlerServer.getClosestRespawnShell((EntityPlayer)(player = (EntityPlayerMP)event.getEntityLiving()))) != null) {
            Sync.channel.sendTo((AbstractPacket)new PacketZoomCamera((int)Math.floor(event.getEntityLiving().field_70165_t), (int)Math.floor(event.getEntityLiving().field_70163_u), (int)Math.floor(event.getEntityLiving().field_70161_v), event.getEntityLiving().field_71093_bK, EnumFacing.UP, false, true), (EntityPlayer)player);
            tpPosition.resyncPlayer = 120;
            Sync.channel.sendToAll((AbstractPacket)new PacketPlayerDeath(event.getEntityLiving().func_70005_c_(), true));
            player.func_70606_j(20.0f);
            if (!ShellHandler.syncInProgress.containsKey(player.func_70005_c_())) {
                player.getEntityData().func_74757_a("isDeathSyncing", true);
                ShellHandler.syncInProgress.put(player.func_70005_c_(), tpPosition);
            }
            NBTTagCompound persistent = player.getEntityData().func_74775_l("PlayerPersisted");
            persistent.func_74768_a("Sync_HealthReduction", persistent.func_74762_e("Sync_HealthReduction") + Sync.config.reduceHealthOnDeathSync);
            player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)persistent);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityAttacked(LivingAttackEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer && event.getSource() != DamageSource.field_76380_i && ShellHandler.syncInProgress.containsKey(event.getEntityLiving().func_70005_c_())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityHurt(LivingHurtEvent event) {
        EntityPlayerMP player;
        if (event.getEntityLiving() instanceof EntityPlayerMP && !(event.getEntityLiving() instanceof FakePlayer) && !event.getEntityLiving().field_70170_p.field_72995_K && (player = (EntityPlayerMP)event.getEntityLiving()).getEntityData().func_74764_b("isDeathSyncing") && player.getEntityData().func_74767_n("isDeathSyncing")) {
            event.setCanceled(true);
            return;
        }
        if (event.getEntityLiving() instanceof EntityPlayer && event.getSource() != DamageSource.field_76380_i && ShellHandler.syncInProgress.containsKey(event.getEntityLiving().func_70005_c_())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        if (ShellHandler.syncInProgress.containsKey(event.getEntityPlayer().func_70005_c_())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        TileEntity tileEntity;
        if (TileEntityTreadmill.isEntityValidForTreadmill(event.getTarget()) && (tileEntity = event.getTarget().field_70170_p.func_175625_s(new BlockPos((int)Math.floor(event.getTarget().field_70165_t), (int)Math.floor(event.getTarget().field_70163_u), (int)Math.floor(event.getTarget().field_70161_v)))) instanceof TileEntityTreadmill) {
            TileEntityTreadmill tm = (TileEntityTreadmill)tileEntity;
            if (tm.back) {
                tm = tm.pair;
            }
            if (tm != null && tm.latchedEnt == event.getTarget()) {
                double velo = 1.3;
                switch (tm.face) {
                    case SOUTH: {
                        tm.latchedEnt.field_70179_y = velo;
                        break;
                    }
                    case WEST: {
                        tm.latchedEnt.field_70159_w = -velo;
                        break;
                    }
                    case NORTH: {
                        tm.latchedEnt.field_70179_y = -velo;
                        break;
                    }
                    case EAST: {
                        tm.latchedEnt.field_70159_w = velo;
                    }
                }
                tm.latchedEnt = null;
                tm.timeRunning = 0;
                IBlockState state = tm.func_145831_w().func_180495_p(tm.func_174877_v());
                tm.func_145831_w().func_184138_a(tm.func_174877_v(), state, state, 3);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onItemToss(ItemTossEvent e) {
        if (ShellHandler.syncInProgress.containsKey(e.getPlayer().func_70005_c_())) {
            e.setCanceled(true);
        }
    }

    public static TileEntityDualVertical getClosestRespawnShell(EntityPlayer player) {
        ArrayList<TileEntityDualVertical> dvs = new ArrayList<TileEntityDualVertical>();
        boolean reiterateShells = false;
        for (Map.Entry e : ShellHandler.playerShells.entries()) {
            if (!((String)e.getKey()).equalsIgnoreCase(player.func_70005_c_())) continue;
            TileEntityDualVertical dv1 = (TileEntityDualVertical)((Object)e.getValue());
            if (dv1.func_145831_w().func_175625_s(dv1.func_174877_v()) == dv1) {
                dvs.add(dv1);
                continue;
            }
            reiterateShells = true;
        }
        if (reiterateShells) {
            ShellHandler.updatePlayerOfShells(player, null, true);
        }
        TileEntityDualVertical nearestCrossDimHome = null;
        TileEntityDualVertical nearestCrossDim = null;
        TileEntityDualVertical nearestDv = null;
        TileEntityDualVertical nearestHome = null;
        TileEntityDualVertical tpPosition = null;
        double crossDimHomeDist = -1.0;
        double crossDimDist = -1.0;
        double dist = -1.0;
        double homeDist = -1.0;
        for (TileEntityDualVertical dv : dvs) {
            if (dv instanceof TileEntityShellConstructor) {
                TileEntityShellConstructor sc = (TileEntityShellConstructor)dv;
                if (Sync.config.overrideDeathIfThereAreAvailableShells == 1 || sc.constructionProgress < (float)Sync.config.shellConstructionPowerRequirement) continue;
            }
            double dvDist = player.func_70011_f((double)dv.func_174877_v().func_177958_n() + 0.5, (double)dv.func_174877_v().func_177956_o(), (double)dv.func_174877_v().func_177952_p() + 0.5);
            if (dv.func_145831_w().field_73011_w.getDimension() == player.field_71093_bK) {
                if (dv.isHomeUnit && (homeDist == -1.0 || dvDist < homeDist)) {
                    nearestHome = dv;
                    homeDist = dvDist;
                }
                if (dist != -1.0 && !(dvDist < dist)) continue;
                nearestDv = dv;
                dist = dvDist;
                continue;
            }
            if (Sync.config.allowCrossDimensional != 1 || player.field_71093_bK == 1 && Sync.config.allowCrossDimensional != 2 || Sync.config.crossDimensionalSyncingOnDeath != 1) continue;
            if (dv.isHomeUnit && (crossDimHomeDist == -1.0 || dvDist < crossDimHomeDist)) {
                nearestCrossDimHome = dv;
                crossDimHomeDist = dvDist;
            }
            if (crossDimDist != -1.0 && !(dvDist < crossDimDist)) continue;
            nearestCrossDim = dv;
            crossDimDist = dvDist;
        }
        if (Sync.config.prioritizeHomeShellOnDeath == 1) {
            if (nearestHome != null) {
                tpPosition = nearestHome;
            } else if (nearestCrossDimHome != null) {
                tpPosition = nearestCrossDimHome;
            }
        }
        if (tpPosition == null) {
            if (nearestDv != null) {
                tpPosition = nearestDv;
            } else if (nearestCrossDim != null) {
                tpPosition = nearestCrossDim;
            }
        }
        return tpPosition;
    }
}

