/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.sync.common.packet;

import io.netty.buffer.ByteBuf;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import me.ichun.mods.sync.common.Sync;
import me.ichun.mods.sync.common.shell.ShellState;
import me.ichun.mods.sync.common.tileentity.TileEntityDualVertical;
import me.ichun.mods.sync.common.tileentity.TileEntityShellStorage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketShellState
extends AbstractPacket {
    public boolean remove;
    public TileEntityDualVertical dv;
    public int x;
    public int y;
    public int z;
    public int dim;
    public float buildProgress;
    public float powerReceived;
    public String name;
    public String dimName;
    public boolean isConstructor;
    public boolean isHome;
    public NBTTagCompound tag;

    public PacketShellState() {
    }

    public PacketShellState(TileEntityDualVertical dv1, boolean remove) {
        this.remove = remove;
        this.dv = dv1;
    }

    public void writeTo(ByteBuf buffer) {
        buffer.writeBoolean(this.remove);
        this.dv.writeShellStateData(buffer);
    }

    public void readFrom(ByteBuf buffer) {
        this.remove = buffer.readBoolean();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.dim = buffer.readInt();
        this.buildProgress = buffer.readFloat();
        this.powerReceived = buffer.readFloat();
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.dimName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.isConstructor = buffer.readBoolean();
        this.isHome = buffer.readBoolean();
        if (!this.isConstructor) {
            this.tag = ByteBufUtils.readTag((ByteBuf)buffer);
        }
    }

    public void execute(Side side, EntityPlayer player) {
        this.handleClient();
    }

    public Side receivingSide() {
        return Side.CLIENT;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClient() {
        Minecraft mc = Minecraft.func_71410_x();
        ShellState state = new ShellState(this.x, this.y, this.z, this.dim);
        if (this.remove) {
            for (int i = Sync.eventHandlerClient.shells.size() - 1; i >= 0; --i) {
                ShellState state1 = Sync.eventHandlerClient.shells.get(i);
                if (!state1.matches(state)) continue;
                Sync.eventHandlerClient.shells.remove(i);
            }
        } else {
            NBTTagCompound tag;
            state.buildProgress = this.buildProgress;
            state.powerReceived = this.powerReceived;
            state.name = this.name;
            state.dimName = this.dimName;
            state.isConstructor = this.isConstructor;
            state.isHome = this.isHome;
            boolean add = true;
            for (int i = Sync.eventHandlerClient.shells.size() - 1; i >= 0; --i) {
                ShellState state1 = Sync.eventHandlerClient.shells.get(i);
                if (state1.matches(state)) {
                    Sync.eventHandlerClient.shells.remove(i);
                }
                if (!Sync.eventHandlerClient.shells.contains(state)) {
                    Sync.eventHandlerClient.shells.add(i, state);
                }
                add = false;
            }
            if (add) {
                Sync.eventHandlerClient.shells.add(state);
            }
            state.playerState = TileEntityShellStorage.createPlayer((World)mc.field_71441_e, mc.field_71439_g.func_70005_c_());
            if (!state.isConstructor && (tag = this.tag).func_74764_b("Inventory")) {
                TileEntityDualVertical.addShowableEquipToPlayer(state.playerState, tag);
            }
        }
    }
}

