/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.sync.common.packet;

import io.netty.buffer.ByteBuf;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import me.ichun.mods.sync.api.SyncStartEvent;
import me.ichun.mods.sync.common.Sync;
import me.ichun.mods.sync.common.packet.PacketPlayerDeath;
import me.ichun.mods.sync.common.packet.PacketZoomCamera;
import me.ichun.mods.sync.common.shell.ShellHandler;
import me.ichun.mods.sync.common.tileentity.TileEntityDualVertical;
import me.ichun.mods.sync.common.tileentity.TileEntityShellConstructor;
import me.ichun.mods.sync.common.tileentity.TileEntityShellStorage;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;

public class PacketSyncRequest
extends AbstractPacket {
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public int dimID;
    public int shellPosX;
    public int shellPosY;
    public int shellPosZ;
    public int shellDimID;

    public PacketSyncRequest() {
    }

    public PacketSyncRequest(BlockPos pos, int dimID, BlockPos shellPos, int shellDimID) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dimID, shellPos.func_177958_n(), shellPos.func_177956_o(), shellPos.func_177952_p(), shellDimID);
    }

    public PacketSyncRequest(int xCoord, int yCoord, int zCoord, int dimID, int shellPosX, int shellPosY, int shellPosZ, int shellDimID) {
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
        this.dimID = dimID;
        this.shellPosX = shellPosX;
        this.shellPosY = shellPosY;
        this.shellPosZ = shellPosZ;
        this.shellDimID = shellDimID;
    }

    public void writeTo(ByteBuf buffer) {
        buffer.writeInt(this.xCoord);
        buffer.writeInt(this.yCoord);
        buffer.writeInt(this.zCoord);
        buffer.writeInt(this.dimID);
        buffer.writeInt(this.shellPosX);
        buffer.writeInt(this.shellPosY);
        buffer.writeInt(this.shellPosZ);
        buffer.writeInt(this.shellDimID);
    }

    public void readFrom(ByteBuf buffer) {
        this.xCoord = buffer.readInt();
        this.yCoord = buffer.readInt();
        this.zCoord = buffer.readInt();
        this.dimID = buffer.readInt();
        this.shellPosX = buffer.readInt();
        this.shellPosY = buffer.readInt();
        this.shellPosZ = buffer.readInt();
        this.shellDimID = buffer.readInt();
    }

    public void execute(Side side, EntityPlayer player) {
        boolean valid = false;
        WorldServer worldOri = DimensionManager.getWorld((int)this.dimID);
        WorldServer world = DimensionManager.getWorld((int)this.shellDimID);
        if (worldOri != null && world != null) {
            BlockPos pos = new BlockPos(this.xCoord, this.yCoord, this.zCoord);
            BlockPos shellPos = new BlockPos(this.shellPosX, this.shellPosY, this.shellPosZ);
            TileEntity oriTe = worldOri.func_175625_s(pos);
            TileEntity te = world.func_175625_s(shellPos);
            if (oriTe instanceof TileEntityDualVertical && te instanceof TileEntityDualVertical) {
                TileEntityDualVertical originShell = (TileEntityDualVertical)oriTe;
                TileEntityDualVertical targetShell = (TileEntityDualVertical)te;
                if (originShell.getPlayerName().equalsIgnoreCase(player.func_70005_c_()) && targetShell.getPlayerName().equalsIgnoreCase(player.func_70005_c_())) {
                    TileEntityShellStorage ss;
                    if (targetShell instanceof TileEntityShellConstructor) {
                        TileEntityShellConstructor sc = (TileEntityShellConstructor)targetShell;
                        if (sc.constructionProgress < (float)Sync.config.shellConstructionPowerRequirement) {
                            ShellHandler.updatePlayerOfShells(player, null, true);
                            return;
                        }
                    }
                    if (targetShell instanceof TileEntityShellStorage) {
                        ss = (TileEntityShellStorage)targetShell;
                        if (!ss.syncing) {
                            ShellHandler.updatePlayerOfShells(player, null, true);
                            return;
                        }
                    }
                    if (originShell instanceof TileEntityShellStorage) {
                        ss = (TileEntityShellStorage)originShell;
                        ss.setPlayerName(player.func_70005_c_());
                        ss.occupied = true;
                        ss.occupationTime = 40;
                        ss.syncing = true;
                        player.func_70066_B();
                        NBTTagCompound tag = new NBTTagCompound();
                        player.func_189511_e(tag);
                        tag.func_74768_a("sync_playerGameMode", ((EntityPlayerMP)player).field_71134_c.func_73081_b().func_77148_a());
                        ss.setPlayerNBT(tag);
                        IBlockState state = worldOri.func_180495_p(ss.func_174877_v());
                        IBlockState state1 = worldOri.func_180495_p(ss.func_174877_v().func_177972_a(EnumFacing.UP));
                        worldOri.func_184138_a(ss.func_174877_v(), state, state, 3);
                        worldOri.func_184138_a(ss.func_174877_v().func_177972_a(EnumFacing.UP), state1, state1, 3);
                    }
                    Sync.channel.sendTo((AbstractPacket)new PacketZoomCamera(this.xCoord, this.yCoord, this.zCoord, this.dimID, originShell.face, false, false), player);
                    targetShell.resyncPlayer = 120;
                    originShell.canSavePlayer = -1;
                    targetShell.resyncOrigin = originShell;
                    ShellHandler.syncInProgress.put(player.func_70005_c_(), targetShell);
                    MinecraftForge.EVENT_BUS.post((Event)new SyncStartEvent(player, originShell.getPlayerNBT(), targetShell.getPlayerNBT(), targetShell.func_174877_v()));
                    Sync.channel.sendToAll((AbstractPacket)new PacketPlayerDeath(player.func_70005_c_(), false));
                    valid = true;
                }
            }
        }
        if (!valid) {
            ShellHandler.updatePlayerOfShells(player, null, true);
        }
    }

    public Side receivingSide() {
        return Side.SERVER;
    }
}

