/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.sync.common.tileentity;

import java.util.List;
import javax.annotation.Nonnull;
import me.ichun.mods.sync.common.Sync;
import me.ichun.mods.sync.common.block.BlockDualVertical;
import me.ichun.mods.sync.common.block.EnumType;
import me.ichun.mods.sync.common.tileentity.TileEntityDualVertical;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityTreadmill
extends TileEntity
implements ITickable {
    public TileEntityTreadmill pair = null;
    public boolean back = false;
    public EnumFacing face = EnumFacing.SOUTH;
    public EntityLiving latchedEnt = null;
    public int latchedEntId;
    public float latchedHealth;
    public int timeRunning;
    public boolean resync = false;

    public void func_73660_a() {
        block36: {
            List list;
            AxisAlignedBB aabb;
            IBlockState state;
            Entity ent;
            block37: {
                if (this.resync) {
                    TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.back ? this.face.func_176734_d() : this.face));
                    if (te != null && te.getClass() == ((Object)((Object)this)).getClass()) {
                        TileEntityTreadmill sc = (TileEntityTreadmill)te;
                        sc.pair = this;
                        this.pair = sc;
                    }
                    if (this.latchedEntId != -1) {
                        if (this.field_145850_b.field_72995_K) {
                            Entity ent2 = this.field_145850_b.func_73045_a(this.latchedEntId);
                            if (ent2 != null && ent2.func_70011_f(this.getMidCoord(0), (double)this.field_174879_c.func_177956_o() + 0.175, this.getMidCoord(1)) < 7.0) {
                                this.latchedEnt = (EntityLiving)ent2;
                                this.latchedHealth = this.latchedEnt.func_110143_aJ();
                            }
                        } else {
                            AxisAlignedBB aabb2 = new AxisAlignedBB(this.getMidCoord(0), (double)this.field_174879_c.func_177956_o() + 0.175, this.getMidCoord(1), this.getMidCoord(0), (double)this.field_174879_c.func_177956_o() + 0.175, this.getMidCoord(1)).func_186662_g(0.4);
                            List list2 = this.field_145850_b.func_72872_a(Entity.class, aabb2);
                            for (Object aList : list2) {
                                ent = (Entity)aList;
                                if (!TileEntityTreadmill.isEntityValidForTreadmill(ent) || !(ent.field_70165_t > aabb2.field_72340_a) || !(ent.field_70165_t < aabb2.field_72336_d) || !(ent.field_70163_u > aabb2.field_72338_b) || !(ent.field_70163_u < aabb2.field_72337_e) || !(ent.field_70161_v > aabb2.field_72339_c) || !(ent.field_70161_v < aabb2.field_72334_f)) continue;
                                this.latchedEnt = (EntityLiving)ent;
                                this.latchedHealth = this.latchedEnt.func_110143_aJ();
                                this.latchedEnt.func_70012_b(this.getMidCoord(0), (double)this.field_174879_c.func_177956_o() + 0.175, this.getMidCoord(1), this.face.func_176734_d().func_185119_l(), 0.0f);
                                state = this.field_145850_b.func_180495_p(this.field_174879_c);
                                this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
                                break;
                            }
                        }
                    } else if (this.latchedEnt != null) {
                        this.latchedEnt = null;
                        this.timeRunning = 0;
                        IBlockState state2 = this.field_145850_b.func_180495_p(this.field_174879_c);
                        this.field_145850_b.func_184138_a(this.field_174879_c, state2, state2, 3);
                    }
                }
                this.resync = false;
                if (this.field_145850_b.field_72995_K && !this.back) {
                    Entity ent3;
                    if (this.latchedEnt == null && this.latchedEntId != -1 && this.field_145850_b.func_72820_D() % 27L == 0L && (ent3 = this.field_145850_b.func_73045_a(this.latchedEntId)) != null && ent3.func_70011_f(this.getMidCoord(0), (double)this.field_174879_c.func_177956_o() + 0.175, this.getMidCoord(1)) < 3.0) {
                        this.latchedEnt = (EntityLiving)ent3;
                        this.latchedHealth = this.latchedEnt.func_110143_aJ();
                    }
                    if (this.latchedEnt != null && this.latchedEnt.field_70128_L && (ent3 = this.field_145850_b.func_73045_a(this.latchedEntId)) != null && ent3.func_70011_f(this.getMidCoord(0), (double)this.field_174879_c.func_177956_o() + 0.175, this.getMidCoord(1)) < 7.0) {
                        this.latchedEnt = (EntityLiving)ent3;
                        this.latchedHealth = this.latchedEnt.func_110143_aJ();
                    }
                    if (this.latchedEnt != null) {
                        this.latchedEnt.func_70012_b(this.getMidCoord(0), (double)this.field_174879_c.func_177956_o() + 0.175, this.getMidCoord(1), this.face.func_176734_d().func_185119_l(), 0.0f);
                        ++this.timeRunning;
                        if (this.timeRunning > 12000) {
                            this.timeRunning = 12000;
                        }
                        if (0.3f + MathHelper.func_76131_a((float)((float)this.timeRunning / 12000.0f), (float)0.0f, (float)1.0f) * 0.7f > this.field_145850_b.field_73012_v.nextFloat()) {
                            this.spawnParticles();
                        }
                    }
                }
                if (this.field_145850_b.field_72995_K || this.back) break block36;
                aabb = this.latchedEnt != null ? this.latchedEnt.func_174813_aQ().func_186664_h(0.1) : new AxisAlignedBB(this.getMidCoord(0), (double)this.field_174879_c.func_177956_o() + 0.175, this.getMidCoord(1), this.getMidCoord(0), (double)this.field_174879_c.func_177956_o() + 0.175, this.getMidCoord(1)).func_72314_b(0.15, 0.005, 0.15);
                list = this.field_145850_b.func_72872_a(Entity.class, aabb);
                if (this.latchedEnt == null) break block36;
                boolean remove = false;
                this.sendRFEnergyToNearbyDevices();
                if (this.latchedEnt instanceof EntityTameable) {
                    EntityTameable entityTameable = (EntityTameable)this.latchedEnt;
                    if (entityTameable.func_70906_o()) {
                        this.timeRunning = 0;
                        IBlockState state3 = this.field_145850_b.func_180495_p(this.field_174879_c);
                        this.field_145850_b.func_184138_a(this.field_174879_c, state3, state3, 3);
                        remove = true;
                    }
                    if (entityTameable.func_70909_n()) {
                        this.latchedEnt.func_70012_b(this.getMidCoord(0), (double)this.field_174879_c.func_177956_o() + 0.175, this.getMidCoord(1), this.face.func_176734_d().func_185119_l(), 0.0f);
                        aabb = this.latchedEnt.func_174813_aQ().func_186664_h(0.1);
                        list = this.field_145850_b.func_72872_a(EntityLivingBase.class, aabb);
                    } else {
                        entityTameable.field_70173_aa = 1200;
                    }
                }
                for (Object aList : list) {
                    ent = (Entity)aList;
                    if (ent == this.latchedEnt || !(ent instanceof EntityLivingBase) || ent instanceof EntityPlayer) continue;
                    double velo = 0.9;
                    switch (this.face) {
                        case SOUTH: {
                            ent.field_70179_y = velo;
                            break;
                        }
                        case WEST: {
                            ent.field_70159_w = -velo;
                            break;
                        }
                        case NORTH: {
                            ent.field_70179_y = -velo;
                            break;
                        }
                        case EAST: {
                            ent.field_70159_w = velo;
                        }
                    }
                    remove = true;
                }
                if (this.latchedEnt != null && (!list.contains(this.latchedEnt) || remove || this.latchedHealth > this.latchedEnt.func_110143_aJ())) {
                    if (this.latchedHealth <= this.latchedEnt.func_110143_aJ()) {
                        double velo = 1.3;
                        switch (this.face) {
                            case SOUTH: {
                                this.latchedEnt.field_70179_y = velo;
                                break;
                            }
                            case WEST: {
                                this.latchedEnt.field_70159_w = -velo;
                                break;
                            }
                            case NORTH: {
                                this.latchedEnt.field_70179_y = -velo;
                                break;
                            }
                            case EAST: {
                                this.latchedEnt.field_70159_w = velo;
                            }
                        }
                    }
                    this.latchedEnt = null;
                    this.timeRunning = 0;
                    IBlockState state4 = this.field_145850_b.func_180495_p(this.field_174879_c);
                    this.field_145850_b.func_184138_a(this.field_174879_c, state4, state4, 3);
                }
                if (this.latchedEnt == null) break block37;
                this.latchedHealth = this.latchedEnt.func_110143_aJ();
                this.latchedEnt.func_70012_b(this.getMidCoord(0), (double)this.field_174879_c.func_177956_o() + 0.175, this.getMidCoord(1), this.face.func_176734_d().func_185119_l(), 0.0f);
                this.latchedEnt.func_70661_as().func_75499_g();
                if (this.timeRunning >= 12000) break block36;
                ++this.timeRunning;
                break block36;
            }
            for (Object aList : list) {
                ent = (Entity)aList;
                if (!TileEntityTreadmill.isEntityValidForTreadmill(ent) || !(ent.field_70165_t > aabb.field_72340_a) || !(ent.field_70165_t < aabb.field_72336_d) || !(ent.field_70163_u > aabb.field_72338_b) || !(ent.field_70163_u < aabb.field_72337_e) || !(ent.field_70161_v > aabb.field_72339_c) || !(ent.field_70161_v < aabb.field_72334_f)) continue;
                this.latchedEnt = (EntityLiving)ent;
                this.latchedHealth = this.latchedEnt.func_110143_aJ();
                this.timeRunning = 0;
                this.latchedEnt.func_70012_b(this.getMidCoord(0), (double)this.field_174879_c.func_177956_o() + 0.175, this.getMidCoord(1), this.face.func_176734_d().func_185119_l(), 0.0f);
                state = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.field_174879_c, state, state.func_177226_a(BlockDualVertical.TYPE, (Comparable)((Object)EnumType.TREADMILL)), 3);
                break;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles() {
        if (this.latchedEnt != null && this.pair != null) {
            double zVelo;
            double xVelo;
            double d = this.face == EnumFacing.EAST ? -30.0 : (xVelo = this.face == EnumFacing.WEST ? 30.0 : 0.0);
            double d2 = this.face == EnumFacing.DOWN ? 30.0 : (zVelo = this.face == EnumFacing.UP ? -30.0 : 0.0);
            if (this.field_145850_b.field_73012_v.nextFloat() < 0.5f) {
                this.field_145850_b.func_175688_a(EnumParticleTypes.BLOCK_CRACK, (double)this.pair.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextDouble(), (double)this.pair.field_174879_c.func_177956_o() + 0.4, (double)this.pair.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextDouble(), xVelo, 0.0, zVelo, new int[]{Block.func_176210_f((IBlockState)Sync.blockDualVertical.func_176223_P().func_177226_a(BlockDualVertical.TYPE, (Comparable)((Object)EnumType.TREADMILL)))});
            } else {
                this.field_145850_b.func_175688_a(EnumParticleTypes.BLOCK_CRACK, (double)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextDouble(), (double)this.field_174879_c.func_177956_o() + 0.4, (double)((float)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat()), xVelo, 0.0, zVelo, new int[]{Block.func_176210_f((IBlockState)Sync.blockDualVertical.func_176223_P().func_177226_a(BlockDualVertical.TYPE, (Comparable)((Object)EnumType.TREADMILL)))});
            }
            if (this.timeRunning == 12000 && this.field_145850_b.field_73012_v.nextFloat() < 0.2f) {
                this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextDouble(), (double)this.field_174879_c.func_177956_o() + 0.4, (double)((float)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat()), xVelo *= 0.01, 0.0, zVelo *= 0.01, new int[0]);
            }
        }
    }

    public double getMidCoord(int i) {
        if (this.back && this.pair != null) {
            return this.pair.getMidCoord(i);
        }
        if (i == 0) {
            return this.face == EnumFacing.WEST ? (double)this.field_174879_c.func_177958_n() : (this.face == EnumFacing.EAST ? (double)(this.field_174879_c.func_177958_n() + 1) : (double)this.field_174879_c.func_177958_n() + 0.5);
        }
        return this.face == EnumFacing.SOUTH ? (double)(this.field_174879_c.func_177952_p() + 1) : (this.face == EnumFacing.NORTH ? (double)this.field_174879_c.func_177952_p() : (double)this.field_174879_c.func_177952_p() + 0.5);
    }

    public float powerOutput() {
        if (this.back && this.pair != null) {
            return this.pair.powerOutput();
        }
        float power = 0.0f;
        if (this.latchedEnt != null) {
            power = Sync.TREADMILL_ENTITY_HASH_MAP.get(this.latchedEnt.getClass()).intValue();
            if (this.latchedEnt instanceof EntityTameable && ((EntityTameable)this.latchedEnt).func_70909_n()) {
                power = power / 2.0f + power / 4.0f;
            }
            power += MathHelper.func_76131_a((float)((float)this.timeRunning / 12000.0f), (float)0.0f, (float)1.0f) * 2.0f;
        }
        return power;
    }

    public void setup(TileEntityTreadmill sc, boolean b, EnumFacing face2) {
        this.pair = sc;
        this.back = b;
        this.face = face2;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        tag = this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, tag);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74757_a("back", this.back);
        tag.func_74768_a("face", this.face.func_176745_a());
        tag.func_74768_a("latchedID", this.latchedEnt != null ? this.latchedEnt.func_145782_y() : -1);
        tag.func_74768_a("timeRunning", this.timeRunning);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.back = tag.func_74767_n("back");
        this.face = EnumFacing.func_82600_a((int)tag.func_74762_e("face"));
        this.latchedEntId = tag.func_74762_e("latchedID");
        this.timeRunning = tag.func_74762_e("timeRunning");
        this.resync = true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 1), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 1), (double)(this.field_174879_c.func_177958_n() + 2), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 2));
    }

    public Block func_145838_q() {
        return Sync.blockDualVertical;
    }

    public static boolean isEntityValidForTreadmill(Entity entity) {
        return Sync.TREADMILL_ENTITY_HASH_MAP.containsKey(entity.getClass()) && !((EntityLiving)entity).func_70631_g_() && (!(entity instanceof EntityTameable) || !((EntityTameable)entity).func_70906_o());
    }

    private void sendRFEnergyToNearbyDevices() {
        float power = this.powerOutput() / (float)Sync.config.ratioRF;
        int handlerCount = 0;
        IEnergyStorage[] handlers = new IEnergyStorage[EnumFacing.field_82609_l.length];
        for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
            TileEntity te;
            if (enumFacing == EnumFacing.UP || (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(enumFacing))) == null || te instanceof TileEntityDualVertical || !te.hasCapability(CapabilityEnergy.ENERGY, enumFacing)) continue;
            IEnergyStorage energy = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, enumFacing.func_176734_d());
            ++handlerCount;
            if (energy.receiveEnergy((int)power, true) <= 0) continue;
            handlers[enumFacing.func_176734_d().ordinal()] = energy;
        }
        for (EnumFacing enumFacing : handlers) {
            if (enumFacing == null) continue;
            int energy = Math.max(Math.round(power / (float)handlerCount), 1);
            enumFacing.receiveEnergy(energy, false);
        }
    }
}

