/*
 * Decompiled with CFR 0.152.
 */
package com.robrit.moofluids.client.event;

import com.robrit.moofluids.common.entity.EntityTypeData;
import com.robrit.moofluids.common.util.ColorHelper;
import com.robrit.moofluids.common.util.EntityHelper;
import com.robrit.moofluids.common.util.LogHelper;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TextureRegisterEvent {
    private static final String SEPARATOR = "/";
    private static final String TEXTURE_LOCATION = "textures/entity/cow";
    private static final String BASE_TEXTURE = "textures/entity/cow/cow.png";

    public static void modifyTexture(Color colourOverlay, String fluidName) {
        try {
            BufferedImage image = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(BASE_TEXTURE)).func_110527_b());
            File outputPath = new File(Minecraft.func_71410_x().field_71412_D + SEPARATOR + "assets" + SEPARATOR, "moofluids/textures/entity/cow/" + fluidName + ".png");
            if (!outputPath.exists()) {
                int width = image.getWidth();
                int height = image.getHeight();
                Graphics g = image.getGraphics();
                g.setColor(colourOverlay);
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        int pixel = image.getRGB(x, y);
                        if (pixel >> 24 == 0) continue;
                        g.fillRect(x, y, 1, 1);
                    }
                }
                if (!outputPath.getParentFile().exists() && !outputPath.getParentFile().mkdirs()) {
                    return;
                }
                ImageIO.write((RenderedImage)image, "png", outputPath);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void registerTexture(String fluidName) {
        ResourceLocation entityTexture = new ResourceLocation("moofluids", "textures/entity/cow/" + fluidName + ".png");
        EntityTypeData entityTypeData = EntityHelper.getEntityData(fluidName);
        entityTypeData.setTexture(entityTexture);
        EntityHelper.setEntityData(fluidName, entityTypeData);
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Post event) {
        for (Fluid fluid : EntityHelper.getContainableFluids().values()) {
            try {
                String fluidName = fluid.getName();
                EntityTypeData entityTypeData = EntityHelper.getEntityData(fluidName);
                TextureAtlasSprite fluidIcon = event.getMap().func_110572_b(fluid.getStill().toString());
                int fluidColor = fluid.getColor();
                if (fluidColor != -1) {
                    if (entityTypeData != null) {
                        entityTypeData.setOverlay(new Color(fluidColor >> 16 & 0xFF, fluidColor >> 8 & 0xFF, fluidColor & 0xFF, 128).getRGB());
                    }
                } else if (fluidIcon != event.getMap().func_174944_f() && fluidIcon.func_147965_a(0) != null) {
                    Color meanColour = ColorHelper.getMeanColour(fluidIcon.func_147965_a(0));
                    if (entityTypeData != null) {
                        entityTypeData.setOverlay(new Color(meanColour.getRed(), meanColour.getGreen(), meanColour.getBlue(), 128).getRGB());
                    }
                } else if (entityTypeData != null) {
                    entityTypeData.setOverlay(-1);
                }
                EntityHelper.setEntityData(fluidName, entityTypeData);
            }
            catch (Exception ex) {
                LogHelper.error("Encountered an issue when attempting to manipulate texture");
                ex.printStackTrace();
            }
        }
    }
}

