/*
 * Decompiled with CFR 0.152.
 */
package com.robrit.moofluids.common;

import com.robrit.moofluids.common.event.ConfigurationHandler;
import com.robrit.moofluids.common.proxy.IProxy;
import com.robrit.moofluids.common.util.LogHelper;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@Mod(modid="moofluids", name="MooFluids", version="1.12.2-1.7.11.02a", dependencies="after:*;", certificateFingerprint="@FINGERPRINT@", acceptedMinecraftVersions="[1.12.2]")
public class MooFluids {
    @Mod.Instance(value="moofluids")
    private static MooFluids instance;
    @SidedProxy(clientSide="com.robrit.moofluids.client.proxy.ClientProxy", serverSide="com.robrit.moofluids.server.proxy.ServerProxy")
    private static IProxy proxy;

    public static MooFluids getInstance() {
        return instance;
    }

    public static IProxy getProxy() {
        return proxy;
    }

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) {
        ConfigurationHandler.setConfigFile(event.getSuggestedConfigurationFile());
        ConfigurationHandler.init();
        ConfigurationHandler.updateGlobalConfiguration();
        proxy.initContainableFluids();
        ConfigurationHandler.updateFluidConfiguration();
        proxy.registerEntities();
        proxy.registerEntitySpawns();
        proxy.registerEventHandlers();
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) {
        proxy.registerPlugins();
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void invalidFingerprint(FMLFingerprintViolationEvent event) {
        if ("@FINGERPRINT@".equals("@FINGERPRINT@")) {
            LogHelper.error("No fingerprint found!");
        } else {
            LogHelper.warn("Invalid fingerprint found!");
        }
    }

    static {
        FluidRegistry.enableUniversalBucket();
        FluidRegistry.addBucketForFluid((Fluid)FluidRegistry.WATER);
        FluidRegistry.addBucketForFluid((Fluid)FluidRegistry.LAVA);
    }
}

