/*
 * Decompiled with CFR 0.152.
 */
package com.robrit.moofluids.common.entity;

import com.robrit.moofluids.common.entity.EntityTypeData;
import com.robrit.moofluids.common.entity.INamedEntity;
import com.robrit.moofluids.common.util.EntityHelper;
import com.robrit.moofluids.common.util.damage.AttackDamageSource;
import com.robrit.moofluids.common.util.damage.BurnDamageSource;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class EntityFluidCow
extends EntityCow
implements IEntityAdditionalSpawnData,
INamedEntity {
    private static final DataParameter<Integer> DATA_WATCHER_CURRENT_USE_COOLDOWN = EntityDataManager.func_187226_a(EntityFluidCow.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final String ENTITY_NAME = "EntityFluidCow";
    public static final String NBT_TAG_FLUID_NAME = "FluidName";
    public static final String NBT_TAG_NEXT_USE_COOLDOWN = "NextUseCooldown";
    private int nextUseCooldown;
    private Fluid entityFluid;
    private EntityTypeData entityTypeData;

    public EntityFluidCow(World world) {
        super(world);
        this.setEntityTypeData(EntityHelper.getEntityData(this.getEntityFluid().getName()));
        this.setNextUseCooldown(this.entityTypeData.getMaxUseCooldown());
        if (this.getEntityFluid().getTemperature() >= FluidRegistry.LAVA.getTemperature()) {
            this.field_70178_ae = true;
        }
    }

    @Override
    public String getEntityName() {
        return ENTITY_NAME;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_WATCHER_CURRENT_USE_COOLDOWN, (Object)0);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.nextUseCooldown > 0) {
            this.setNextUseCooldown(this.nextUseCooldown - 1);
        }
    }

    public boolean func_184645_a(EntityPlayer entityPlayer, EnumHand hand) {
        if (!this.func_70631_g_() && this.getNextUseCooldown() == 0) {
            ItemStack currentItemStack = entityPlayer.func_184586_b(hand);
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                this.setNextUseCooldown(this.entityTypeData.getMaxUseCooldown());
            }
            if (this.attemptToGetFluidFromCow(currentItemStack, entityPlayer)) {
                return true;
            }
            if (this.attemptToHealCowWithFluidContainer(currentItemStack, entityPlayer)) {
                return true;
            }
            if (this.attemptToBreedCow(currentItemStack, entityPlayer)) {
                return true;
            }
        }
        return false;
    }

    public void func_82167_n(Entity entity) {
        if (this.entityTypeData.canDamageEntities() && !(entity instanceof EntityFluidCow)) {
            this.applyDamagesToEntity(entity);
        }
        super.func_82167_n(entity);
    }

    public void func_70100_b_(EntityPlayer entityPlayer) {
        if (this.entityTypeData.canDamagePlayers()) {
            this.applyDamagesToEntity((Entity)entityPlayer);
        }
        super.func_70100_b_(entityPlayer);
    }

    public boolean func_70097_a(DamageSource damageSource, float damageAmount) {
        EntityPlayer entityPlayer;
        EntityDamageSource entityDamageSource;
        if (damageSource instanceof EntityDamageSource && (entityDamageSource = (EntityDamageSource)damageSource).func_76346_g() instanceof EntityPlayer && (entityPlayer = (EntityPlayer)damageSource.func_76346_g()).func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
            this.applyDamagesToEntity((Entity)entityPlayer);
        }
        return super.func_70097_a(damageSource, damageAmount);
    }

    public boolean func_70877_b(ItemStack currentItemStack) {
        return !currentItemStack.func_190926_b() && currentItemStack.func_77973_b() == this.entityTypeData.getBreedingItem().func_77973_b();
    }

    public boolean func_70878_b(EntityAnimal entityAnimal) {
        if (entityAnimal != this && this.func_70880_s() && entityAnimal.func_70880_s() && entityAnimal instanceof EntityFluidCow) {
            Fluid mateEntityFluid = ((EntityFluidCow)entityAnimal).getEntityFluid();
            if (this.getEntityFluid().getName().equals(mateEntityFluid.getName())) {
                return true;
            }
        }
        return false;
    }

    public EntityFluidCow createChild(EntityAgeable entityAgeable) {
        EntityFluidCow childEntity = new EntityFluidCow(this.field_70170_p);
        childEntity.setEntityFluid(this.entityFluid);
        return childEntity;
    }

    private void applyDamagesToEntity(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            if (this.entityTypeData.canCauseFireDamage()) {
                int ticksOfDamage = 8;
                if (entity instanceof EntityPlayer) {
                    EntityPlayer entityPlayer = (EntityPlayer)entity;
                    int armorInventoryLength = entityPlayer.field_71071_by.field_70460_b.size();
                    for (int currentArmorSlot = 0; currentArmorSlot < armorInventoryLength; ++currentArmorSlot) {
                        if (((ItemStack)entityPlayer.field_71071_by.field_70460_b.get(currentArmorSlot)).func_190926_b()) continue;
                        ticksOfDamage = (byte)(ticksOfDamage - 2);
                    }
                }
                entity.func_70097_a((DamageSource)new BurnDamageSource("burn", (Entity)this), (float)this.entityTypeData.getFireDamageAmount());
                entity.func_70015_d(ticksOfDamage);
            }
            if (this.entityTypeData.canCauseNormalDamage()) {
                entity.func_70097_a((DamageSource)new AttackDamageSource("whacked", (Entity)this), (float)this.entityTypeData.getNormalDamageAmount());
            }
        }
    }

    private boolean attemptToGetFluidFromCow(ItemStack currentItemStack, EntityPlayer entityPlayer) {
        ItemStack filledItemStack;
        IFluidHandlerItem fluidHandlerItem;
        boolean canGetFluid = false;
        if (!currentItemStack.func_190926_b() && this.entityFluid != null && (fluidHandlerItem = FluidUtil.getFluidHandler((ItemStack)(filledItemStack = ItemHandlerHelper.copyStackWithSize((ItemStack)currentItemStack, (int)1)))) != null && fluidHandlerItem.fill(new FluidStack(this.entityFluid, 1000), true) == 1000) {
            filledItemStack = fluidHandlerItem.getContainer();
            currentItemStack.func_190918_g(1);
            if (currentItemStack.func_190926_b()) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, filledItemStack.func_77946_l());
            } else {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)entityPlayer, (ItemStack)filledItemStack.func_77946_l());
            }
            canGetFluid = true;
        }
        return canGetFluid;
    }

    private boolean attemptToHealCowWithFluidContainer(ItemStack currentItemStack, EntityPlayer entityPlayer) {
        FluidStack containedFluid;
        IFluidHandlerItem fluidHandlerItem;
        boolean cowHealed = false;
        if (!currentItemStack.func_190926_b() && this.entityFluid != null && (fluidHandlerItem = FluidUtil.getFluidHandler((ItemStack)currentItemStack)) != null && (containedFluid = fluidHandlerItem.drain(new FluidStack(this.entityFluid, 1000), false)) != null && containedFluid.getFluid().getName().equalsIgnoreCase(this.entityFluid.getName())) {
            fluidHandlerItem.drain(new FluidStack(this.entityFluid, 1000), false);
            ItemStack emptyItemStack = fluidHandlerItem.getContainer();
            currentItemStack.func_190918_g(1);
            if (currentItemStack.func_190926_b()) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, emptyItemStack.func_77946_l());
            } else {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)entityPlayer, (ItemStack)emptyItemStack.func_77946_l());
            }
            this.func_70691_i(4.0f);
            cowHealed = true;
        }
        return cowHealed;
    }

    private boolean attemptToBreedCow(ItemStack currentItemStack, EntityPlayer entityPlayer) {
        if (this.func_70877_b(currentItemStack) && this.func_70874_b() == 0) {
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                currentItemStack.func_190918_g(1);
                if (currentItemStack.func_190926_b()) {
                    entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                }
            }
            this.func_146082_f(entityPlayer);
            return true;
        }
        return false;
    }

    public Fluid getEntityFluid() {
        return this.entityFluid;
    }

    public void setEntityFluid(Fluid entityFluid) {
        this.entityFluid = entityFluid;
    }

    public int getNextUseCooldown() {
        return this.nextUseCooldown;
    }

    public void setNextUseCooldown(int nextUseCooldown) {
        this.field_70180_af.func_187227_b(DATA_WATCHER_CURRENT_USE_COOLDOWN, (Object)nextUseCooldown);
        this.nextUseCooldown = nextUseCooldown;
    }

    public EntityTypeData getEntityTypeData() {
        return this.entityTypeData;
    }

    public void setEntityTypeData(EntityTypeData entityTypeData) {
        this.entityTypeData = entityTypeData;
    }

    @SideOnly(value=Side.CLIENT)
    public int getOverlay() {
        return this.entityTypeData.getOverlay();
    }

    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74778_a(NBT_TAG_FLUID_NAME, this.getEntityFluid().getName());
        nbtTagCompound.func_74768_a(NBT_TAG_NEXT_USE_COOLDOWN, this.getNextUseCooldown());
    }

    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        this.setEntityFluid(EntityHelper.getContainableFluid(nbtTagCompound.func_74779_i(NBT_TAG_FLUID_NAME)));
        this.setNextUseCooldown(nbtTagCompound.func_74762_e(NBT_TAG_NEXT_USE_COOLDOWN));
    }

    public void writeSpawnData(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.entityFluid.getName());
        ByteBufUtils.writeVarInt((ByteBuf)buffer, (int)this.nextUseCooldown, (int)4);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.setEntityFluid(EntityHelper.getContainableFluid(ByteBufUtils.readUTF8String((ByteBuf)additionalData)));
        this.setNextUseCooldown(ByteBufUtils.readVarInt((ByteBuf)additionalData, (int)4));
        this.entityTypeData = EntityHelper.getEntityData(this.getEntityFluid().getName());
    }
}

