/*
 * Decompiled with CFR 0.152.
 */
package com.robrit.moofluids.common.entity.holiday;

import com.robrit.moofluids.common.entity.INamedEntity;
import com.robrit.moofluids.common.util.EntityHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityJumpHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityEasterCow
extends EntityCow
implements INamedEntity {
    public static final String ENTITY_NAME = "EntityEasterCow";
    private int jumpTicks;
    private int jumpDuration;
    private boolean wasOnGround;
    private int currentMoveTypeDuration = 0;

    public EntityEasterCow(World world) {
        super(world);
        this.field_70767_i = new JumpHelper(this);
        this.field_70765_h = new MoveHelper(this);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 2.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, Items.field_151150_bK, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 8.0f, 2.2, 2.2));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityWolf.class, 10.0f, 2.2, 2.2));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f));
    }

    @Override
    public String getEntityName() {
        return ENTITY_NAME;
    }

    protected ResourceLocation func_184647_J() {
        return EntityHelper.getLootTable(this.getEntityName());
    }

    public EntityEasterCow createChild(EntityAgeable entityAgeable) {
        return new EntityEasterCow(this.field_70170_p);
    }

    protected float func_175134_bD() {
        if (!(this.field_70123_F || this.field_70765_h.func_75640_a() && !(this.field_70765_h.func_179919_e() <= this.field_70163_u + 0.5))) {
            Path path = this.field_70699_by.func_75505_d();
            if (path != null && path.func_75873_e() < path.func_75874_d()) {
                Vec3d vec3d = path.func_75878_a((Entity)this);
                if (vec3d.field_72448_b > this.field_70163_u) {
                    return 0.5f;
                }
            }
            return this.field_70765_h.func_75638_b() <= 0.6 ? 0.2f : 0.3f;
        }
        return 0.5f;
    }

    protected void func_70664_aZ() {
        double d1;
        super.func_70664_aZ();
        double moveSpeed = this.field_70765_h.func_75638_b();
        if (moveSpeed > 0.0 && (d1 = this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) < 0.010000000000000002) {
            this.func_191958_b(0.0f, 0.0f, 1.0f, 0.1f);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)1);
        }
    }

    public void setMovementSpeed(double newSpeed) {
        this.func_70661_as().func_75489_a(newSpeed);
        this.field_70765_h.func_75642_a(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f(), newSpeed);
    }

    public void func_70637_d(boolean jumping) {
        super.func_70637_d(jumping);
        if (jumping && !this.func_70090_H()) {
            this.func_184185_a(this.getJumpSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 0.8f);
        }
    }

    public void startJumping() {
        this.func_70637_d(true);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }

    public void func_70619_bc() {
        if (this.currentMoveTypeDuration > 0) {
            --this.currentMoveTypeDuration;
        }
        if (this.field_70122_E) {
            JumpHelper entityEasterCow$jumpHelper;
            EntityLivingBase entityLivingBase;
            if (!this.wasOnGround) {
                this.func_70637_d(false);
                this.checkLandingDelay();
            }
            if (this.currentMoveTypeDuration == 0 && (entityLivingBase = this.func_70638_az()) != null && this.func_70068_e((Entity)entityLivingBase) < 16.0) {
                this.calculateRotationYaw(entityLivingBase.field_70165_t, entityLivingBase.field_70161_v);
                this.field_70765_h.func_75642_a(entityLivingBase.field_70165_t, entityLivingBase.field_70163_u, entityLivingBase.field_70161_v, this.field_70765_h.func_75638_b());
                this.startJumping();
                this.wasOnGround = true;
            }
            if (!(entityEasterCow$jumpHelper = (JumpHelper)this.field_70767_i).getIsJumping()) {
                if (this.field_70765_h.func_75640_a() && this.currentMoveTypeDuration == 0) {
                    Path path = this.field_70699_by.func_75505_d();
                    Vec3d vec3d = new Vec3d(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f());
                    if (path != null && path.func_75873_e() < path.func_75874_d()) {
                        vec3d = path.func_75878_a((Entity)this);
                    }
                    this.calculateRotationYaw(vec3d.field_72450_a, vec3d.field_72449_c);
                    this.startJumping();
                }
            } else if (!entityEasterCow$jumpHelper.canJump()) {
                this.enableJumpControl();
            }
        }
        this.wasOnGround = this.field_70122_E;
    }

    private void calculateRotationYaw(double x, double z) {
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)(z - this.field_70161_v), (double)(x - this.field_70165_t)) * 57.29577951308232) - 90.0f;
    }

    private void enableJumpControl() {
        ((JumpHelper)this.field_70767_i).setCanJump(true);
    }

    private void disableJumpControl() {
        ((JumpHelper)this.field_70767_i).setCanJump(false);
    }

    private void updateMoveTypeDuration() {
        this.currentMoveTypeDuration = this.field_70765_h.func_75638_b() < 2.2 ? 10 : 1;
    }

    private void checkLandingDelay() {
        this.updateMoveTypeDuration();
        this.disableJumpControl();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.func_70637_d(false);
        }
    }

    protected SoundEvent getJumpSound() {
        return SoundEvents.field_187720_cs;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 1) {
            this.func_174808_Z();
            this.jumpDuration = 10;
            this.jumpTicks = 0;
        } else {
            super.func_70103_a(id);
        }
    }

    private static class MoveHelper
    extends EntityMoveHelper {
        private EntityEasterCow theEntity;
        private double nextJumpSpeed;

        public MoveHelper(EntityEasterCow entity) {
            super((EntityLiving)entity);
            this.theEntity = entity;
        }

        public void func_75641_c() {
            if (this.theEntity.field_70122_E && !this.theEntity.field_70703_bu && !((JumpHelper)this.theEntity.field_70767_i).getIsJumping()) {
                this.theEntity.setMovementSpeed(0.0);
            } else if (this.func_75640_a()) {
                this.theEntity.setMovementSpeed(this.nextJumpSpeed);
            }
            super.func_75641_c();
        }

        public void func_75642_a(double x, double y, double z, double speedIn) {
            if (this.theEntity.func_70090_H()) {
                speedIn = 1.5;
            }
            super.func_75642_a(x, y, z, speedIn);
            if (speedIn > 0.0) {
                this.nextJumpSpeed = speedIn;
            }
        }
    }

    private class JumpHelper
    extends EntityJumpHelper {
        private EntityEasterCow theEntity;
        private boolean canJump;

        public JumpHelper(EntityEasterCow entity) {
            super((EntityLiving)entity);
            this.theEntity = entity;
        }

        public boolean getIsJumping() {
            return this.field_75662_b;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean p_180066_1_) {
            this.canJump = p_180066_1_;
        }

        public void func_75661_b() {
            if (this.field_75662_b) {
                this.theEntity.startJumping();
                this.field_75662_b = false;
            }
        }
    }
}

