/*
 * Decompiled with CFR 0.152.
 */
package com.robrit.moofluids.common.event;

import com.robrit.moofluids.common.entity.EntityTypeData;
import com.robrit.moofluids.common.ref.ConfigurationData;
import com.robrit.moofluids.common.util.EntityHelper;
import com.robrit.moofluids.common.util.LogHelper;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigurationHandler {
    private static Configuration configuration;
    private static File configFile;

    public static void init() {
        ConfigurationHandler.setConfiguration(new Configuration(configFile));
    }

    public static void updateConfiguration() {
        ConfigurationHandler.updateGlobalConfiguration();
        ConfigurationHandler.updateFluidConfiguration();
    }

    public static void updateGlobalConfiguration() {
        try {
            configuration.load();
            configuration.addCustomCategoryComment("Fluid Cow Global Spawn Rate", "The chance of Fluid Cows spawning versus other entities. (8 is the same chance as normal Cows)");
            ConfigurationData.GLOBAL_FLUID_COW_SPAWN_RATE_VALUE = configuration.get("Fluid Cow Global Spawn Rate", "Fluid Cow Global Spawn Rate", 8).getInt();
            ConfigurationData.EVENT_ENTITIES_ENABLED_VALUE = configuration.get("Event Entities Enabled", "Event Entities Enabled", true).getBoolean();
        }
        catch (Exception exception) {
            LogHelper.error("Unable to read configuration for MooFluids");
            LogHelper.error(exception);
        }
        finally {
            if (configuration.hasChanged()) {
                configuration.save();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateFluidConfiguration() {
        try {
            configuration.load();
            for (Fluid containableFluid : EntityHelper.getContainableFluids().values()) {
                String containableFluidLocalizedName = containableFluid.getLocalizedName(new FluidStack(containableFluid, 0));
                String entityName = containableFluidLocalizedName + " " + "Cow";
                EntityTypeData entityTypeData = new EntityTypeData();
                entityTypeData.setSpawnable(configuration.get(entityName, "Is Spawnable?", true).getBoolean());
                entityTypeData.setSpawnRate(configuration.get(entityName, "Spawn Rate", 100).getInt());
                entityTypeData.setNormalDamageAmount(configuration.get(entityName, "Normal Damage Amount", 0).getInt());
                entityTypeData.setFireDamageAmount(configuration.get(entityName, "Fire Damage Amount", 0).getInt());
                entityTypeData.setNormalDamageAmount(configuration.get(entityName, "Normal Damage Amount", 0).getInt());
                entityTypeData.setGrowUpTime(configuration.get(entityName, "Grow Up Time", 8000).getInt());
                entityTypeData.setMaxUseCooldown(configuration.get(entityName, "Max Use Cooldown", 4000).getInt());
                entityTypeData.setDamagePlayers(configuration.get(entityName, "Can Damage Player", true).getBoolean());
                entityTypeData.setDamageEntities(configuration.get(entityName, "Can Damage Other Entities", true).getBoolean());
                entityTypeData.setCauseFireDamage(entityTypeData.getFireDamageAmount() > 0);
                entityTypeData.setCauseNormalDamage(entityTypeData.getNormalDamageAmount() > 0);
                EntityHelper.setEntityData(containableFluid.getName(), entityTypeData);
            }
        }
        catch (Exception exception) {
            LogHelper.error("Unable to read configuration for MooFluids");
            LogHelper.error(exception);
        }
        finally {
            if (configuration.hasChanged()) {
                configuration.save();
            }
        }
    }

    public static Configuration getConfiguration() {
        return configuration;
    }

    public static void setConfiguration(Configuration newConfiguration) {
        configuration = newConfiguration;
    }

    public static File getConfigFile() {
        return configFile;
    }

    public static void setConfigFile(File newConfigFile) {
        configFile = newConfigFile;
    }

    @SubscribeEvent
    public static void onConfigurationChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("moofluids")) {
            ConfigurationHandler.updateConfiguration();
        }
    }
}

