/*
 * Decompiled with CFR 0.152.
 */
package com.robrit.moofluids.common.event;

import com.robrit.moofluids.common.entity.EntityFluidCow;
import com.robrit.moofluids.common.entity.EntityTypeData;
import com.robrit.moofluids.common.util.EntityHelper;
import java.util.ArrayList;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EntitySpawnHandler {
    private static final Fluid[] SPAWNABLE_FLUIDS = EntitySpawnHandler.getSpawnableFluids();
    private static final double CUMULATIVE_SPAWN_WEIGHT = EntitySpawnHandler.getCumulativeSpawnWeight();

    @SubscribeEvent
    public void onEntityConstruction(EntityEvent.EntityConstructing event) {
        EntityFluidCow entityFluidCow;
        if (event.getEntity() instanceof EntityFluidCow && (entityFluidCow = (EntityFluidCow)event.getEntity()).getEntityFluid() == null) {
            entityFluidCow.setEntityFluid(EntitySpawnHandler.getEntityFluid());
        }
    }

    private static Fluid getEntityFluid() {
        if (SPAWNABLE_FLUIDS.length > 0) {
            double activationWeight = Math.random() * CUMULATIVE_SPAWN_WEIGHT;
            double accumulatedWeight = 0.0;
            for (Fluid potentialEntityFluid : SPAWNABLE_FLUIDS) {
                EntityTypeData entityData = EntityHelper.getEntityData(potentialEntityFluid.getName());
                if (entityData == null || !((accumulatedWeight += (double)entityData.getSpawnRate()) >= activationWeight)) continue;
                return potentialEntityFluid;
            }
        }
        return null;
    }

    private static Fluid[] getSpawnableFluids() {
        ArrayList<Fluid> spawnableFluids = new ArrayList<Fluid>();
        for (Fluid fluid : EntityHelper.getContainableFluidsArray()) {
            EntityTypeData entityData = EntityHelper.getEntityData(fluid.getName());
            if (entityData == null) continue;
            boolean isSpawnable = entityData.isSpawnable();
            int spawnRate = entityData.getSpawnRate();
            if (!isSpawnable || spawnRate <= 0) continue;
            spawnableFluids.add(fluid);
        }
        return spawnableFluids.toArray(new Fluid[spawnableFluids.size()]);
    }

    private static double getCumulativeSpawnWeight() {
        double cumulativeSpawnWeight = 0.0;
        for (Fluid spawnableFluid : SPAWNABLE_FLUIDS) {
            EntityTypeData entityData = EntityHelper.getEntityData(spawnableFluid.getName());
            if (entityData == null) continue;
            cumulativeSpawnWeight += (double)entityData.getSpawnRate();
        }
        return cumulativeSpawnWeight;
    }
}

