/*
 * Decompiled with CFR 0.152.
 */
package com.robrit.moofluids.common.proxy;

import com.robrit.moofluids.common.entity.EntityFluidCow;
import com.robrit.moofluids.common.entity.holiday.EntityChristmasCow;
import com.robrit.moofluids.common.entity.holiday.EntityEasterCow;
import com.robrit.moofluids.common.entity.holiday.EntityHalloweenCow;
import com.robrit.moofluids.common.entity.holiday.EntityNewYearsCow;
import com.robrit.moofluids.common.entity.holiday.EntityValentinesCow;
import com.robrit.moofluids.common.event.ConfigurationHandler;
import com.robrit.moofluids.common.event.EntitySpawnHandler;
import com.robrit.moofluids.common.plugins.theoneprobe.TheOneProbePlugin;
import com.robrit.moofluids.common.plugins.waila.WailaPlugin;
import com.robrit.moofluids.common.proxy.IProxy;
import com.robrit.moofluids.common.ref.ConfigurationData;
import com.robrit.moofluids.common.util.DateHelper;
import com.robrit.moofluids.common.util.EntityHelper;
import com.robrit.moofluids.common.util.LogHelper;
import java.time.Month;
import net.minecraft.entity.EnumCreatureType;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Loader;

public abstract class CommonProxy
implements IProxy {
    @Override
    public void initContainableFluids() {
        if (FluidRegistry.isUniversalBucketEnabled()) {
            if (FluidRegistry.getBucketFluids().size() > 0) {
                for (Fluid fluid : FluidRegistry.getBucketFluids()) {
                    String fluidName = fluid.getName();
                    if (EntityHelper.hasContainableFluid(fluidName)) continue;
                    EntityHelper.setContainableFluid(fluidName, fluid);
                }
            } else {
                LogHelper.error("No registered fluids found");
            }
        } else {
            throw new UnsupportedOperationException("Forge UniversalBucket must be enabled");
        }
    }

    @Override
    public void registerEventHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)new ConfigurationHandler());
        MinecraftForge.EVENT_BUS.register((Object)new EntitySpawnHandler());
    }

    @Override
    public void registerEntities() {
        if (EntityHelper.getContainableFluidsArray().length > 0) {
            EntityHelper.registerEntity(EntityFluidCow.class, "EntityFluidCow", 64, 1, true, 0xFFFFFF, 0xFFFFFF);
        }
        if (ConfigurationData.EVENT_ENTITIES_ENABLED_VALUE) {
            EntityHelper.registerEntityLootTable("EntityChristmasCow");
            EntityHelper.registerEntity(EntityChristmasCow.class, "EntityChristmasCow", 64, 1, true, 0x228B22, 11404549);
            EntityHelper.registerEntityLootTable("EntityEasterCow");
            EntityHelper.registerEntity(EntityEasterCow.class, "EntityEasterCow", 64, 1, true, 9169583, 8642006);
            EntityHelper.registerEntityLootTable("EntityHalloweenCow");
            EntityHelper.registerEntity(EntityHalloweenCow.class, "EntityHalloweenCow", 64, 1, true, 0x101010, 0xFF0000);
            EntityHelper.registerEntityLootTable("EntityNewYearsCow");
            EntityHelper.registerEntity(EntityNewYearsCow.class, "EntityNewYearsCow", 64, 1, true, 0xC0C0C0, 16766720);
            EntityHelper.registerEntityLootTable("EntityValentinesCow");
            EntityHelper.registerEntity(EntityValentinesCow.class, "EntityValentinesCow", 64, 1, true, 0xDDDDDD, 16726981);
        }
    }

    @Override
    public void registerEntitySpawns() {
        EntityHelper.addSpawnAllBiomes(EntityFluidCow.class, 8, 4, 4, EnumCreatureType.CREATURE);
        if (ConfigurationData.EVENT_ENTITIES_ENABLED_VALUE) {
            if (DateHelper.isDateBetweenBoundaries(16, Month.DECEMBER.getValue(), 28, Month.DECEMBER.getValue())) {
                EntityHelper.addSpawnFromType(EntityChristmasCow.class, 8, 4, 4, EnumCreatureType.CREATURE, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS);
            }
            if (DateHelper.isDateBetweenBoundaries(10, Month.APRIL.getValue(), 24, Month.APRIL.getValue())) {
                EntityHelper.addSpawnFromType(EntityEasterCow.class, 8, 4, 4, EnumCreatureType.CREATURE, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS);
            }
            if (DateHelper.isDateBetweenBoundaries(26, Month.OCTOBER.getValue(), 1, Month.NOVEMBER.getValue())) {
                EntityHelper.addSpawnFromType(EntityHalloweenCow.class, 8, 4, 4, EnumCreatureType.CREATURE, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS);
            }
            if (DateHelper.isDateBetweenBoundaries(29, Month.DECEMBER.getValue(), 4, Month.JANUARY.getValue())) {
                EntityHelper.addSpawnFromType(EntityNewYearsCow.class, 8, 4, 4, EnumCreatureType.CREATURE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS);
            }
            if (DateHelper.isDateBetweenBoundaries(10, Month.FEBRUARY.getValue(), 16, Month.FEBRUARY.getValue())) {
                EntityHelper.addSpawnFromType(EntityValentinesCow.class, 8, 4, 4, EnumCreatureType.CREATURE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS);
            }
        }
    }

    @Override
    public void registerPlugins() {
        if (Loader.isModLoaded((String)"waila")) {
            WailaPlugin.init();
        }
        if (Loader.isModLoaded((String)"theoneprobe")) {
            TheOneProbePlugin.init();
        }
    }
}

