/*
 * Decompiled with CFR 0.152.
 */
package com.robrit.moofluids.common.util;

import com.google.common.base.CaseFormat;
import com.robrit.moofluids.common.MooFluids;
import com.robrit.moofluids.common.entity.EntityTypeData;
import java.util.ArrayList;
import java.util.TreeMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;

public class EntityHelper {
    private static TreeMap<String, Fluid> containableFluids = new TreeMap();
    private static TreeMap<String, EntityTypeData> entityDataMap = new TreeMap();
    private static int registeredEntityId = 0;

    public static TreeMap<String, Fluid> getContainableFluids() {
        return containableFluids;
    }

    public static Fluid[] getContainableFluidsArray() {
        return containableFluids.values().toArray(new Fluid[containableFluids.values().size()]);
    }

    public static Fluid getContainableFluid(String fluidName) {
        if (containableFluids.containsKey(fluidName)) {
            return containableFluids.get(fluidName);
        }
        return null;
    }

    public static void setContainableFluid(String fluidName, Fluid fluid) {
        containableFluids.put(fluidName, fluid);
    }

    public static boolean hasContainableFluid(String fluidName) {
        return containableFluids.containsKey(fluidName);
    }

    public static TreeMap<String, EntityTypeData> getDataForEntities() {
        return entityDataMap;
    }

    public static void setEntityData(String fluidName, EntityTypeData entityTypeData) {
        entityDataMap.put(fluidName, entityTypeData);
    }

    public static boolean hasEntityData(String fluidName) {
        return entityDataMap.containsKey(fluidName);
    }

    public static EntityTypeData getEntityData(String fluidName) {
        if (entityDataMap.containsKey(fluidName)) {
            return entityDataMap.get(fluidName);
        }
        return null;
    }

    public static void registerEntity(Class<? extends Entity> entityClass, String entityName, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("moofluids", entityName), entityClass, (String)("moofluids." + entityName), (int)EntityHelper.getRegisteredEntityId(), (Object)MooFluids.getInstance(), (int)updateFrequency, (int)trackingRange, (boolean)sendsVelocityUpdates);
    }

    public static void registerEntity(Class<? extends Entity> entityClass, String entityName, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int eggPrimary, int eggSecondary) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("moofluids", entityName), entityClass, (String)("moofluids." + entityName), (int)EntityHelper.getRegisteredEntityId(), (Object)MooFluids.getInstance(), (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates, (int)eggPrimary, (int)eggSecondary);
    }

    public static void addSpawnFromType(Class<? extends EntityLiving> entityClass, int weightedProb, int min, int max, EnumCreatureType typeOfCreature, BiomeDictionary.Type ... biomeTypes) {
        ArrayList biomes = new ArrayList();
        for (BiomeDictionary.Type biomeType : biomeTypes) {
            biomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)biomeType));
        }
        EntityRegistry.addSpawn(entityClass, (int)weightedProb, (int)min, (int)max, (EnumCreatureType)typeOfCreature, (Biome[])biomes.toArray(new Biome[biomes.size()]));
    }

    public static void addSpawnAllBiomes(Class<? extends EntityLiving> entityClass, int weightedProb, int min, int max, EnumCreatureType typeOfCreature) {
        IForgeRegistry biomeReg = GameRegistry.findRegistry(Biome.class);
        Biome[] biomes = biomeReg.getValues().toArray(new Biome[biomeReg.getValues().size()]);
        EntityRegistry.addSpawn(entityClass, (int)weightedProb, (int)min, (int)max, (EnumCreatureType)typeOfCreature, (Biome[])biomes);
    }

    public static void registerEntityLootTable(String entityName) {
        LootTableList.func_186375_a((ResourceLocation)EntityHelper.getLootTable(entityName));
    }

    public static ResourceLocation getLootTable(String entityName) {
        String entityNameLocalized = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, entityName);
        return new ResourceLocation("moofluids", "entities/" + entityNameLocalized);
    }

    public static int getRegisteredEntityId() {
        return registeredEntityId++;
    }
}

