/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.component.input;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import org.cyclops.cyclopscore.client.gui.component.button.GuiButtonArrow;
import org.cyclops.cyclopscore.client.gui.component.input.GuiTextFieldExtended;
import org.cyclops.cyclopscore.client.gui.component.input.IInputListener;

public class GuiArrowedListField<E>
extends GuiTextFieldExtended {
    private final boolean arrows;
    private GuiButtonArrow arrowLeft;
    private GuiButtonArrow arrowRight;
    private List<E> elements;
    private int activeElement;
    private IInputListener listener;

    public GuiArrowedListField(int componentId, FontRenderer fontrenderer, int x, int y, int width, int height, boolean arrows, boolean background, List<E> elements) {
        super(componentId, fontrenderer, x, y, width, height, background);
        this.arrows = arrows;
        if (this.arrows) {
            this.arrowLeft = new GuiButtonArrow(0, x, y, GuiButtonArrow.Direction.WEST);
            this.arrowRight = new GuiButtonArrow(1, x + width, y, GuiButtonArrow.Direction.EAST);
            this.arrowRight.field_146128_h -= this.arrowRight.field_146120_f;
        }
        this.func_146185_a(true);
        this.elements = elements;
        this.setActiveElement(0);
    }

    @Override
    public void setListener(IInputListener listener) {
        this.listener = listener;
    }

    public boolean func_146181_i() {
        return false;
    }

    public void setActiveElement(int index) {
        if (index >= this.elements.size()) {
            this.activeElement = -1;
            this.func_146180_a("");
        } else {
            this.activeElement = index;
            this.func_146180_a(this.getActiveElement().toString());
        }
        if (this.listener != null) {
            this.listener.onChanged();
        }
    }

    public E getActiveElement() throws NumberFormatException {
        if (this.activeElement < 0 || this.activeElement >= this.elements.size()) {
            return null;
        }
        return this.elements.get(this.activeElement);
    }

    @Override
    public void drawTextBox(Minecraft minecraft, int mouseX, int mouseY) {
        int offsetX = 0;
        if (this.arrows) {
            this.arrowLeft.func_191745_a(minecraft, mouseX, mouseY, minecraft.func_184121_ak());
            this.arrowRight.func_191745_a(minecraft, mouseX, mouseY, minecraft.func_184121_ak());
            offsetX = this.arrowLeft.field_146120_f;
            this.field_146209_f += offsetX;
            this.field_146218_h -= offsetX * 2;
        }
        super.drawTextBox(minecraft, mouseX, mouseY);
        if (this.arrows) {
            this.field_146209_f -= offsetX;
            this.field_146218_h += offsetX * 2;
        }
    }

    protected void increase() {
        this.setActiveElement((this.activeElement + 1) % this.elements.size());
    }

    protected void decrease() {
        this.setActiveElement((this.activeElement - 1 + this.elements.size()) % this.elements.size());
    }

    @Override
    public boolean func_146192_a(int mouseX, int mouseY, int mouseButton) {
        if (this.arrowRight.func_146116_c(Minecraft.func_71410_x(), mouseX, mouseY)) {
            this.increase();
            return true;
        }
        if (this.arrowLeft.func_146116_c(Minecraft.func_71410_x(), mouseX, mouseY)) {
            this.decrease();
            return true;
        }
        return super.func_146192_a(mouseX, mouseY, mouseButton);
    }
}

