/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.ConfigProperty;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.IChangedCallback;
import org.cyclops.cyclopscore.config.configurable.IConfigurable;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.init.IInitListener;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.init.RecipeHandler;

public class ConfigHandler
extends LinkedHashSet<ExtendedConfig<?>> {
    private final ModBase mod;
    private Configuration config;
    private final LinkedHashSet<ExtendedConfig<?>> processedConfigs = new LinkedHashSet();
    private final Map<String, ExtendedConfig<?>> configDictionary = Maps.newHashMap();
    private final Set<String> categories = Sets.newHashSet();
    private final Map<String, ConfigProperty> commandableProperties = Maps.newHashMap();
    private final Multimap<Class<?>, Pair<IForgeRegistryEntry<?>, Callable<?>>> registryEntriesHolder = Multimaps.newListMultimap((Map)Maps.newIdentityHashMap(), (Supplier)new Supplier<List<Pair<IForgeRegistryEntry<?>, Callable<?>>>>(){

        public List<Pair<IForgeRegistryEntry<?>, Callable<?>>> get() {
            return Lists.newArrayList();
        }
    });
    private boolean registryEventPassed = false;

    public ConfigHandler(ModBase mod) {
        this.mod = mod;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean add(ExtendedConfig<?> e) {
        this.addToConfigDictionary(e);
        return super.add(e);
    }

    public void addToConfigDictionary(ExtendedConfig<?> e) {
        this.configDictionary.put(e.getNamedId(), e);
    }

    public void handle(FMLPreInitializationEvent event) {
        if (this.getConfig() == null) {
            Configuration config = new Configuration(event.getSuggestedConfigurationFile());
            this.setConfig(config);
            config.load();
        }
        this.loadConfig();
    }

    public void addCategory(String category) {
        this.categories.add(category);
    }

    public void loadConfig() {
        for (ExtendedConfig eConfig : this) {
            try {
                this.addCategory(eConfig.getHolderType().getCategory());
                if (eConfig.isHardDisabled()) continue;
                for (ConfigProperty configProperty : eConfig.configProperties) {
                    this.categories.add(configProperty.getCategory());
                    configProperty.save(this.config);
                    if (!configProperty.isCommandable()) continue;
                    this.commandableProperties.put(configProperty.getName(), configProperty);
                }
                eConfig.getHolderType().getElementTypeAction().commonRun(eConfig, this.config);
                if (!eConfig.isEnabled()) continue;
                eConfig.onRegistered();
                this.mod.log(Level.TRACE, "Registered " + eConfig.getNamedId());
                this.processedConfigs.add(eConfig);
                this.mod.addInitListeners(new ConfigInitListener(eConfig));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        this.removeAll(this);
        this.config.save();
    }

    public void polishConfigs() {
        for (ExtendedConfig extendedConfig : this.processedConfigs) {
            ConfigurableType type = extendedConfig.getHolderType();
            type.getElementTypeAction().polish(extendedConfig);
        }
    }

    public void syncProcessedConfigs() {
        for (ExtendedConfig extendedConfig : this.processedConfigs) {
            for (ConfigProperty configProperty : extendedConfig.configProperties) {
                configProperty.save(this.config, false);
            }
            ConfigurableType type = extendedConfig.getHolderType();
            type.getElementTypeAction().preRun(extendedConfig, this.config, false);
        }
        this.getConfig().save();
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void setConfig(Configuration config) {
        this.config = config;
    }

    public Map<String, ExtendedConfig<?>> getDictionary() {
        return this.configDictionary;
    }

    public static boolean isEnabled(Class<? extends ExtendedConfig<?>> config) {
        try {
            return ((ExtendedConfig)config.getField("_instance").get(null)).isEnabled();
        }
        catch (NullPointerException e1) {
            return false;
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
        catch (IllegalAccessException e3) {
            return false;
        }
        catch (NoSuchFieldException e3) {
            return false;
        }
        catch (SecurityException e4) {
            return false;
        }
    }

    @Nullable
    public static ExtendedConfig<?> getConfigFromItem(Item item) {
        if (item instanceof IConfigurable) {
            return ((IConfigurable)item).getConfig();
        }
        Block block = Block.func_149634_a((Item)item);
        if (block != Blocks.field_150350_a && block instanceof IConfigurable) {
            return ((IConfigurable)block).getConfig();
        }
        return null;
    }

    @Nullable
    public static ExtendedConfig<?> getConfigFromFluid(Fluid fluid) {
        if (fluid instanceof IConfigurable) {
            return ((IConfigurable)fluid).getConfig();
        }
        return null;
    }

    public <V extends IForgeRegistryEntry<V>> void registerToRegistry(IForgeRegistry<V> registry, IForgeRegistryEntry<V> entry, @Nullable Callable<?> callback) {
        if (this.registryEventPassed) {
            throw new IllegalStateException(String.format("Tried registering %s after its registration event.", entry.getRegistryName()));
        }
        this.registryEntriesHolder.put((Object)registry.getRegistrySuperType(), (Object)Pair.of(entry, callback));
    }

    public <V extends IForgeRegistryEntry<V>> void registerToRegistry(IForgeRegistry<V> registry, IForgeRegistryEntry<V> entry) {
        this.registerToRegistry(registry, entry, null);
    }

    @SubscribeEvent
    public void onRegistryEvent(RegistryEvent.Register event) {
        RecipeHandler recipeHandler;
        this.registryEventPassed = true;
        IForgeRegistry registry = event.getRegistry();
        this.registryEntriesHolder.get((Object)registry.getRegistrySuperType()).forEach(pair -> {
            registry.register((IForgeRegistryEntry)pair.getLeft());
            try {
                if (pair.getRight() != null) {
                    ((Callable)pair.getRight()).call();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        if (event.getRegistry() == ForgeRegistries.RECIPES && (recipeHandler = this.getMod().getRecipeHandler()) != null) {
            recipeHandler.registerRecipes(this.getMod().getConfigFolder());
        }
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof ConfigHandler && ((ConfigHandler)o).getMod().equals(this.getMod());
    }

    @Override
    public int hashCode() {
        return 1 + this.getMod().hashCode();
    }

    public ModBase getMod() {
        return this.mod;
    }

    public LinkedHashSet<ExtendedConfig<?>> getProcessedConfigs() {
        return this.processedConfigs;
    }

    public Map<String, ExtendedConfig<?>> getConfigDictionary() {
        return this.configDictionary;
    }

    public Set<String> getCategories() {
        return this.categories;
    }

    public Map<String, ConfigProperty> getCommandableProperties() {
        return this.commandableProperties;
    }

    public Multimap<Class<?>, Pair<IForgeRegistryEntry<?>, Callable<?>>> getRegistryEntriesHolder() {
        return this.registryEntriesHolder;
    }

    public boolean isRegistryEventPassed() {
        return this.registryEventPassed;
    }

    public void setRegistryEventPassed(boolean registryEventPassed) {
        this.registryEventPassed = registryEventPassed;
    }

    @Override
    public String toString() {
        return "ConfigHandler(mod=" + this.getMod() + ", config=" + this.getConfig() + ", processedConfigs=" + this.getProcessedConfigs() + ", configDictionary=" + this.getConfigDictionary() + ", categories=" + this.getCategories() + ", commandableProperties=" + this.getCommandableProperties() + ", registryEntriesHolder=" + this.getRegistryEntriesHolder() + ", registryEventPassed=" + this.isRegistryEventPassed() + ")";
    }

    public static class ConfigInitListener
    implements IInitListener {
        private ExtendedConfig<?> config;

        public ConfigInitListener(ExtendedConfig<?> config) {
            this.config = config;
        }

        @Override
        public void onInit(IInitListener.Step step) {
            this.config.onInit(step);
            if (step == IInitListener.Step.POSTINIT) {
                for (ConfigProperty property : this.config.configProperties) {
                    IChangedCallback changedCallback = property.getCallback().getChangedCallback();
                    if (changedCallback == null) continue;
                    changedCallback.onRegisteredPostInit(property.getValue());
                }
            }
        }
    }
}

