/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.extendedconfig;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.init.ModBase;

public abstract class EntityConfig<T extends Entity>
extends ExtendedConfig<EntityConfig<T>> {
    public EntityConfig(ModBase mod, boolean enabled, String namedId, String comment, Class<? extends T> element) {
        super(mod, enabled, namedId, comment, element);
    }

    @Override
    public String getUnlocalizedName() {
        return "entity." + this.getNamedId();
    }

    @Override
    public ConfigurableType getHolderType() {
        return ConfigurableType.ENTITY;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRegistered() {
        super.onRegistered();
        Class<?> clazz = this.getElement();
        RenderingRegistry.registerEntityRenderingHandler(clazz, (IRenderFactory)new IRenderFactory<T>(){

            public Render<? super T> createRenderFor(RenderManager manager) {
                return EntityConfig.this.getRender(manager, Minecraft.func_71410_x().func_175599_af());
            }
        });
    }

    public int getTrackingRange() {
        return 160;
    }

    public int getUpdateFrequency() {
        return 10;
    }

    public boolean sendVelocityUpdates() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract Render<? super T> getRender(RenderManager var1, RenderItem var2);

    @Override
    public IForgeRegistry<?> getRegistry() {
        return ForgeRegistries.ENTITIES;
    }
}

