/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.extendedconfig;

import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.configurable.ConfigurableItem;
import org.cyclops.cyclopscore.config.configurable.IConfigurable;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.IModelProviderConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.ModBase;

public abstract class ItemConfig
extends ExtendedConfig<ItemConfig>
implements IModelProviderConfig {
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation dynamicItemVariantLocation;

    public ItemConfig(ModBase mod, boolean enabled, String namedId, String comment, Class<? extends Item> element) {
        super(mod, enabled, namedId, comment, element);
        if (MinecraftHelpers.isClientSide()) {
            this.dynamicItemVariantLocation = null;
        }
    }

    @Override
    protected IConfigurable<ItemConfig> initSubInstance() {
        return this.getElement() == null ? new ConfigurableItem(this) : super.initSubInstance();
    }

    @Override
    public String getModelName(ItemStack itemStack) {
        return this.getNamedId();
    }

    @Override
    public String getUnlocalizedName() {
        return "items." + this.getMod().getModId() + "." + this.getNamedId();
    }

    @Override
    public String getFullUnlocalizedName() {
        return "item." + this.getUnlocalizedName() + ".name";
    }

    @Override
    public ConfigurableType getHolderType() {
        return ConfigurableType.ITEM;
    }

    public String getOreDictionaryId() {
        return null;
    }

    public Item getItemInstance() {
        return (Item)super.getSubInstance();
    }

    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation registerDynamicModel() {
        String blockName = this.getMod().getModId() + ":" + this.getNamedId();
        ModelResourceLocation itemLocation = new ModelResourceLocation(blockName, "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)this.getItemInstance(), (int)0, (ModelResourceLocation)itemLocation);
        return itemLocation;
    }

    @Override
    public void onForgeRegistered() {
        super.onForgeRegistered();
        if (this.isEnabled() && this.getOreDictionaryId() != null) {
            OreDictionary.registerOre((String)this.getOreDictionaryId(), (ItemStack)new ItemStack(this.getItemInstance()));
        }
    }

    public CreativeTabs getTargetTab() {
        return this.getMod().getDefaultCreativeTab();
    }

    @Override
    public IForgeRegistry<?> getRegistry() {
        return ForgeRegistries.ITEMS;
    }
}

