/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import org.apache.commons.lang3.ArrayUtils;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

public class InventoryHelpers {
    public static void clearInventory(IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            inventory.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    public static void tryReAddToStack(EntityPlayer player, ItemStack originalStack, ItemStack newStackPart) {
        if (!player.field_71075_bZ.field_75098_d) {
            if (!originalStack.func_190926_b() && originalStack.func_190916_E() == 1) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, newStackPart);
            } else {
                if (!originalStack.func_190926_b()) {
                    originalStack.func_190918_g(1);
                }
                if (!player.field_71071_by.func_70441_a(newStackPart)) {
                    player.func_71019_a(newStackPart, false);
                }
            }
        }
    }

    public static void validateNBTStorage(IInventory inventory, ItemStack itemStack, String tagName) {
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            itemStack.func_77982_d(tag);
        }
        if (!tag.func_74764_b(tagName)) {
            tag.func_74782_a(tagName, (NBTBase)new NBTTagList());
        }
        InventoryHelpers.readFromNBT(inventory, tag, tagName);
    }

    public static void readFromNBT(IInventory inventory, NBTTagCompound data, String tagName) {
        int j;
        NBTTagList nbttaglist = data.func_150295_c(tagName, MinecraftHelpers.NBTTag_Types.NBTTagCompound.ordinal());
        for (j = 0; j < inventory.func_70302_i_(); ++j) {
            inventory.func_70299_a(j, ItemStack.field_190927_a);
        }
        for (j = 0; j < nbttaglist.func_74745_c(); ++j) {
            NBTTagCompound slot = nbttaglist.func_150305_b(j);
            int index = slot.func_74764_b("index") ? slot.func_74762_e("index") : (int)slot.func_74771_c("Slot");
            if (index < 0 || index >= inventory.func_70302_i_()) continue;
            inventory.func_70299_a(index, new ItemStack(slot));
        }
    }

    public static void writeToNBT(IInventory inventory, NBTTagCompound data, String tagName) {
        NBTTagList slots = new NBTTagList();
        for (int index = 0; index < inventory.func_70302_i_(); index = (int)((byte)(index + 1))) {
            ItemStack itemStack = inventory.func_70301_a(index);
            if (itemStack.func_190926_b() || itemStack.func_190916_E() <= 0) continue;
            NBTTagCompound slot = new NBTTagCompound();
            slot.func_74768_a("index", index);
            slots.func_74742_a((NBTBase)slot);
            itemStack.func_77955_b(slot);
        }
        data.func_74782_a(tagName, (NBTBase)slots);
    }

    public static ItemStack getItemFromIndex(EntityPlayer player, int itemIndex) {
        return InventoryHelpers.getItemFromIndex(player, itemIndex, EnumHand.MAIN_HAND);
    }

    public static ItemStack getItemFromIndex(EntityPlayer player, int itemIndex, EnumHand hand) {
        return EnumHand.MAIN_HAND.equals((Object)hand) ? (ItemStack)player.field_71071_by.field_70462_a.get(itemIndex) : player.func_184592_cb();
    }

    public static boolean addToSlot(IInventory inventory, int slot, ItemStack itemStack) {
        return InventoryHelpers.addToSlot(inventory, slot, itemStack, false);
    }

    public static ItemStack addToStack(ItemStack itemStack, ItemStack toAdd) {
        if (ItemStack.func_77970_a((ItemStack)toAdd, (ItemStack)itemStack) && ItemStack.func_179545_c((ItemStack)toAdd, (ItemStack)itemStack) && itemStack.func_190916_E() < itemStack.func_77976_d()) {
            toAdd = toAdd.func_77946_l();
            int toAddCount = Math.min(itemStack.func_77976_d() - itemStack.func_190916_E(), toAdd.func_190916_E());
            itemStack.func_190917_f(toAddCount);
            toAdd.func_190918_g(toAddCount);
        }
        return toAdd;
    }

    public static ItemStack fillSlot(IInventory inventory, int slot, ItemStack itemStack, boolean simulate) {
        ItemStack produceStack = inventory.func_70301_a(slot);
        if (produceStack.func_190926_b()) {
            if (!simulate) {
                inventory.func_70299_a(slot, itemStack);
            }
            return ItemStack.field_190927_a;
        }
        produceStack = produceStack.func_77946_l();
        ItemStack remainder = InventoryHelpers.addToStack(produceStack, itemStack);
        if (!simulate && remainder.func_190916_E() != itemStack.func_190916_E()) {
            inventory.func_70299_a(slot, produceStack);
        }
        return remainder;
    }

    public static boolean addToSlot(IInventory inventory, int slot, ItemStack itemStack, boolean simulate) {
        return InventoryHelpers.fillSlot(inventory, slot, itemStack, simulate).func_190926_b();
    }

    public static NonNullList<ItemStack> addToInventory(IInventory inventory, int[] slots, NonNullList<ItemStack> itemStacks, boolean simulate) {
        NonNullList remaining = NonNullList.func_191196_a();
        for (ItemStack itemStack : itemStacks) {
            for (int i = 0; i < slots.length; ++i) {
                int slot = slots[i];
                itemStack = InventoryHelpers.fillSlot(inventory, slot, itemStack, simulate);
                if (simulate) {
                    slots = ArrayUtils.remove((int[])slots, (int)i);
                    --i;
                }
                if (itemStack.func_190926_b()) break;
            }
            if (itemStack.func_190926_b()) continue;
            remaining.add((Object)itemStack);
        }
        return remaining;
    }

    public static void addStackToList(NonNullList<ItemStack> itemStacks, ItemStack itemStack) {
        boolean added = false;
        ItemStack toAdd = itemStack;
        for (ItemStack existingOutputStack : itemStacks) {
            toAdd = InventoryHelpers.addToStack(existingOutputStack, toAdd);
            if (!toAdd.func_190926_b()) continue;
            added = true;
            break;
        }
        if (!added) {
            itemStacks.add((Object)toAdd.func_77946_l());
        }
    }
}

