/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network;

import io.netty.channel.ChannelHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.Packet;
import net.minecraft.util.IThreadListener;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.network.PacketBase;

@ChannelHandler.Sharable
public final class PacketHandler {
    private SimpleNetworkWrapper networkWrapper = null;
    @SideOnly(value=Side.CLIENT)
    private HandlerClient handlerClient;
    private HandlerServer handlerServer;
    private final ModBase mod;

    public PacketHandler(ModBase mod) {
        this.mod = mod;
    }

    public void init() {
        if (this.networkWrapper == null) {
            this.networkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel(this.mod.getModId());
            if (MinecraftHelpers.isClientSide()) {
                this.handlerClient = new HandlerClient();
            }
            this.handlerServer = new HandlerServer();
        }
    }

    public void register(Class<? extends PacketBase> packetType) {
        int discriminator = Helpers.getNewId(this.mod, Helpers.IDType.PACKET);
        if (MinecraftHelpers.isClientSide()) {
            this.networkWrapper.registerMessage((IMessageHandler)this.handlerClient, packetType, discriminator, Side.CLIENT);
        }
        this.networkWrapper.registerMessage((IMessageHandler)this.handlerServer, packetType, discriminator, Side.SERVER);
    }

    public void sendToServer(PacketBase packet) {
        this.networkWrapper.sendToServer((IMessage)packet);
    }

    public void sendToPlayer(PacketBase packet, EntityPlayerMP player) {
        this.networkWrapper.sendTo((IMessage)packet, player);
    }

    public void sendToAllAround(PacketBase packet, NetworkRegistry.TargetPoint point) {
        this.networkWrapper.sendToAllAround((IMessage)packet, point);
    }

    public void sendToDimension(PacketBase packet, int dimension) {
        this.networkWrapper.sendToDimension((IMessage)packet, dimension);
    }

    public void sendToAll(PacketBase packet) {
        this.networkWrapper.sendToAll((IMessage)packet);
    }

    public Packet<?> toMcPacket(PacketBase packet) {
        return this.networkWrapper.getPacketFrom((IMessage)packet);
    }

    @ChannelHandler.Sharable
    private static final class HandlerServer
    implements IMessageHandler<PacketBase, IMessage> {
        private HandlerServer() {
        }

        public IMessage onMessage(PacketBase packet, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                return null;
            }
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            packet.actionServer(player.field_70170_p, player);
            return null;
        }
    }

    @ChannelHandler.Sharable
    @SideOnly(value=Side.CLIENT)
    private static final class HandlerClient
    implements IMessageHandler<PacketBase, IMessage> {
        private HandlerClient() {
        }

        public IMessage onMessage(final PacketBase packet, MessageContext ctx) {
            final Minecraft mc = Minecraft.func_71410_x();
            IThreadListener thread = FMLCommonHandler.instance().getWorldThread((INetHandler)ctx.getClientHandler());
            if (packet.isAsync()) {
                packet.actionClient((World)mc.field_71441_e, (EntityPlayer)mc.field_71439_g);
            } else {
                thread.func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        packet.actionClient((World)mc.field_71441_e, (EntityPlayer)mc.field_71439_g);
                    }
                });
            }
            return null;
        }
    }
}

