/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.recipe.custom.component;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeInput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeOutput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeProperties;
import org.cyclops.cyclopscore.recipe.custom.component.IIngredientRecipeComponent;

public class IngredientRecipeComponent
implements IRecipeInput,
IRecipeOutput,
IRecipeProperties,
IIngredientRecipeComponent {
    private static final int META_WILDCARD = Short.MAX_VALUE;
    private final Ingredient ingredient;
    private float chance;

    public IngredientRecipeComponent(Ingredient ingredient) {
        this.ingredient = Objects.requireNonNull(ingredient);
    }

    public IngredientRecipeComponent(ItemStack itemStack) {
        this(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{itemStack}));
    }

    public boolean equals(Object object) {
        if (!(object instanceof IIngredientRecipeComponent)) {
            return false;
        }
        IIngredientRecipeComponent that = (IIngredientRecipeComponent)object;
        if (this.getIngredient() == Ingredient.field_193370_a && that.getIngredient() == Ingredient.field_193370_a) {
            return true;
        }
        for (ItemStack itemStack : this.getItemStacks()) {
            if (!that.getIngredient().apply(itemStack.func_190926_b() ? null : itemStack)) continue;
            return true;
        }
        return this.getIngredient().apply(that.getFirstItemStack());
    }

    protected boolean equals(ItemStack a, ItemStack b) {
        return a.func_190926_b() && b.func_190926_b() || !a.func_190926_b() && !b.func_190926_b() && a.func_77973_b().equals(b.func_77973_b()) && (a.func_77952_i() == b.func_77952_i() || a.func_77952_i() == Short.MAX_VALUE || b.func_77952_i() == Short.MAX_VALUE);
    }

    public int hashCode() {
        return this.getItemStacks().stream().map(ItemStack::func_77973_b).mapToInt(Object::hashCode).sum() + 876;
    }

    public List<ItemStack> getItemStacks() {
        return Lists.newArrayList((Object[])this.getIngredient().func_193365_a());
    }

    @Override
    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @Override
    public ItemStack getFirstItemStack() {
        ItemStack[] itemStacks = this.ingredient.func_193365_a();
        return itemStacks.length > 0 ? itemStacks[0] : ItemStack.field_190927_a;
    }

    @Override
    public float getChance() {
        return this.chance;
    }

    public void setChance(float chance) {
        this.chance = chance;
    }

    public String toString() {
        return "IngredientRecipeComponent(ingredient=" + this.getIngredient() + ", chance=" + this.getChance() + ")";
    }
}

