/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.util.Comparer;
import com.raoulvdberge.refinedstorage.item.ItemPattern;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class CraftingPattern
implements ICraftingPattern {
    private ICraftingPatternContainer container;
    private ItemStack stack;
    private IRecipe recipe;
    private List<ItemStack> inputs = new ArrayList<ItemStack>();
    private List<List<ItemStack>> oreInputs = new ArrayList<List<ItemStack>>();
    private List<ItemStack> outputs = new ArrayList<ItemStack>();
    private List<ItemStack> byproducts = new ArrayList<ItemStack>();
    private Integer hashCodeCached = null;

    public CraftingPattern(World world, ICraftingPatternContainer container, ItemStack stack) {
        this.container = container;
        this.stack = Comparer.stripTags(stack);
        InventoryCrafting inv = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            ItemStack slot = ItemPattern.getSlot(stack, i);
            this.inputs.add(Comparer.stripTags(slot));
            if (slot == null) continue;
            inv.func_70299_a(i, slot);
        }
        if (!ItemPattern.isProcessing(stack)) {
            ItemStack output;
            for (IRecipe r : CraftingManager.field_193380_a) {
                if (!r.func_77569_a(inv, world)) continue;
                this.recipe = r;
                break;
            }
            if (this.recipe != null && !(output = this.recipe.func_77572_b(inv)).func_190926_b()) {
                this.outputs.add(Comparer.stripTags(output.func_77946_l()));
                if (this.isOredict()) {
                    LinkedList inputs = new LinkedList();
                    for (Ingredient ingredient : this.recipe.func_192400_c()) {
                        inputs.add(Arrays.asList(ingredient.func_193365_a()));
                    }
                    Iterator iterator = inputs.iterator();
                    while (iterator.hasNext()) {
                        List input = (List)iterator.next();
                        if (input.isEmpty()) {
                            this.oreInputs.add(Collections.emptyList());
                            continue;
                        }
                        LinkedList<ItemStack> cleaned = new LinkedList<ItemStack>();
                        for (ItemStack in : input) {
                            cleaned.add(Comparer.stripTags(in.func_77946_l()));
                        }
                        this.oreInputs.add(cleaned);
                    }
                }
                for (ItemStack remaining : this.recipe.func_179532_b(inv)) {
                    if (remaining.func_190926_b()) continue;
                    ItemStack cleaned = Comparer.stripTags(remaining.func_77946_l());
                    this.byproducts.add(cleaned);
                }
            }
        } else {
            this.outputs = ItemPattern.getOutputs(stack);
        }
        if (this.oreInputs.isEmpty()) {
            for (ItemStack input : this.inputs) {
                if (input == null || input.func_190926_b()) {
                    this.oreInputs.add(Collections.emptyList());
                    continue;
                }
                int[] ids = OreDictionary.getOreIDs((ItemStack)input);
                if (ids.length == 0) {
                    this.oreInputs.add(Collections.singletonList(Comparer.stripTags(input)));
                    continue;
                }
                if (this.isOredict()) {
                    List oredictInputs = Arrays.stream(ids).mapToObj(OreDictionary::getOreName).map(OreDictionary::getOres).flatMap(Collection::stream).map(ItemStack::func_77946_l).map(Comparer::stripTags).peek(s -> s.func_190920_e(input.func_190916_E())).collect(Collectors.toList());
                    oredictInputs.add(0, Comparer.stripTags(input.func_77946_l()));
                    this.oreInputs.add(oredictInputs);
                    continue;
                }
                this.oreInputs.add(Collections.singletonList(Comparer.stripTags(input)));
            }
        }
    }

    @Override
    public ICraftingPatternContainer getContainer() {
        return this.container;
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public boolean isValid() {
        return !this.inputs.isEmpty() && this.inputs.stream().filter(Objects::nonNull).count() > 0L && !this.outputs.isEmpty();
    }

    @Override
    public boolean isProcessing() {
        return ItemPattern.isProcessing(this.stack);
    }

    @Override
    public boolean isOredict() {
        return ItemPattern.isOredict(this.stack);
    }

    @Override
    public boolean isBlocking() {
        return ItemPattern.isBlocking(this.stack);
    }

    @Override
    public List<ItemStack> getInputs() {
        return this.inputs;
    }

    @Override
    public List<List<ItemStack>> getOreInputs() {
        return this.oreInputs;
    }

    @Override
    @Nullable
    public List<ItemStack> getOutputs(ItemStack[] took) {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        InventoryCrafting inv = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            if (took[i] == null) continue;
            inv.func_70299_a(i, took[i]);
        }
        ItemStack cleaned = this.recipe.func_77572_b(inv);
        if (cleaned.func_190926_b()) {
            return null;
        }
        outputs.add(cleaned.func_77946_l());
        return outputs;
    }

    @Override
    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    @Override
    public List<ItemStack> getByproducts(ItemStack[] took) {
        ArrayList<ItemStack> byproducts = new ArrayList<ItemStack>();
        InventoryCrafting inv = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            if (took[i] == null) continue;
            inv.func_70299_a(i, took[i]);
        }
        for (ItemStack remaining : this.recipe.func_179532_b(inv)) {
            if (remaining.func_190926_b()) continue;
            byproducts.add(remaining.func_77946_l());
        }
        return byproducts;
    }

    @Override
    public List<ItemStack> getByproducts() {
        return this.byproducts;
    }

    @Override
    public String getId() {
        return "normal";
    }

    @Override
    public int getQuantityPerRequest(ItemStack requested, int compare) {
        int quantity = 0;
        requested = Comparer.stripTags(requested.func_77946_l());
        for (ItemStack output : this.outputs) {
            if (!API.instance().getComparer().isEqual(requested, output, compare)) continue;
            quantity += output.func_190916_E();
            if (ItemPattern.isProcessing(this.stack)) continue;
            break;
        }
        return quantity;
    }

    @Override
    public ItemStack getActualOutput(ItemStack requested, int compare) {
        requested = Comparer.stripTags(requested.func_77946_l());
        for (ItemStack output : this.outputs) {
            if (!API.instance().getComparer().isEqual(requested, output, compare)) continue;
            return output.func_77946_l();
        }
        return null;
    }

    public String toString() {
        return "CraftingPattern{container=" + this.container + ", inputs=" + this.inputs + ", outputs=" + this.outputs + ", byproducts=" + this.byproducts + '}';
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof ICraftingPattern && this.alike((ICraftingPattern)obj);
    }

    public int hashCode() {
        if (this.hashCodeCached == null) {
            this.hashCodeCached = 0;
            for (ItemStack outputItemStack : this.getOutputs()) {
                int itemHashCode = 0;
                itemHashCode = outputItemStack.func_190916_E();
                itemHashCode = itemHashCode * 31 + outputItemStack.func_77973_b().hashCode();
                itemHashCode = itemHashCode * 31 + outputItemStack.func_77952_i();
                itemHashCode = itemHashCode * 31 + Objects.hashCode(outputItemStack.func_77978_p());
                this.hashCodeCached = this.hashCodeCached * 31 + itemHashCode;
            }
        }
        return this.hashCodeCached;
    }

    @Override
    public boolean alike(ICraftingPattern other) {
        if (other == this) {
            return true;
        }
        if (other.getId().equals(this.getId()) && other.isOredict() == this.isOredict() && other.isBlocking() == this.isBlocking() && other.isProcessing() == this.isProcessing() && other.getOreInputs().size() == this.getOreInputs().size() && other.getOutputs().size() == this.getOutputs().size()) {
            int j;
            boolean same = true;
            for (int i = 0; i < other.getOreInputs().size(); ++i) {
                same &= other.getOreInputs().get(i).size() == this.getOreInputs().get(i).size();
            }
            for (j = 0; same && j < other.getOutputs().size(); ++j) {
                same = ItemStack.func_77989_b((ItemStack)other.getOutputs().get(j), (ItemStack)this.getOutputs().get(j));
            }
            for (int i = 0; same && i < other.getOreInputs().size(); ++i) {
                List<ItemStack> otherList = other.getOreInputs().get(i);
                List<ItemStack> thisList = this.getOreInputs().get(i);
                for (j = 0; same && j < otherList.size(); ++j) {
                    same = ItemStack.func_77989_b((ItemStack)otherList.get(j), (ItemStack)thisList.get(j));
                }
            }
            return same;
        }
        return false;
    }
}

