/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternChain;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CraftingPatternChainList
implements Iterable<CraftingPatternChain> {
    LinkedList<CraftingPatternChain> innerChain = new LinkedList();
    Map<ICraftingPattern, CraftingPatternChain> innerChainMap = new HashMap<ICraftingPattern, CraftingPatternChain>();

    public void add(ICraftingPattern pattern) {
        CraftingPatternChain chain = this.innerChainMap.get(pattern);
        if (chain == null) {
            chain = new CraftingPatternChain(pattern);
            this.innerChain.add(chain);
            this.innerChainMap.put(pattern, chain);
        } else if (!chain.add(pattern)) {
            chain = new CraftingPatternChain(pattern);
            this.innerChain.add(chain);
            this.innerChainMap.put(pattern, chain);
        }
    }

    public void addAll(Collection<ICraftingPattern> patterns) {
        patterns.forEach(this::add);
    }

    public List<ICraftingPattern> asList() {
        return this.innerChain.stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public Iterator<CraftingPatternChain> iterator() {
        return this.innerChain.iterator();
    }

    public void clear() {
        this.innerChain.clear();
        this.innerChainMap.clear();
    }

    public static class CraftingPatternChain
    implements ICraftingPatternChain {
        private LinkedList<ICraftingPattern> innerList;
        private ICraftingPattern prototype;

        public CraftingPatternChain(ICraftingPattern prototype) {
            this.prototype = prototype;
            this.innerList = new LinkedList();
            this.innerList.add(prototype);
        }

        @Override
        public ICraftingPattern cycle() {
            ICraftingPattern front = this.innerList.poll();
            this.innerList.addLast(front);
            return front;
        }

        @Override
        public ICraftingPattern getPrototype() {
            return this.prototype;
        }

        @Override
        public int size() {
            return this.innerList.size();
        }

        @Override
        public boolean isEmpty() {
            return this.innerList.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.innerList.contains(o);
        }

        @Override
        public Iterator<ICraftingPattern> iterator() {
            return this.innerList.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.innerList.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.innerList.toArray(a);
        }

        @Override
        public boolean add(ICraftingPattern pattern) {
            return this.isValidForChain(pattern) && this.innerList.add(pattern);
        }

        @Override
        public boolean remove(Object o) {
            return this.innerList.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.innerList.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends ICraftingPattern> c) {
            c.removeIf(p -> !this.isValidForChain((ICraftingPattern)p));
            return this.innerList.addAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.innerList.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.innerList.retainAll(c);
        }

        @Override
        public void clear() {
            this.innerList.clear();
        }
    }
}

