/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.grid.handler;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.raoulvdberge.refinedstorage.api.network.item.INetworkItem;
import com.raoulvdberge.refinedstorage.api.network.item.NetworkItemAction;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.apache.commons.lang3.tuple.Pair;

public class FluidGridHandler
implements IFluidGridHandler {
    private INetwork network;

    public FluidGridHandler(INetwork network) {
        this.network = network;
    }

    @Override
    public void onExtract(EntityPlayerMP player, int hash, boolean shift) {
        FluidStack stack = this.network.getFluidStorageCache().getList().get(hash);
        if (stack == null || stack.amount < 1000 || !this.network.getSecurityManager().hasPermission(Permission.EXTRACT, (EntityPlayer)player)) {
            return;
        }
        if (StackUtils.hasFluidBucket(stack)) {
            ItemStack bucket = null;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack slot = player.field_71071_by.func_70301_a(i);
                if (!API.instance().getComparer().isEqualNoQuantity(StackUtils.EMPTY_BUCKET, slot)) continue;
                bucket = StackUtils.EMPTY_BUCKET.func_77946_l();
                player.field_71071_by.func_70298_a(i, 1);
                break;
            }
            if (bucket == null) {
                bucket = this.network.extractItem(StackUtils.EMPTY_BUCKET, 1, false);
            }
            if (bucket != null) {
                INetworkItem networkItem;
                IFluidHandlerItem fluidHandler = (IFluidHandlerItem)bucket.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                this.network.getFluidStorageTracker().changed((EntityPlayer)player, stack.copy());
                fluidHandler.fill(this.network.extractFluid(stack, 1000, false), true);
                if (shift) {
                    if (!player.field_71071_by.func_70441_a(fluidHandler.getContainer().func_77946_l())) {
                        InventoryHelper.func_180173_a((World)player.func_130014_f_(), (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (ItemStack)fluidHandler.getContainer());
                    }
                } else {
                    player.field_71071_by.func_70437_b(fluidHandler.getContainer());
                    player.func_71113_k();
                }
                if ((networkItem = this.network.getNetworkItemHandler().getItem((EntityPlayer)player)) != null) {
                    networkItem.onAction(NetworkItemAction.FLUID_EXTRACTED);
                }
            }
        }
    }

    @Override
    @Nullable
    public ItemStack onInsert(EntityPlayerMP player, ItemStack container) {
        if (!this.network.getSecurityManager().hasPermission(Permission.INSERT, (EntityPlayer)player)) {
            return container;
        }
        Pair<ItemStack, FluidStack> result = StackUtils.getFluid(container, true);
        if (result.getValue() != null && this.network.insertFluid((FluidStack)result.getValue(), ((FluidStack)result.getValue()).amount, true) == null) {
            this.network.getFluidStorageTracker().changed((EntityPlayer)player, ((FluidStack)result.getValue()).copy());
            result = StackUtils.getFluid(container, false);
            this.network.insertFluid((FluidStack)result.getValue(), ((FluidStack)result.getValue()).amount, false);
            INetworkItem networkItem = this.network.getNetworkItemHandler().getItem((EntityPlayer)player);
            if (networkItem != null) {
                networkItem.onAction(NetworkItemAction.FLUID_INSERTED);
            }
            return (ItemStack)result.getLeft();
        }
        return container;
    }

    @Override
    public void onInsertHeldContainer(EntityPlayerMP player) {
        player.field_71071_by.func_70437_b(StackUtils.nullToEmpty(this.onInsert(player, player.field_71071_by.func_70445_o())));
        player.func_71113_k();
    }

    @Override
    public ItemStack onShiftClick(EntityPlayerMP player, ItemStack container) {
        return StackUtils.nullToEmpty(this.onInsert(player, container));
    }
}

