/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.grid.handler;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.tile.grid.portable.IPortableGrid;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemGridHandlerPortable
implements IItemGridHandler {
    private IPortableGrid portableGrid;
    private IGrid grid;

    public ItemGridHandlerPortable(IPortableGrid portableGrid, IGrid grid) {
        this.portableGrid = portableGrid;
        this.grid = grid;
    }

    @Override
    public void onExtract(EntityPlayerMP player, int hash, int flags) {
        if (this.portableGrid.getStorage() == null || !this.grid.isActive()) {
            return;
        }
        ItemStack item = this.portableGrid.getCache().getList().get(hash);
        if (item == null) {
            return;
        }
        int itemSize = item.func_190916_E();
        int maxItemSize = item.func_77973_b().getItemStackLimit(item.func_77946_l());
        boolean single = (flags & 2) == 2;
        ItemStack held = player.field_71071_by.func_70445_o();
        if (single ? !held.func_190926_b() && (!API.instance().getComparer().isEqualNoQuantity(item, held) || held.func_190916_E() + 1 > held.func_77976_d()) : !player.field_71071_by.func_70445_o().func_190926_b()) {
            return;
        }
        int size = 64;
        if ((flags & 1) == 1 && itemSize > 1) {
            size = itemSize / 2;
            if (size > maxItemSize / 2) {
                size = maxItemSize / 2;
            }
        } else if (single) {
            size = 1;
        } else if ((flags & 4) == 4) {
            // empty if block
        }
        size = Math.min(size, maxItemSize);
        this.portableGrid.getStorageTracker().changed((EntityPlayer)player, item.func_77946_l());
        ItemStack took = this.portableGrid.getStorage().extract(item, size, 3, true);
        if (took != null) {
            if ((flags & 4) == 4) {
                IItemHandler playerInventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
                if (ItemHandlerHelper.insertItem((IItemHandler)playerInventory, (ItemStack)took, (boolean)true).func_190926_b()) {
                    took = this.portableGrid.getStorage().extract(item, size, 3, false);
                    ItemHandlerHelper.insertItem((IItemHandler)playerInventory, (ItemStack)took, (boolean)false);
                }
            } else {
                took = this.portableGrid.getStorage().extract(item, size, 3, false);
                if (single && !held.func_190926_b()) {
                    held.func_190917_f(1);
                } else {
                    player.field_71071_by.func_70437_b(took);
                }
                player.func_71113_k();
            }
            this.portableGrid.drainEnergy(RS.INSTANCE.config.portableGridExtractUsage);
        }
    }

    @Override
    @Nullable
    public ItemStack onInsert(EntityPlayerMP player, ItemStack stack) {
        if (this.portableGrid.getStorage() == null || !this.grid.isActive()) {
            return stack;
        }
        this.portableGrid.getStorageTracker().changed((EntityPlayer)player, stack.func_77946_l());
        ItemStack remainder = this.portableGrid.getStorage().insert(stack, stack.func_190916_E(), false);
        this.portableGrid.drainEnergy(RS.INSTANCE.config.portableGridInsertUsage);
        return remainder;
    }

    @Override
    public void onInsertHeldItem(EntityPlayerMP player, boolean single) {
        if (player.field_71071_by.func_70445_o().func_190926_b() || this.portableGrid.getStorage() == null || !this.grid.isActive()) {
            return;
        }
        ItemStack stack = player.field_71071_by.func_70445_o();
        int size = single ? 1 : stack.func_190916_E();
        this.portableGrid.getStorageTracker().changed((EntityPlayer)player, stack.func_77946_l());
        if (single) {
            if (this.portableGrid.getStorage().insert(stack, size, true) == null) {
                this.portableGrid.getStorage().insert(stack, size, false);
                stack.func_190918_g(size);
                if (stack.func_190916_E() == 0) {
                    player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                }
            }
        } else {
            player.field_71071_by.func_70437_b(StackUtils.nullToEmpty(this.portableGrid.getStorage().insert(stack, size, false)));
        }
        player.func_71113_k();
        this.portableGrid.drainEnergy(RS.INSTANCE.config.portableGridInsertUsage);
    }

    @Override
    public ItemStack onShiftClick(EntityPlayerMP player, ItemStack stack) {
        return StackUtils.nullToEmpty(this.onInsert(player, stack));
    }

    @Override
    public void onCraftingPreviewRequested(EntityPlayerMP player, int hash, int quantity, boolean noPreview) {
    }

    @Override
    public void onCraftingRequested(EntityPlayerMP player, int hash, int quantity) {
    }

    @Override
    public void onCraftingCancelRequested(EntityPlayerMP player, int id) {
    }
}

