/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.mojang.authlib.GameProfile;
import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.container.slot.SlotFilter;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerFluid;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerListenerNetworkNode;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerUpgrade;
import com.raoulvdberge.refinedstorage.tile.TileConstructor;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.config.IType;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.PositionImpl;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class NetworkNodeConstructor
extends NetworkNode
implements IComparable,
IType {
    public static final String ID = "constructor";
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_DROP = "Drop";
    private static final int BASE_SPEED = 20;
    private ItemHandlerBase itemFilters = new ItemHandlerBase(1, new ItemHandlerListenerNetworkNode(this), new Predicate[0]);
    private ItemHandlerFluid fluidFilters = new ItemHandlerFluid(1, new ItemHandlerListenerNetworkNode(this));
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (Consumer<Integer>)new ItemHandlerListenerNetworkNode(this), 2, 3, 4);
    private int compare = 3;
    private int type = 0;
    private boolean drop = false;

    public NetworkNodeConstructor(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.constructorUsage + this.upgrades.getEnergyUsage();
    }

    @Override
    public void update() {
        super.update();
        if (this.network != null && this.canUpdate() && this.ticks % this.upgrades.getSpeed(20, 4) == 0) {
            FluidStack stack;
            if (this.type == 0 && !this.itemFilters.getStackInSlot(0).func_190926_b()) {
                ItemStack item = this.itemFilters.getStackInSlot(0);
                IBlockState block = SlotFilter.getBlockState((IBlockAccess)this.world, this.pos.func_177972_a(this.getDirection()), item);
                if (block != null) {
                    if (this.drop) {
                        this.dropItem();
                    } else {
                        this.placeBlock();
                    }
                } else if (item.func_77973_b() == Items.field_151152_bP && !this.drop) {
                    ItemStack took = this.network.extractItem(item, 1, false);
                    if (took != null) {
                        this.world.func_72838_d((Entity)new EntityFireworkRocket(this.world, this.getDispensePositionX(), this.getDispensePositionY(), this.getDispensePositionZ(), took));
                    }
                } else {
                    this.dropItem();
                }
            } else if (this.type == 1 && !this.fluidFilters.getStackInSlot(0).func_190926_b() && (stack = this.fluidFilters.getFluidStackInSlot(0)) != null && stack.getFluid().canBePlacedInWorld()) {
                FluidStack took;
                FluidStack stored;
                BlockPos front = this.pos.func_177972_a(this.getDirection());
                Block block = stack.getFluid().getBlock();
                if (this.world.func_175623_d(front) && block.func_176196_c(this.world, front) && (stored = this.network.getFluidStorageCache().getList().get(stack, this.compare)) != null && stored.amount >= 1000 && (took = this.network.extractFluid(stack, 1000, this.compare, false)) != null) {
                    IBlockState state = block.func_176223_P();
                    if (state.func_177230_c() == Blocks.field_150355_j) {
                        state = Blocks.field_150358_i.func_176223_P();
                    } else if (state.func_177230_c() == Blocks.field_150353_l) {
                        state = Blocks.field_150356_k.func_176223_P();
                    }
                    if (!this.canPlace(front, state)) {
                        return;
                    }
                    this.world.func_180501_a(front, state, 3);
                }
            }
        }
    }

    private boolean canPlace(BlockPos pos, IBlockState state) {
        BlockEvent.PlaceEvent e = new BlockEvent.PlaceEvent(new BlockSnapshot(this.world, pos, state), this.world.func_180495_p(pos), (EntityPlayer)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.world)), EnumHand.MAIN_HAND);
        return !MinecraftForge.EVENT_BUS.post((Event)e);
    }

    private void placeBlock() {
        BlockPos front = this.pos.func_177972_a(this.getDirection());
        ItemStack item = this.itemFilters.getStackInSlot(0);
        ItemStack took = this.network.extractItem(item, 1, this.compare, true);
        if (took != null) {
            IBlockState state = SlotFilter.getBlockState((IBlockAccess)this.world, front, took);
            if (state != null && this.world.func_175623_d(front) && state.func_177230_c().func_176196_c(this.world, front)) {
                if (!this.canPlace(front, state = state.func_177230_c().getStateForPlacement(this.world, front, this.getDirection(), 0.5f, 0.5f, 0.5f, took.func_77960_j(), (EntityLivingBase)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.world)), EnumHand.MAIN_HAND))) {
                    return;
                }
                took = this.network.extractItem(item, 1, this.compare, false);
                if (took != null) {
                    if (item.func_77973_b() instanceof ItemBlock) {
                        ((ItemBlock)item.func_77973_b()).placeBlockAt(took, (EntityPlayer)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.world)), this.world, front, this.getDirection(), 0.0f, 0.0f, 0.0f, state);
                    } else {
                        this.world.func_180501_a(front, state, 3);
                        state.func_177230_c().func_180633_a(this.world, front, state, (EntityLivingBase)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.world)), took);
                    }
                    SoundType blockSound = state.func_177230_c().getSoundType(state, this.world, this.pos, null);
                    this.world.func_184133_a(null, front, blockSound.func_185841_e(), SoundCategory.BLOCKS, (blockSound.func_185843_a() + 1.0f) / 2.0f, blockSound.func_185847_b() * 0.8f);
                    if (state.func_177230_c() == Blocks.field_150465_bP) {
                        this.world.func_175656_a(front, this.world.func_180495_p(front).func_177226_a((IProperty)BlockSkull.field_176418_a, (Comparable)this.getDirection()));
                        TileEntity tile = this.world.func_175625_s(front);
                        if (tile instanceof TileEntitySkull) {
                            TileEntitySkull skullTile = (TileEntitySkull)tile;
                            if (item.func_77952_i() == 3) {
                                GameProfile playerInfo = null;
                                if (item.func_77942_o()) {
                                    NBTTagCompound tag = item.func_77978_p();
                                    if (tag.func_150297_b("SkullOwner", 10)) {
                                        playerInfo = NBTUtil.func_152459_a((NBTTagCompound)tag.func_74775_l("SkullOwner"));
                                    } else if (tag.func_150297_b("SkullOwner", 8) && !tag.func_74779_i("SkullOwner").isEmpty()) {
                                        playerInfo = new GameProfile(null, tag.func_74779_i("SkullOwner"));
                                    }
                                }
                                skullTile.func_152106_a(playerInfo);
                            } else {
                                skullTile.func_152107_a(item.func_77960_j());
                            }
                            Blocks.field_150465_bP.func_180679_a(this.world, front, skullTile);
                        }
                    }
                }
            }
        } else if (this.upgrades.hasUpgrade(3)) {
            ItemStack craft = this.itemFilters.getStackInSlot(0);
            this.network.getCraftingManager().schedule(craft, 1, this.compare);
        }
    }

    private void dropItem() {
        ItemStack took = this.network.extractItem(this.itemFilters.getStackInSlot(0), this.upgrades.getItemInteractCount(), false);
        if (took != null) {
            BehaviorDefaultDispenseItem.func_82486_a((World)this.world, (ItemStack)took, (int)6, (EnumFacing)this.getDirection(), (IPosition)new PositionImpl(this.getDispensePositionX(), this.getDispensePositionY(), this.getDispensePositionZ()));
        } else if (this.upgrades.hasUpgrade(3)) {
            ItemStack craft = this.itemFilters.getStackInSlot(0);
            this.network.getCraftingManager().schedule(craft, 1, this.compare);
        }
    }

    private double getDispensePositionX() {
        return (double)this.pos.func_177958_n() + 0.5 + 0.8 * (double)this.getDirection().func_82601_c();
    }

    private double getDispensePositionY() {
        return (double)this.pos.func_177956_o() + (this.getDirection() == EnumFacing.DOWN ? 0.45 : 0.5) + 0.8 * (double)this.getDirection().func_96559_d();
    }

    private double getDispensePositionZ() {
        return (double)this.pos.func_177952_p() + 0.5 + 0.8 * (double)this.getDirection().func_82599_e();
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.upgrades, 1, tag);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, 1, tag);
        return tag;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_TYPE, this.type);
        tag.func_74757_a(NBT_DROP, this.drop);
        StackUtils.writeItems((IItemHandler)this.itemFilters, 0, tag);
        StackUtils.writeItems((IItemHandler)this.fluidFilters, 2, tag);
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        if (tag.func_74764_b(NBT_DROP)) {
            this.drop = tag.func_74767_n(NBT_DROP);
        }
        StackUtils.readItems((IItemHandlerModifiable)this.itemFilters, 0, tag);
        StackUtils.readItems((IItemHandlerModifiable)this.fluidFilters, 2, tag);
    }

    public boolean isDrop() {
        return this.drop;
    }

    public void setDrop(boolean drop) {
        this.drop = drop;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return this.upgrades;
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }

    @Override
    public int getType() {
        return this.world.field_72995_K ? TileConstructor.TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    @Override
    public IItemHandler getFilterInventory() {
        return this.getType() == 0 ? this.itemFilters : this.fluidFilters;
    }
}

