/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternProvider;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerListenerNetworkNode;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerUpgrade;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class NetworkNodeCrafter
extends NetworkNode
implements ICraftingPatternContainer {
    public static final String ID = "crafter";
    private static final String NBT_BLOCKED = "Blocked";
    private ItemHandlerBase patterns = new ItemHandlerBase(9, new ItemHandlerListenerNetworkNode(this), new Predicate[]{s -> s.func_77973_b() instanceof ICraftingPatternProvider && ((ICraftingPatternProvider)s.func_77973_b()).create(this.world, (ItemStack)s, this).isValid()}){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (!NetworkNodeCrafter.this.world.field_72995_K) {
                NetworkNodeCrafter.this.rebuildPatterns();
            }
            if (NetworkNodeCrafter.this.network != null) {
                NetworkNodeCrafter.this.network.getCraftingManager().rebuild();
            }
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    private List<ICraftingPattern> actualPatterns = new ArrayList<ICraftingPattern>();
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (Consumer<Integer>)new ItemHandlerListenerNetworkNode(this), 2);
    private boolean blocked = false;

    public NetworkNodeCrafter(World world, BlockPos pos) {
        super(world, pos);
    }

    private void rebuildPatterns() {
        this.actualPatterns.clear();
        for (int i = 0; i < this.patterns.getSlots(); ++i) {
            ICraftingPattern pattern;
            ItemStack patternStack = this.patterns.getStackInSlot(i);
            if (patternStack.func_190926_b() || !(pattern = ((ICraftingPatternProvider)patternStack.func_77973_b()).create(this.world, patternStack, this)).isValid()) continue;
            this.actualPatterns.add(pattern);
        }
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.crafterUsage + this.upgrades.getEnergyUsage() + RS.INSTANCE.config.crafterPerPatternUsage * this.actualPatterns.size();
    }

    @Override
    public void update() {
        super.update();
        if (this.ticks == 1) {
            this.rebuildPatterns();
        }
    }

    @Override
    protected void onConnectedStateChange(INetwork network, boolean state) {
        super.onConnectedStateChange(network, state);
        if (!state) {
            network.getCraftingManager().getTasks().stream().filter(task -> task.getPattern().getContainer().getPosition().equals((Object)this.pos)).forEach(task -> network.getCraftingManager().cancel((ICraftingTask)task));
        }
        network.getCraftingManager().rebuild();
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.patterns, 0, tag);
        StackUtils.readItems((IItemHandlerModifiable)this.upgrades, 1, tag);
        if (tag.func_74764_b(NBT_BLOCKED)) {
            this.blocked = tag.func_74767_n(NBT_BLOCKED);
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.patterns, 0, tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, 1, tag);
        tag.func_74757_a(NBT_BLOCKED, this.blocked);
        return tag;
    }

    @Override
    public int getSpeedUpdateCount() {
        return this.upgrades.getUpgradeCount(2);
    }

    @Override
    public IItemHandler getFacingInventory() {
        return WorldUtils.getItemHandler(this.getFacingTile(), this.getDirection().func_176734_d());
    }

    @Override
    public List<ICraftingPattern> getPatterns() {
        return this.actualPatterns;
    }

    @Override
    public BlockPos getPosition() {
        return this.pos;
    }

    public IItemHandler getPatternItems() {
        return this.patterns;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.patterns, this.upgrades});
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }

    @Override
    public boolean isBlocked() {
        return this.blocked;
    }

    @Override
    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
        this.markDirty();
    }
}

