/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.network.grid.IGridTab;
import com.raoulvdberge.refinedstorage.api.util.IFilter;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerFilter;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerListenerNetworkNode;
import com.raoulvdberge.refinedstorage.tile.craftingmonitor.ICraftingMonitor;
import com.raoulvdberge.refinedstorage.tile.craftingmonitor.TileCraftingMonitor;
import com.raoulvdberge.refinedstorage.tile.data.TileDataManager;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class NetworkNodeCraftingMonitor
extends NetworkNode
implements ICraftingMonitor {
    public static final String ID = "crafting_monitor";
    private static final String NBT_VIEW_AUTOMATED = "ViewAutomated";
    private boolean viewAutomated = true;
    private List<IFilter> filters = new ArrayList<IFilter>();
    private ItemHandlerListenerNetworkNode filterListener = new ItemHandlerListenerNetworkNode(this);
    private ItemHandlerFilter filter = new ItemHandlerFilter(this.filters, new ArrayList<IGridTab>(), slot -> {
        this.filterListener.accept((Integer)slot);
        if (this.network != null) {
            this.network.sendCraftingMonitorUpdate();
        }
    });

    public NetworkNodeCraftingMonitor(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.craftingMonitorUsage;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }

    @Override
    public String getGuiTitle() {
        return "gui.refinedstorage:crafting_monitor";
    }

    @Override
    public void onCancelled(EntityPlayerMP player, int id) {
        if (this.network != null) {
            this.network.getItemGridHandler().onCraftingCancelRequested(player, id);
        }
    }

    @Override
    public TileDataParameter<Integer, ?> getRedstoneModeParameter() {
        return TileCraftingMonitor.REDSTONE_MODE;
    }

    @Override
    @Nullable
    public BlockPos getNetworkPosition() {
        return this.network != null ? this.network.getPosition() : null;
    }

    @Override
    public List<ICraftingTask> getTasks() {
        return this.network != null ? this.network.getCraftingManager().getTasks() : Collections.emptyList();
    }

    @Override
    public List<IFilter> getFilters() {
        return this.filters;
    }

    public void onOpened(EntityPlayer player) {
        if (this.network != null) {
            this.network.sendCraftingMonitorUpdate((EntityPlayerMP)player);
        }
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.filter, 0, tag);
        tag.func_74757_a(NBT_VIEW_AUTOMATED, this.viewAutomated);
        return tag;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.filter, 0, tag);
        if (tag.func_74764_b(NBT_VIEW_AUTOMATED)) {
            this.viewAutomated = tag.func_74767_n(NBT_VIEW_AUTOMATED);
        }
    }

    @Override
    public boolean canViewAutomated() {
        return this.world.field_72995_K ? TileCraftingMonitor.VIEW_AUTOMATED.getValue() : this.viewAutomated;
    }

    @Override
    public void onViewAutomatedChanged(boolean viewAutomated) {
        TileDataManager.setParameter(TileCraftingMonitor.VIEW_AUTOMATED, viewAutomated);
    }

    @Override
    public void onClosed(EntityPlayer player) {
    }

    public void setViewAutomated(boolean viewAutomated) {
        this.viewAutomated = viewAutomated;
    }

    @Override
    public ItemHandlerFilter getFilter() {
        return this.filter;
    }

    @Override
    public IItemHandler getDrops() {
        return this.filter;
    }
}

