/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.solderer.ISoldererRecipe;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerListenerNetworkNode;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerProxy;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerUpgrade;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class NetworkNodeSolderer
extends NetworkNode {
    public static final String ID = "solderer";
    public static final String NBT_WORKING = "Working";
    private static final String NBT_PROGRESS = "Progress";
    private ItemHandlerBase ingredients = new ItemHandlerBase(3, new ItemHandlerListenerNetworkNode(this), new Predicate[0]){

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            for (ISoldererRecipe recipe : API.instance().getSoldererRegistry().getRecipes()) {
                for (ItemStack possibility : recipe.getRow(slot)) {
                    if (!API.instance().getComparer().isEqual(possibility, stack, 19)) continue;
                    return super.insertItem(slot, stack, simulate);
                }
            }
            return stack;
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            NetworkNodeSolderer.this.recipe = API.instance().getSoldererRegistry().getRecipe((IItemHandler)NetworkNodeSolderer.this.ingredients);
        }
    };
    private ItemHandlerBase result = new ItemHandlerBase(1, new ItemHandlerListenerNetworkNode(this), new Predicate[0]){

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }
    };
    private ItemHandlerProxy items = new ItemHandlerProxy((IItemHandler)this.ingredients, (IItemHandler)this.result);
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (Consumer<Integer>)new ItemHandlerListenerNetworkNode(this), 2);
    private boolean wasWorking;
    private boolean working;
    private ISoldererRecipe recipe;
    private int progress;

    public NetworkNodeSolderer(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.soldererUsage + this.upgrades.getEnergyUsage();
    }

    @Override
    public void update() {
        super.update();
        if (this.wasWorking != this.working) {
            this.wasWorking = this.working;
            this.markDirty();
            WorldUtils.updateBlock(this.world, this.pos);
        }
        if (this.network == null || !this.canUpdate()) {
            return;
        }
        if (this.working) {
            if (this.recipe == null) {
                this.working = false;
                this.progress = 0;
                this.markDirty();
            } else if ((this.result.getStackInSlot(0).func_190926_b() || API.instance().getComparer().isEqualNoQuantity(this.recipe.getResult(), this.result.getStackInSlot(0))) && this.result.getStackInSlot(0).func_190916_E() + this.recipe.getResult().func_190916_E() <= this.result.getStackInSlot(0).func_77976_d()) {
                ++this.progress;
                if (this.progress >= this.getDuration()) {
                    ItemStack resultSlot = this.result.getStackInSlot(0);
                    if (resultSlot.func_190926_b()) {
                        this.result.setStackInSlot(0, this.recipe.getResult().func_77946_l());
                    } else {
                        resultSlot.func_190917_f(this.recipe.getResult().func_190916_E());
                    }
                    for (int i = 0; i < 3; ++i) {
                        ItemStack ingredientSlot = this.ingredients.getStackInSlot(i);
                        if (ingredientSlot.func_190926_b()) continue;
                        ingredientSlot.func_190918_g(((ItemStack)this.recipe.getRow(i).get(0)).func_190916_E());
                    }
                    this.recipe = API.instance().getSoldererRegistry().getRecipe((IItemHandler)this.ingredients);
                    this.progress = 0;
                }
                this.markDirty();
            }
        } else if (this.recipe != null) {
            this.working = true;
            this.markDirty();
        }
    }

    @Override
    public void onConnectedStateChange(INetwork network, boolean state) {
        super.onConnectedStateChange(network, state);
        if (!state) {
            this.recipe = null;
            this.progress = 0;
            this.working = false;
        } else {
            this.recipe = API.instance().getSoldererRegistry().getRecipe((IItemHandler)this.ingredients);
        }
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.ingredients, 0, tag);
        StackUtils.readItems((IItemHandlerModifiable)this.upgrades, 1, tag);
        StackUtils.readItems((IItemHandlerModifiable)this.result, 2, tag);
        this.recipe = API.instance().getSoldererRegistry().getRecipe((IItemHandler)this.ingredients);
        if (tag.func_74764_b(NBT_WORKING)) {
            this.wasWorking = this.working = tag.func_74767_n(NBT_WORKING);
        }
        if (tag.func_74764_b(NBT_PROGRESS)) {
            this.progress = tag.func_74762_e(NBT_PROGRESS);
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.ingredients, 0, tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, 1, tag);
        StackUtils.writeItems((IItemHandler)this.result, 2, tag);
        tag.func_74757_a(NBT_WORKING, this.working);
        tag.func_74768_a(NBT_PROGRESS, this.progress);
        return tag;
    }

    public ItemHandlerBase getIngredients() {
        return this.ingredients;
    }

    public ItemHandlerBase getResult() {
        return this.result;
    }

    public ItemHandlerProxy getItems() {
        return this.items;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    public boolean isWorking() {
        return this.working;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getDuration() {
        if (this.recipe == null) {
            return 0;
        }
        return (int)((float)this.recipe.getDuration() - (float)this.recipe.getDuration() / 100.0f * ((float)this.upgrades.getUpgradeCount(2) * RS.INSTANCE.config.soldererSpeedIncreasePerSpeedUpgrade));
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.ingredients, this.result, this.upgrades});
    }
}

