/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerFluid;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerListenerNetworkNode;
import com.raoulvdberge.refinedstorage.tile.TileStorageMonitor;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.config.IType;
import com.raoulvdberge.refinedstorage.tile.config.RedstoneMode;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.tuple.Pair;

public class NetworkNodeStorageMonitor
extends NetworkNode
implements IComparable,
IType {
    public static final int DEPOSIT_ALL_MAX_DELAY = 500;
    public static final String ID = "storage_monitor";
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_TYPE = "Type";
    private ItemHandlerBase itemFilter = new ItemHandlerBase(1, new ItemHandlerListenerNetworkNode(this), new Predicate[0]){

        @Override
        public void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            WorldUtils.updateBlock(NetworkNodeStorageMonitor.this.world, NetworkNodeStorageMonitor.this.pos);
        }
    };
    private ItemHandlerFluid fluidFilter = new ItemHandlerFluid(1, new ItemHandlerListenerNetworkNode(this)){

        @Override
        public void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            WorldUtils.updateBlock(NetworkNodeStorageMonitor.this.world, NetworkNodeStorageMonitor.this.pos);
        }
    };
    private Map<String, Pair<ItemStack, Long>> deposits = new HashMap<String, Pair<ItemStack, Long>>();
    private int compare = 3;
    private int type = 0;
    private int oldAmount = -1;

    public NetworkNodeStorageMonitor(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public void update() {
        super.update();
        int newAmount = this.getAmount();
        if (this.oldAmount == -1) {
            this.oldAmount = newAmount;
        } else if (this.oldAmount != newAmount) {
            this.oldAmount = newAmount;
            WorldUtils.updateBlock(this.world, this.pos);
        }
    }

    public boolean depositAll(EntityPlayer player) {
        if (this.type != 0 || this.network == null) {
            return false;
        }
        if (!this.network.getSecurityManager().hasPermission(Permission.INSERT, player)) {
            return false;
        }
        Pair<ItemStack, Long> deposit = this.deposits.get(player.func_146103_bH().getName());
        if (deposit == null) {
            return false;
        }
        ItemStack inserted = (ItemStack)deposit.getKey();
        long insertedAt = (Long)deposit.getValue();
        if (MinecraftServer.func_130071_aq() - insertedAt < 500L) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack toInsert = player.field_71071_by.func_70301_a(i);
                if (!API.instance().getComparer().isEqual(inserted, toInsert, this.compare)) continue;
                player.field_71071_by.func_70299_a(i, StackUtils.nullToEmpty(this.network.insertItemTracked(toInsert, toInsert.func_190916_E())));
            }
        }
        return true;
    }

    public boolean deposit(EntityPlayer player, ItemStack toInsert) {
        if (this.type != 0 || this.network == null) {
            return false;
        }
        if (!this.network.getSecurityManager().hasPermission(Permission.INSERT, player)) {
            return false;
        }
        ItemStack filter = this.itemFilter.getStackInSlot(0);
        if (!filter.func_190926_b() && API.instance().getComparer().isEqual(filter, toInsert, this.compare)) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, StackUtils.nullToEmpty(this.network.insertItemTracked(toInsert, toInsert.func_190916_E())));
            this.deposits.put(player.func_146103_bH().getName(), (Pair<ItemStack, Long>)Pair.of((Object)toInsert, (Object)MinecraftServer.func_130071_aq()));
        }
        return true;
    }

    public void extract(EntityPlayer player, EnumFacing side) {
        ItemStack result;
        int toExtract;
        if (this.type != 0 || this.network == null || this.getDirection() != side) {
            return;
        }
        if (!this.network.getSecurityManager().hasPermission(Permission.EXTRACT, player)) {
            return;
        }
        ItemStack filter = this.itemFilter.getStackInSlot(0);
        int n = toExtract = player.func_70093_af() ? 1 : 64;
        if (!filter.func_190926_b() && (result = this.network.extractItem(filter, toExtract, this.compare, false)) != null && !player.field_71071_by.func_70441_a(result.func_77946_l())) {
            InventoryHelper.func_180173_a((World)this.world, (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (ItemStack)result);
        }
    }

    @Override
    public int getEnergyUsage() {
        return 0;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        WorldUtils.updateBlock(this.world, this.pos);
        this.markDirty();
    }

    @Override
    public int getType() {
        return this.world.field_72995_K ? TileStorageMonitor.TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        WorldUtils.updateBlock(this.world, this.pos);
        this.markDirty();
    }

    @Override
    public IItemHandler getFilterInventory() {
        return this.getType() == 0 ? this.itemFilter : this.fluidFilter;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_TYPE, this.type);
        StackUtils.writeItems((IItemHandler)this.itemFilter, 0, tag);
        StackUtils.writeItems((IItemHandler)this.fluidFilter, 1, tag);
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        StackUtils.readItems((IItemHandlerModifiable)this.itemFilter, 0, tag);
        StackUtils.readItems((IItemHandlerModifiable)this.fluidFilter, 1, tag);
    }

    public ItemHandlerBase getItemFilter() {
        return this.itemFilter;
    }

    public ItemHandlerFluid getFluidFilter() {
        return this.fluidFilter;
    }

    public int getAmount() {
        if (this.network == null) {
            return 0;
        }
        switch (this.type) {
            case 0: {
                ItemStack toCheck = this.itemFilter.getStackInSlot(0);
                if (toCheck.func_190926_b()) {
                    return 0;
                }
                ItemStack stored = this.network.getItemStorageCache().getList().get(toCheck, this.compare);
                return stored != null ? stored.func_190916_E() : 0;
            }
            case 1: {
                FluidStack toCheck = this.fluidFilter.getFluidStackInSlot(0);
                if (toCheck == null) {
                    return 0;
                }
                FluidStack stored = this.network.getFluidStorageCache().getList().get(toCheck, this.compare);
                return stored != null ? stored.amount : 0;
            }
        }
        return 0;
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }

    @Override
    public void setRedstoneMode(RedstoneMode mode) {
    }
}

