/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node.externalstorage;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public abstract class StorageItemExternal
implements IStorage<ItemStack> {
    private List<ItemStack> cache;

    public abstract int getCapacity();

    public void detectChanges(INetwork network) {
        int i;
        if (this.getAccessType() == AccessType.INSERT) {
            return;
        }
        if (this.cache == null) {
            this.cache = new ArrayList(this.getStacks());
            return;
        }
        ArrayList newStacks = new ArrayList(this.getStacks());
        for (i = 0; i < newStacks.size(); ++i) {
            ItemStack actual = (ItemStack)newStacks.get(i);
            if (i >= this.cache.size()) {
                if (actual.func_190926_b()) continue;
                network.getItemStorageCache().add(actual, actual.func_190916_E(), false, true);
                continue;
            }
            ItemStack cached = this.cache.get(i);
            if (!cached.func_190926_b() && actual.func_190926_b()) {
                network.getItemStorageCache().remove(cached, cached.func_190916_E(), true);
                continue;
            }
            if (cached.func_190926_b() && !actual.func_190926_b()) {
                network.getItemStorageCache().add(actual, actual.func_190916_E(), false, true);
                network.getCraftingManager().track(actual, actual.func_190916_E());
                continue;
            }
            if (cached.func_190926_b() && actual.func_190926_b()) continue;
            if (!API.instance().getComparer().isEqualNoQuantity(cached, actual)) {
                network.getItemStorageCache().remove(cached, cached.func_190916_E(), true);
                network.getItemStorageCache().add(actual, actual.func_190916_E(), false, true);
                network.getCraftingManager().track(actual, actual.func_190916_E());
                continue;
            }
            if (cached.func_190916_E() == actual.func_190916_E()) continue;
            int delta = actual.func_190916_E() - cached.func_190916_E();
            if (delta > 0) {
                network.getItemStorageCache().add(actual, delta, false, true);
                network.getCraftingManager().track(actual, delta);
                continue;
            }
            network.getItemStorageCache().remove(actual, Math.abs(delta), true);
        }
        if (this.cache.size() > newStacks.size()) {
            for (i = newStacks.size(); i < this.cache.size(); ++i) {
                if (this.cache.get(i) == ItemStack.field_190927_a) continue;
                network.getItemStorageCache().remove(this.cache.get(i), this.cache.get(i).func_190916_E(), true);
            }
        }
        this.cache = newStacks;
        network.sendBatchedItemStorageDeltaToClient();
    }

    @Override
    public int getCacheDelta(int storedPreInsertion, int size, @Nullable ItemStack remainder) {
        return remainder == null ? size : size - remainder.func_190916_E();
    }
}

