/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCache;
import com.raoulvdberge.refinedstorage.api.storage.IStorageProvider;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public class StorageCacheItem
implements IStorageCache<ItemStack> {
    public static final Consumer<INetwork> INVALIDATE = network -> network.getItemStorageCache().invalidate();
    private INetwork network;
    private CopyOnWriteArrayList<IStorage<ItemStack>> storages = new CopyOnWriteArrayList();
    private IStackList<ItemStack> list = API.instance().createItemStackList();
    private List<Runnable> listeners = new LinkedList<Runnable>();

    public StorageCacheItem(INetwork network) {
        this.network = network;
    }

    @Override
    public synchronized void invalidate() {
        this.storages.clear();
        this.network.getNodeGraph().all().stream().filter(node -> node.canUpdate() && node instanceof IStorageProvider).forEach(node -> ((IStorageProvider)((Object)node)).addItemStorages(this.storages));
        this.list.clear();
        this.sort();
        for (IStorage<ItemStack> storage : this.storages) {
            if (storage.getAccessType() == AccessType.INSERT) continue;
            for (ItemStack stack : storage.getStacks()) {
                if (stack.func_190926_b()) continue;
                this.add(stack, stack.func_190916_E(), true, false);
            }
        }
        this.listeners.forEach(Runnable::run);
        this.network.sendItemStorageToClient();
    }

    @Override
    public synchronized void add(@Nonnull ItemStack stack, int size, boolean rebuilding, boolean batched) {
        this.list.add(stack, size);
        if (!rebuilding) {
            this.network.sendItemStorageDeltaToClient(stack, size, batched);
            this.listeners.forEach(Runnable::run);
        }
    }

    @Override
    public synchronized void remove(@Nonnull ItemStack stack, int size, boolean batched) {
        if (this.list.remove(stack, size)) {
            this.network.sendItemStorageDeltaToClient(stack, -size, batched);
            this.listeners.forEach(Runnable::run);
        }
    }

    @Override
    public void addListener(Runnable listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(Runnable listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void sort() {
        this.storages.sort(IStorage.COMPARATOR);
    }

    @Override
    public IStackList<ItemStack> getList() {
        return this.list;
    }

    @Override
    public List<IStorage<ItemStack>> getStorages() {
        return this.storages;
    }
}

