/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.StorageDiskType;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.Collection;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class StorageDiskFluid
implements IStorageDisk<FluidStack> {
    private static final int PROTOCOL = 1;
    private static final String NBT_PROTOCOL = "Protocol";
    private static final String NBT_FLUIDS = "Fluids";
    private static final String NBT_STORED = "Stored";
    private NBTTagCompound tag;
    private int capacity;
    private Multimap<Fluid, FluidStack> stacks = ArrayListMultimap.create();
    private Runnable listener = () -> {};
    private Supplier<Boolean> voidExcess;
    private Supplier<AccessType> accessType;

    public StorageDiskFluid(NBTTagCompound tag, int capacity) {
        this.tag = tag;
        this.capacity = capacity;
    }

    public NBTTagCompound getStorageTag() {
        return this.tag;
    }

    @Override
    public void readFromNBT() {
        NBTTagList list = (NBTTagList)this.tag.func_74781_a(NBT_FLUIDS);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)list.func_150305_b(i));
            if (stack == null) continue;
            this.stacks.put((Object)stack.getFluid(), (Object)stack);
        }
    }

    @Override
    public void writeToNBT() {
        NBTTagList list = new NBTTagList();
        for (FluidStack stack : this.stacks.values()) {
            list.func_74742_a((NBTBase)stack.writeToNBT(new NBTTagCompound()));
        }
        this.tag.func_74782_a(NBT_FLUIDS, (NBTBase)list);
        this.tag.func_74768_a(NBT_PROTOCOL, 1);
    }

    @Override
    public StorageDiskType getType() {
        return StorageDiskType.FLUIDS;
    }

    @Override
    public Collection<FluidStack> getStacks() {
        return this.stacks.values();
    }

    @Override
    @Nullable
    public synchronized FluidStack insert(@Nonnull FluidStack stack, int size, boolean simulate) {
        for (FluidStack otherStack : this.stacks.get((Object)stack.getFluid())) {
            if (!otherStack.isFluidEqual(stack)) continue;
            if (this.getCapacity() != -1 && this.getStored() + size > this.getCapacity()) {
                int remainingSpace = this.getCapacity() - this.getStored();
                if (remainingSpace <= 0) {
                    if (this.voidExcess.get().booleanValue()) {
                        return null;
                    }
                    return StackUtils.copy(stack, size);
                }
                if (!simulate) {
                    this.tag.func_74768_a(NBT_STORED, this.getStored() + remainingSpace);
                    otherStack.amount += remainingSpace;
                    this.listener.run();
                }
                return this.voidExcess.get() != false ? null : StackUtils.copy(otherStack, size - remainingSpace);
            }
            if (!simulate) {
                this.tag.func_74768_a(NBT_STORED, this.getStored() + size);
                otherStack.amount += size;
                this.listener.run();
            }
            return null;
        }
        if (this.getCapacity() != -1 && this.getStored() + size > this.getCapacity()) {
            int remainingSpace = this.getCapacity() - this.getStored();
            if (remainingSpace <= 0) {
                if (this.voidExcess.get().booleanValue()) {
                    return null;
                }
                return StackUtils.copy(stack, size);
            }
            if (!simulate) {
                this.tag.func_74768_a(NBT_STORED, this.getStored() + remainingSpace);
                this.stacks.put((Object)stack.getFluid(), (Object)StackUtils.copy(stack, remainingSpace));
                this.listener.run();
            }
            return this.voidExcess.get() != false ? null : StackUtils.copy(stack, size - remainingSpace);
        }
        if (!simulate) {
            this.tag.func_74768_a(NBT_STORED, this.getStored() + size);
            this.stacks.put((Object)stack.getFluid(), (Object)StackUtils.copy(stack, size));
            this.listener.run();
        }
        return null;
    }

    @Override
    @Nullable
    public synchronized FluidStack extract(@Nonnull FluidStack stack, int size, int flags, boolean simulate) {
        for (FluidStack otherStack : this.stacks.get((Object)stack.getFluid())) {
            if (!API.instance().getComparer().isEqual(otherStack, stack, flags)) continue;
            if (size > otherStack.amount) {
                size = otherStack.amount;
            }
            if (!simulate) {
                if (otherStack.amount - size == 0) {
                    this.stacks.remove((Object)otherStack.getFluid(), (Object)otherStack);
                } else {
                    otherStack.amount -= size;
                }
                this.tag.func_74768_a(NBT_STORED, this.getStored() - size);
                this.listener.run();
            }
            return StackUtils.copy(otherStack, size);
        }
        return null;
    }

    @Override
    public int getStored() {
        return StorageDiskFluid.getStored(this.tag);
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public AccessType getAccessType() {
        return this.accessType.get();
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public int getCacheDelta(int storedPreInsertion, int size, @Nullable FluidStack remainder) {
        int inserted;
        if (this.getAccessType() == AccessType.INSERT) {
            return 0;
        }
        int n = inserted = remainder == null ? size : size - remainder.amount;
        if (this.voidExcess.get().booleanValue() && storedPreInsertion + inserted > this.getCapacity()) {
            inserted = this.getCapacity() - storedPreInsertion;
        }
        return inserted;
    }

    @Override
    public boolean isValid(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_FLUIDS) && stack.func_77978_p().func_74764_b(NBT_STORED);
    }

    @Override
    public void onPassContainerContext(Runnable listener, Supplier<Boolean> voidExcess, Supplier<AccessType> accessType) {
        this.listener = listener;
        this.voidExcess = voidExcess;
        this.accessType = accessType;
    }

    public static NBTTagCompound getShareTag(@Nullable NBTTagCompound tag) {
        NBTTagCompound otherTag = new NBTTagCompound();
        otherTag.func_74768_a(NBT_STORED, StorageDiskFluid.getStored(tag));
        otherTag.func_74782_a(NBT_FLUIDS, (NBTBase)new NBTTagList());
        otherTag.func_74768_a(NBT_PROTOCOL, 1);
        return otherTag;
    }

    public static int getStored(@Nullable NBTTagCompound tag) {
        return tag == null ? 0 : tag.func_74762_e(NBT_STORED);
    }

    public static NBTTagCompound getTag() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a(NBT_FLUIDS, (NBTBase)new NBTTagList());
        tag.func_74768_a(NBT_STORED, 0);
        tag.func_74768_a(NBT_PROTOCOL, 1);
        return tag;
    }
}

