/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.util;

import com.google.common.collect.ArrayListMultimap;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.apiimpl.util.StackListItem;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class StackListItemOredicted
implements IStackList<ItemStack> {
    private StackListItem underlyingList;
    private ArrayListMultimap<Integer, ItemStack> stacks = ArrayListMultimap.create();

    private StackListItemOredicted() {
    }

    public StackListItemOredicted(StackListItem list) {
        this.underlyingList = list;
        this.initOreDict();
    }

    private void initOreDict() {
        for (ItemStack stack : this.underlyingList.getStacks()) {
            if (stack.func_190926_b()) continue;
            for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
                this.stacks.put((Object)id, (Object)stack);
            }
        }
    }

    @Override
    public void add(@Nonnull ItemStack stack, int size) {
        this.underlyingList.add(stack, size);
        ItemStack internalStack = this.underlyingList.get(stack);
        if (internalStack != null && internalStack.func_190916_E() == stack.func_190916_E()) {
            for (int id : OreDictionary.getOreIDs((ItemStack)internalStack)) {
                this.stacks.put((Object)id, (Object)internalStack);
            }
        }
    }

    @Override
    public boolean remove(@Nonnull ItemStack stack, int size) {
        return this.underlyingList.remove(stack, size);
    }

    @Override
    public boolean trackedRemove(@Nonnull ItemStack stack, int size) {
        return this.underlyingList.trackedRemove(stack, size);
    }

    @Override
    public List<ItemStack> getRemoveTracker() {
        return this.underlyingList.getRemoveTracker();
    }

    @Override
    public void undo() {
        this.underlyingList.getRemoveTracker().forEach(s -> this.add((ItemStack)s, s.func_190916_E()));
        this.underlyingList.getRemoveTracker().clear();
    }

    @Override
    @Nullable
    public ItemStack get(@Nonnull ItemStack stack, int flags) {
        ItemStack exact = this.underlyingList.get(stack, flags & 0xFFFFFFF7);
        if (exact == null && (flags & 8) == 8) {
            int[] ids;
            for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
                List stacks = this.stacks.get((Object)id);
                if (stacks == null || stacks.isEmpty()) continue;
                int i = 0;
                ItemStack returnStack = (ItemStack)stacks.get(i++);
                while (returnStack.func_190926_b() && i < stacks.size()) {
                    returnStack = (ItemStack)stacks.get(i++);
                }
                if (returnStack.func_190926_b()) continue;
                return returnStack;
            }
        }
        return exact;
    }

    @Override
    @Nullable
    public ItemStack get(int hash) {
        return this.underlyingList.get(hash);
    }

    @Override
    public void clear() {
        this.stacks.clear();
        this.underlyingList.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.underlyingList.isEmpty();
    }

    @Override
    public int getSizeFromStack(ItemStack stack) {
        return this.underlyingList.getSizeFromStack(stack);
    }

    @Override
    @Nonnull
    public Collection<ItemStack> getStacks() {
        return this.underlyingList.getStacks();
    }

    @Override
    @Nonnull
    public IStackList<ItemStack> copy() {
        StackListItemOredicted newList = new StackListItemOredicted();
        newList.underlyingList = (StackListItem)this.underlyingList.copy();
        for (Map.Entry entry : this.stacks.entries()) {
            newList.stacks.put(entry.getKey(), entry.getValue());
        }
        return newList;
    }

    @Override
    public IStackList<ItemStack> getOredicted() {
        return this;
    }
}

