/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.block;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeProxy;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.block.Direction;
import com.raoulvdberge.refinedstorage.capability.CapabilityNetworkNodeProxy;
import com.raoulvdberge.refinedstorage.container.ContainerBase;
import com.raoulvdberge.refinedstorage.integration.mcmp.IntegrationMCMP;
import com.raoulvdberge.refinedstorage.integration.mcmp.RSMCMPAddon;
import com.raoulvdberge.refinedstorage.item.ItemBlockBase;
import com.raoulvdberge.refinedstorage.tile.TileBase;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public abstract class BlockBase
extends Block {
    private final String name;

    public BlockBase(String name) {
        super(Material.field_151576_e);
        this.name = name;
        this.func_149711_c(1.9f);
        this.setRegistryName(this.getDomain(), name);
        this.func_149647_a(RS.INSTANCE.tab);
    }

    protected String getDomain() {
        return "refinedstorage";
    }

    protected Object getModObject() {
        return RS.INSTANCE;
    }

    public String func_149739_a() {
        return "block." + this.getDomain() + ":" + this.name;
    }

    protected BlockStateContainer.Builder createBlockStateBuilder() {
        BlockStateContainer.Builder builder = new BlockStateContainer.Builder((Block)this);
        if (this.getDirection() != null) {
            builder.add(new IProperty[]{this.getDirection().getProperty()});
        }
        return builder;
    }

    protected BlockStateContainer func_180661_e() {
        return this.createBlockStateBuilder().build();
    }

    public Item createItem() {
        return new ItemBlockBase(this, this.getDirection(), false);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (this.getDirection() != null) {
            TileEntity tile;
            TileEntity tileEntity = tile = IntegrationMCMP.isLoaded() ? RSMCMPAddon.unwrapTile(world, pos) : world.func_175625_s(pos);
            if (tile instanceof TileBase) {
                return state.func_177226_a((IProperty)this.getDirection().getProperty(), (Comparable)((TileBase)tile).getDirection());
            }
        }
        return state;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        if (!world.field_72995_K && this.getDirection() != null) {
            TileBase tile = (TileBase)world.func_175625_s(pos);
            tile.setDirection(this.getDirection().cycle(tile.getDirection()));
            WorldUtils.updateBlock(world, pos);
            return true;
        }
        return false;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        this.dropContents(world, pos);
        this.removeTile(world, pos, state);
        for (EntityPlayer player : world.field_73010_i) {
            if (!(player.field_71070_bA instanceof ContainerBase) || ((ContainerBase)player.field_71070_bA).getTile() == null || !((ContainerBase)player.field_71070_bA).getTile().func_174877_v().equals((Object)pos)) continue;
            player.func_71053_j();
        }
    }

    protected void removeTile(World world, BlockPos pos, IBlockState state) {
        if (this.hasTileEntity(state)) {
            world.func_175713_t(pos);
        }
    }

    protected void dropContents(World world, BlockPos pos) {
        TileEntity tile;
        TileEntity tileEntity = tile = IntegrationMCMP.isLoaded() ? RSMCMPAddon.unwrapTile((IBlockAccess)world, pos) : world.func_175625_s(pos);
        if (tile instanceof TileBase && ((TileBase)tile).getDrops() != null) {
            IItemHandler handler = ((TileBase)tile).getDrops();
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (handler.getStackInSlot(i).func_190926_b()) continue;
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)handler.getStackInSlot(i));
            }
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, tile, stack);
        world.func_175698_g(pos);
    }

    protected boolean tryOpenNetworkGui(int guiId, EntityPlayer player, World world, BlockPos pos, EnumFacing facing) {
        return this.tryOpenNetworkGui(guiId, player, world, pos, facing, Permission.MODIFY);
    }

    protected boolean tryOpenNetworkGui(int guiId, EntityPlayer player, World world, BlockPos pos, EnumFacing facing, Permission ... permissions) {
        INetworkNodeProxy nodeProxy;
        Object node;
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile.hasCapability(CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY, facing) && (node = (nodeProxy = (INetworkNodeProxy)CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY.cast(tile.getCapability(CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY, facing))).getNode()).getNetwork() != null) {
            for (Permission permission : permissions) {
                if (node.getNetwork().getSecurityManager().hasPermission(permission, player)) continue;
                WorldUtils.sendNoPermissionMessage(player);
                return false;
            }
        }
        player.openGui(this.getModObject(), guiId, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        INetworkNodeProxy nodeProxy;
        Object node;
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile.hasCapability(CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY, null) && (node = (nodeProxy = (INetworkNodeProxy)tile.getCapability(CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY, null)).getNode()).getNetwork() != null) {
            return entity instanceof EntityPlayer && node.getNetwork().getSecurityManager().hasPermission(Permission.BUILD, (EntityPlayer)entity);
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    @Nullable
    public Direction getDirection() {
        return Direction.HORIZONTAL;
    }
}

