/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.block;

import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeManager;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.block.BlockBase;
import com.raoulvdberge.refinedstorage.integration.mcmp.IntegrationMCMP;
import com.raoulvdberge.refinedstorage.integration.mcmp.RSMCMPAddon;
import com.raoulvdberge.refinedstorage.tile.TileNode;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockNode
extends BlockBase {
    public static final String NBT_REFINED_STORAGE_DATA = "RefinedStorageData";
    public static final PropertyBool CONNECTED = PropertyBool.func_177716_a((String)"connected");

    public BlockNode(String name) {
        super(name);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.field_72995_K) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileNode) {
                if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_REFINED_STORAGE_DATA)) {
                    ((NetworkNode)((TileNode)tile).getNode()).readConfiguration(stack.func_77978_p().func_74775_l(NBT_REFINED_STORAGE_DATA));
                    ((NetworkNode)((TileNode)tile).getNode()).markDirty();
                }
                if (placer instanceof EntityPlayer) {
                    ((NetworkNode)((TileNode)tile).getNode()).setOwner(((EntityPlayer)placer).func_146103_bH().getId());
                }
            }
            API.instance().discoverNode(world, pos);
        }
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        INetworkNodeManager manager = API.instance().getNetworkNodeManager(world);
        INetworkNode node = manager.getNode(pos);
        this.dropContents(world, pos);
        this.removeTile(world, pos, state);
        manager.removeNode(pos);
        manager.markForSaving();
        if (node != null && node.getNetwork() != null) {
            node.getNetwork().getNodeGraph().rebuild();
        }
    }

    @Override
    protected BlockStateContainer.Builder createBlockStateBuilder() {
        BlockStateContainer.Builder builder = super.createBlockStateBuilder();
        if (this.hasConnectivityState()) {
            builder.add(new IProperty[]{CONNECTED});
        }
        return builder;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return this.createBlockStateBuilder().build();
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = super.func_176221_a(state, world, pos);
        if (this.hasConnectivityState()) {
            TileEntity tile;
            TileEntity tileEntity = tile = IntegrationMCMP.isLoaded() ? RSMCMPAddon.unwrapTile(world, pos) : world.func_175625_s(pos);
            if (tile instanceof TileNode) {
                return state.func_177226_a((IProperty)CONNECTED, (Comparable)Boolean.valueOf(((NetworkNode)((TileNode)tile).getNode()).isActive()));
            }
        }
        return state;
    }

    public boolean hasConnectivityState() {
        return false;
    }
}

