/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.block;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraftforge.common.property.IUnlistedProperty;

public class PropertyObject<T>
implements IUnlistedProperty<T> {
    private final String name;
    private final Class<T> clazz;
    private final Predicate<T> validator;
    private final Function<T, String> stringFunction;

    public PropertyObject(String name, Class<T> clazz, Predicate<T> validator, Function<T, String> stringFunction) {
        this.name = name;
        this.clazz = clazz;
        this.validator = validator;
        this.stringFunction = stringFunction;
    }

    public PropertyObject(String name, Class<T> clazz) {
        this(name, clazz, v -> true, Objects::toString);
    }

    public String getName() {
        return this.name;
    }

    public boolean isValid(T value) {
        return this.validator.test(value);
    }

    public Class<T> getType() {
        return this.clazz;
    }

    public String valueToString(T value) {
        return this.stringFunction.apply(value);
    }
}

