/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.container;

import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.container.slot.SlotDisabled;
import com.raoulvdberge.refinedstorage.container.slot.SlotFilter;
import com.raoulvdberge.refinedstorage.container.slot.SlotFilterFluid;
import com.raoulvdberge.refinedstorage.container.slot.SlotFilterLegacy;
import com.raoulvdberge.refinedstorage.container.slot.SlotFilterType;
import com.raoulvdberge.refinedstorage.tile.TileBase;
import com.raoulvdberge.refinedstorage.tile.data.TileDataWatcher;
import invtweaks.api.container.InventoryContainer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

@InventoryContainer(showOptions=false)
public abstract class ContainerBase
extends Container {
    @Nullable
    private TileBase tile;
    @Nullable
    private TileDataWatcher listener;
    private EntityPlayer player;

    public ContainerBase(@Nullable TileBase tile, EntityPlayer player) {
        this.tile = tile;
        if (tile != null && player instanceof EntityPlayerMP) {
            this.listener = new TileDataWatcher((EntityPlayerMP)player, tile.getDataManager());
        }
        this.player = player;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    @Nullable
    public TileBase getTile() {
        return this.tile;
    }

    protected void addPlayerInventory(int xInventory, int yInventory) {
        int x;
        int id = 0;
        for (int i = 0; i < 9; ++i) {
            x = xInventory + i * 18;
            int y = yInventory + 4 + 54;
            if (i == this.player.field_71071_by.field_70461_c && this.isHeldItemDisabled()) {
                this.func_75146_a(new SlotDisabled((IInventory)this.player.field_71071_by, id, x, y));
            } else {
                this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, id, x, y));
            }
            ++id;
        }
        for (int y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, id, xInventory + x * 18, yInventory + y * 18));
                ++id;
            }
        }
    }

    public ItemStack func_184996_a(int id, int dragType, ClickType clickType, EntityPlayer player) {
        Slot slot;
        Slot slot2 = slot = id >= 0 ? this.func_75139_a(id) : null;
        if (slot instanceof SlotFilter) {
            if (slot.func_75211_c().func_77973_b() == RSItems.FILTER) {
                return super.func_184996_a(id, dragType, clickType, player);
            }
            if (((SlotFilter)slot).allowsSize()) {
                if (clickType == ClickType.QUICK_MOVE) {
                    slot.func_75215_d(ItemStack.field_190927_a);
                } else if (!player.field_71071_by.func_70445_o().func_190926_b()) {
                    slot.func_75215_d(player.field_71071_by.func_70445_o().func_77946_l());
                } else if (slot.func_75216_d()) {
                    int amount = slot.func_75211_c().func_190916_E();
                    if (dragType == 0) {
                        amount = Math.max(1, amount - 1);
                    } else if (dragType == 1) {
                        amount = Math.min(64, amount + 1);
                    }
                    slot.func_75211_c().func_190920_e(amount);
                }
            } else if (player.field_71071_by.func_70445_o().func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else if (slot.func_75214_a(player.field_71071_by.func_70445_o())) {
                if (player.field_71071_by.func_70445_o().func_77973_b() == RSItems.FILTER) {
                    return super.func_184996_a(id, dragType, clickType, player);
                }
                slot.func_75215_d(player.field_71071_by.func_70445_o().func_77946_l());
            }
            return player.field_71071_by.func_70445_o();
        }
        if (slot instanceof SlotFilterLegacy) {
            if (player.field_71071_by.func_70445_o().func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else if (slot.func_75214_a(player.field_71071_by.func_70445_o())) {
                slot.func_75215_d(player.field_71071_by.func_70445_o().func_77946_l());
            }
            return player.field_71071_by.func_70445_o();
        }
        if (slot instanceof SlotDisabled) {
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(id, dragType, clickType, player);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        return ItemStack.field_190927_a;
    }

    protected ItemStack mergeItemStackToFilters(ItemStack stack, int begin, int end) {
        int i;
        for (i = begin; i < end; ++i) {
            if (!API.instance().getComparer().isEqualNoQuantity(this.getStackFromSlot(this.func_75139_a(i)), stack)) continue;
            return ItemStack.field_190927_a;
        }
        for (i = begin; i < end; ++i) {
            Slot slot = this.func_75139_a(i);
            if (!this.getStackFromSlot(slot).func_190926_b() || !slot.func_75214_a(stack)) continue;
            slot.func_75215_d(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
            slot.func_75218_e();
            if (stack.func_77973_b() == RSItems.FILTER) {
                stack.func_190920_e(0);
            }
            return ItemStack.field_190927_a;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    private ItemStack getStackFromSlot(Slot slot) {
        ItemStack stackInSlot = slot.func_75211_c();
        if (stackInSlot.func_190926_b()) {
            if (slot instanceof SlotFilterFluid) {
                stackInSlot = ((SlotFilterFluid)slot).getRealStack();
            } else if (slot instanceof SlotFilterType) {
                stackInSlot = ((SlotFilterType)slot).getRealStack();
            }
        }
        return stackInSlot;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    protected boolean isHeldItemDisabled() {
        return false;
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.listener != null) {
            this.listener.detectAndSendChanges();
        }
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (this.listener != null) {
            this.listener.onClosed();
        }
    }
}

