/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.container.ContainerFilter;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.item.ItemFilter;
import com.raoulvdberge.refinedstorage.network.MessageFilterUpdate;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiFilter
extends GuiBase {
    private int compare;
    private int mode;
    private boolean modFilter;
    private String name;
    private GuiCheckBox compareDamage;
    private GuiCheckBox compareNBT;
    private GuiCheckBox compareOredict;
    private GuiCheckBox toggleModFilter;
    private GuiButton toggleMode;
    private GuiTextField nameField;

    public GuiFilter(ContainerFilter container) {
        super(container, 176, 231);
        this.compare = ItemFilter.getCompare(container.getStack());
        this.mode = ItemFilter.getMode(container.getStack());
        this.modFilter = ItemFilter.isModFilter(container.getStack());
        this.name = ItemFilter.getName(container.getStack());
    }

    @Override
    public void init(int x, int y) {
        this.compareDamage = this.addCheckBox(x + 7, y + 77, GuiFilter.t("gui.refinedstorage:filter.compare_damage", new Object[0]), (this.compare & 1) == 1);
        this.compareNBT = this.addCheckBox(x + 7 + this.compareDamage.func_146117_b() + 4, y + 77, GuiFilter.t("gui.refinedstorage:filter.compare_nbt", new Object[0]), (this.compare & 2) == 2);
        this.compareOredict = this.addCheckBox(x + 7 + this.compareDamage.func_146117_b() + 4 + this.compareNBT.func_146117_b() + 4, y + 77, GuiFilter.t("gui.refinedstorage:filter.compare_oredict", new Object[0]), (this.compare & 8) == 8);
        this.toggleModFilter = this.addCheckBox(0, y + 71 + 25, GuiFilter.t("gui.refinedstorage:filter.mod_filter", new Object[0]), this.modFilter);
        this.toggleMode = this.addButton(x + 7, y + 71 + 21, 0, 20, "");
        this.updateModeButton(this.mode);
        this.nameField = new GuiTextField(0, this.field_146289_q, x + 34, y + 121, 131, this.field_146289_q.field_78288_b);
        this.nameField.func_146180_a(this.name);
        this.nameField.func_146185_a(false);
        this.nameField.func_146189_e(true);
        this.nameField.func_146205_d(true);
        this.nameField.func_146195_b(false);
        this.nameField.func_146193_g(0xFFFFFF);
    }

    private void updateModeButton(int mode) {
        String text = mode == 0 ? GuiFilter.t("sidebutton.refinedstorage:mode.whitelist", new Object[0]) : GuiFilter.t("sidebutton.refinedstorage:mode.blacklist", new Object[0]);
        this.toggleMode.func_175211_a(this.field_146289_q.func_78256_a(text) + 12);
        this.toggleMode.field_146126_j = text;
        this.toggleModFilter.field_146128_h = this.toggleMode.field_146128_h + this.toggleMode.func_146117_b() + 4;
    }

    @Override
    public void update(int x, int y) {
    }

    @Override
    public void drawBackground(int x, int y, int mouseX, int mouseY) {
        this.bindTexture("gui/filter.png");
        this.drawTexture(x, y, 0, 0, this.screenWidth, this.screenHeight);
        this.nameField.func_146194_f();
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        this.drawString(7, 7, GuiFilter.t("gui.refinedstorage:filter", new Object[0]));
        this.drawString(7, 137, GuiFilter.t("container.inventory", new Object[0]));
    }

    protected void func_73869_a(char character, int keyCode) throws IOException {
        if (!this.func_146983_a(keyCode) && this.nameField.func_146201_a(character, keyCode)) {
            this.sendUpdate();
        } else {
            super.func_73869_a(character, keyCode);
        }
    }

    public void func_73864_a(int mouseX, int mouseY, int clickedButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, clickedButton);
        this.nameField.func_146192_a(mouseX, mouseY, clickedButton);
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button == this.compareDamage) {
            this.compare ^= 1;
        } else if (button == this.compareNBT) {
            this.compare ^= 2;
        } else if (button == this.compareOredict) {
            this.compare ^= 8;
        } else if (button == this.toggleMode) {
            this.mode = this.mode == 0 ? 1 : 0;
            this.updateModeButton(this.mode);
        } else if (button == this.toggleModFilter) {
            this.modFilter = !this.modFilter;
        }
        this.sendUpdate();
    }

    private void sendUpdate() {
        RS.INSTANCE.network.sendToServer((IMessage)new MessageFilterUpdate(this.compare, this.mode, this.modFilter, this.nameField.func_146179_b()));
    }
}

