/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeSecurityManager;
import com.raoulvdberge.refinedstorage.container.ContainerSecurityManager;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.sidebutton.SideButtonRedstoneMode;
import com.raoulvdberge.refinedstorage.item.ItemSecurityCard;
import com.raoulvdberge.refinedstorage.network.MessageSecurityManagerUpdate;
import com.raoulvdberge.refinedstorage.tile.TileSecurityManager;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiSecurityManager
extends GuiBase {
    private TileSecurityManager securityManager;
    private GuiCheckBox[] permissions = new GuiCheckBox[Permission.values().length];

    public GuiSecurityManager(ContainerSecurityManager container, TileSecurityManager securityManager) {
        super(container, 176, 234);
        this.securityManager = securityManager;
    }

    @Override
    public void init(int x, int y) {
        this.addSideButton(new SideButtonRedstoneMode(this, TileSecurityManager.REDSTONE_MODE));
        int padding = 15;
        this.permissions[0] = this.addCheckBox(x + 7, y + 93, I18n.func_135052_a((String)"gui.refinedstorage:security_manager.permission.0", (Object[])new Object[0]), false);
        this.permissions[1] = this.addCheckBox(this.permissions[0].field_146128_h, this.permissions[0].field_146129_i + padding, I18n.func_135052_a((String)"gui.refinedstorage:security_manager.permission.1", (Object[])new Object[0]), false);
        this.permissions[2] = this.addCheckBox(this.permissions[1].field_146128_h, this.permissions[1].field_146129_i + padding, I18n.func_135052_a((String)"gui.refinedstorage:security_manager.permission.2", (Object[])new Object[0]), false);
        this.permissions[3] = this.addCheckBox(this.permissions[0].field_146128_h + 90, this.permissions[0].field_146129_i, I18n.func_135052_a((String)"gui.refinedstorage:security_manager.permission.3", (Object[])new Object[0]), false);
        this.permissions[4] = this.addCheckBox(this.permissions[3].field_146128_h, this.permissions[3].field_146129_i + padding, I18n.func_135052_a((String)"gui.refinedstorage:security_manager.permission.4", (Object[])new Object[0]), false);
        this.permissions[5] = this.addCheckBox(this.permissions[4].field_146128_h, this.permissions[4].field_146129_i + padding, I18n.func_135052_a((String)"gui.refinedstorage:security_manager.permission.5", (Object[])new Object[0]), false);
    }

    @Override
    public void update(int x, int y) {
        ItemStack card = ((NetworkNodeSecurityManager)this.securityManager.getNode()).getEditCard().getStackInSlot(0);
        for (Permission permission : Permission.values()) {
            this.permissions[permission.getId()].setIsChecked(!card.func_190926_b() && ItemSecurityCard.hasPermission(card, permission));
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        for (int i = 0; i < this.permissions.length; ++i) {
            if (button != this.permissions[i]) continue;
            RS.INSTANCE.network.sendToServer((IMessage)new MessageSecurityManagerUpdate(this.securityManager, Permission.values()[i], this.permissions[i].isChecked()));
        }
    }

    @Override
    public void drawBackground(int x, int y, int mouseX, int mouseY) {
        this.bindTexture("gui/security_manager.png");
        this.drawTexture(x, y, 0, 0, this.screenWidth, this.screenHeight);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        this.drawString(7, 7, GuiSecurityManager.t("gui.refinedstorage:security_manager", new Object[0]));
        this.drawString(7, 59, GuiSecurityManager.t("gui.refinedstorage:security_manager.configure", new Object[0]));
        this.drawString(7, 140, GuiSecurityManager.t("container.inventory", new Object[0]));
        for (int i = 0; i < this.permissions.length; ++i) {
            GuiCheckBox permission = this.permissions[i];
            if (!this.inBounds(permission.field_146128_h - this.field_147003_i, permission.field_146129_i - this.field_147009_r, permission.field_146120_f, permission.field_146121_g, mouseX, mouseY)) continue;
            this.drawTooltip(mouseX, mouseY, I18n.func_135052_a((String)("gui.refinedstorage:security_manager.permission." + i + ".tooltip"), (Object[])new Object[0]));
        }
    }
}

