/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui.grid.sorting;

import com.raoulvdberge.refinedstorage.api.network.grid.GridType;
import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.gui.grid.GuiGrid;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterParser;
import com.raoulvdberge.refinedstorage.gui.grid.sorting.GridSorting;
import com.raoulvdberge.refinedstorage.gui.grid.sorting.GridSortingID;
import com.raoulvdberge.refinedstorage.gui.grid.sorting.GridSortingInventoryTweaks;
import com.raoulvdberge.refinedstorage.gui.grid.sorting.GridSortingLastModified;
import com.raoulvdberge.refinedstorage.gui.grid.sorting.GridSortingName;
import com.raoulvdberge.refinedstorage.gui.grid.sorting.GridSortingQuantity;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public class Sorter
implements Runnable {
    private static final GridSorting SORTING_QUANTITY = new GridSortingQuantity();
    private static final GridSorting SORTING_NAME = new GridSortingName();
    private static final GridSorting SORTING_ID = new GridSortingID();
    private static final GridSorting SORTING_INVENTORYTWEAKS = new GridSortingInventoryTweaks();
    private static final GridSorting SORTING_LAST_MODIFIED = new GridSortingLastModified();
    private boolean done;
    private boolean started;
    private GuiGrid gui;

    public Sorter(GuiGrid gui) {
        this.gui = gui;
    }

    @Override
    public void run() {
        IGrid grid = this.gui.getGrid();
        ArrayList<IGridStack> stacks = new ArrayList<IGridStack>();
        if (grid.isActive()) {
            stacks.addAll(grid.getType() == GridType.FLUID ? GuiGrid.FLUIDS.values() : GuiGrid.ITEMS.values());
            List<Predicate<IGridStack>> filters = GridFilterParser.getFilters(grid, this.gui.getSearchField() != null ? this.gui.getSearchField().func_146179_b() : "", grid.getTabSelected() >= 0 && grid.getTabSelected() < grid.getTabs().size() ? grid.getTabs().get(grid.getTabSelected()).getFilters() : grid.getFilters());
            Iterator t = stacks.iterator();
            block0: while (t.hasNext()) {
                IGridStack stack = (IGridStack)t.next();
                for (Predicate<IGridStack> filter : filters) {
                    if (filter.test(stack)) continue;
                    t.remove();
                    continue block0;
                }
            }
            SORTING_NAME.setSortingDirection(grid.getSortingDirection());
            SORTING_QUANTITY.setSortingDirection(grid.getSortingDirection());
            SORTING_ID.setSortingDirection(grid.getSortingDirection());
            SORTING_INVENTORYTWEAKS.setSortingDirection(grid.getSortingDirection());
            SORTING_LAST_MODIFIED.setSortingDirection(grid.getSortingDirection());
            stacks.sort(SORTING_NAME);
            if (grid.getSortingType() == 0) {
                stacks.sort(SORTING_QUANTITY);
            } else if (grid.getSortingType() == 2) {
                stacks.sort(SORTING_ID);
            } else if (grid.getSortingType() == 3) {
                stacks.sort(SORTING_INVENTORYTWEAKS);
            } else if (grid.getSortingType() == 4) {
                stacks.sort(SORTING_LAST_MODIFIED);
            }
        }
        GuiGrid.STACKS = stacks;
        if (this.gui.getScrollbar() != null) {
            this.gui.getScrollbar().setEnabled(this.gui.getRows() > this.gui.getVisibleRows());
            this.gui.getScrollbar().setMaxOffset(this.gui.getRows() - this.gui.getVisibleRows());
        }
        if (this.gui.getTabPageLeft() != null) {
            boolean bl = this.gui.getTabPageLeft().field_146125_m = grid.getTotalTabPages() > 0;
        }
        if (this.gui.getTabPageRight() != null) {
            this.gui.getTabPageRight().field_146125_m = grid.getTotalTabPages() > 0;
        }
        this.done = true;
    }

    public void start() {
        this.started = true;
        new Thread((Runnable)this, "RS grid sorting").start();
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isDone() {
        return this.done;
    }
}

