/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.integration.forgeenergy;

import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReader;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterChannel;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterHandler;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IWriter;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class ReaderWriterHandlerForgeEnergy
implements IReaderWriterHandler {
    public static final String ID = "forgeenergy";
    private static final String NBT_ENERGY_STORED = "EnergyStored";
    private EnergyStorage storage = new EnergyStorage(16000);
    private EnergyStorageReaderWriter storageReader = new EnergyStorageReaderWriter((IEnergyStorage)this.storage, false, true);
    private EnergyStorageReaderWriter storageWriter = new EnergyStorageReaderWriter((IEnergyStorage)this.storage, true, false);

    public ReaderWriterHandlerForgeEnergy(@Nullable NBTTagCompound tag) {
        if (tag != null && tag.func_74764_b(NBT_ENERGY_STORED)) {
            this.storage.receiveEnergy(tag.func_74762_e(NBT_ENERGY_STORED), false);
        }
    }

    @Override
    public void update(IReaderWriterChannel channel) {
        if (channel.getWriters().isEmpty()) {
            return;
        }
        int toSend = (int)Math.floor((float)this.storage.getEnergyStored() / (float)channel.getWriters().size());
        int toExtract = 0;
        for (IWriter writer : channel.getWriters()) {
            TileEntity tile;
            if (!writer.canUpdate() || (tile = writer.getWorld().func_175625_s(writer.getPos().func_177972_a(writer.getDirection()))) == null || !tile.hasCapability(CapabilityEnergy.ENERGY, writer.getDirection().func_176734_d())) continue;
            toExtract += ((IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, writer.getDirection().func_176734_d())).receiveEnergy(this.storage.extractEnergy(toSend, true), false);
        }
        this.storage.extractEnergy(toExtract, false);
    }

    @Override
    public void onWriterDisabled(IWriter writer) {
    }

    @Override
    public boolean hasCapabilityReader(IReader reader, Capability<?> capability) {
        return capability == CapabilityEnergy.ENERGY;
    }

    @Override
    public <T> T getCapabilityReader(IReader reader, Capability<T> capability) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.storageReader);
        }
        return null;
    }

    @Override
    public boolean hasCapabilityWriter(IWriter writer, Capability<?> capability) {
        return capability == CapabilityEnergy.ENERGY;
    }

    @Override
    public <T> T getCapabilityWriter(IWriter writer, Capability<T> capability) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.storageWriter);
        }
        return null;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a(NBT_ENERGY_STORED, this.storage.getEnergyStored());
        return tag;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public List<ITextComponent> getStatusReader(IReader reader, IReaderWriterChannel channel) {
        return this.getStatus(this.storageReader);
    }

    @Override
    public List<ITextComponent> getStatusWriter(IWriter writer, IReaderWriterChannel channel) {
        return this.getStatus(this.storageWriter);
    }

    private List<ITextComponent> getStatus(IEnergyStorage storage) {
        if (storage.getEnergyStored() == 0) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new TextComponentString(storage.getEnergyStored() + " FE / " + storage.getMaxEnergyStored() + " FE"));
    }

    private class EnergyStorageReaderWriter
    implements IEnergyStorage {
        private IEnergyStorage parent;
        private boolean canExtract;
        private boolean canReceive;

        EnergyStorageReaderWriter(IEnergyStorage parent, boolean canExtract, boolean canReceive) {
            this.canExtract = canExtract;
            this.canReceive = canReceive;
            this.parent = parent;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return this.canReceive ? this.parent.receiveEnergy(maxReceive, simulate) : 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return this.canExtract ? this.parent.extractEnergy(maxExtract, simulate) : 0;
        }

        public int getEnergyStored() {
            return this.parent.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return this.parent.getMaxEnergyStored();
        }

        public boolean canExtract() {
            return this.canExtract;
        }

        public boolean canReceive() {
            return this.canReceive;
        }
    }
}

