/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.integration.mcmp;

import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.block.BlockCable;
import com.raoulvdberge.refinedstorage.integration.mcmp.PartCable;
import com.raoulvdberge.refinedstorage.integration.mcmp.PartCableTile;
import com.raoulvdberge.refinedstorage.tile.TileCable;
import com.raoulvdberge.refinedstorage.tile.TileConstructor;
import com.raoulvdberge.refinedstorage.tile.TileDestructor;
import com.raoulvdberge.refinedstorage.tile.TileExporter;
import com.raoulvdberge.refinedstorage.tile.TileExternalStorage;
import com.raoulvdberge.refinedstorage.tile.TileImporter;
import com.raoulvdberge.refinedstorage.tile.TileReader;
import com.raoulvdberge.refinedstorage.tile.TileWriter;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcmultipart.api.addon.IMCMPAddon;
import mcmultipart.api.addon.MCMPAddon;
import mcmultipart.api.container.IPartInfo;
import mcmultipart.api.multipart.IMultipart;
import mcmultipart.api.multipart.IMultipartRegistry;
import mcmultipart.api.multipart.IMultipartTile;
import mcmultipart.api.multipart.MultipartOcclusionHelper;
import mcmultipart.api.ref.MCMPCapabilities;
import mcmultipart.api.slot.EnumCenterSlot;
import mcmultipart.api.slot.IPartSlot;
import mcmultipart.block.BlockMultipartContainer;
import mcmultipart.block.TileMultipartContainer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@MCMPAddon
public class RSMCMPAddon
implements IMCMPAddon {
    public void registerParts(IMultipartRegistry registry) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.register(registry, RSBlocks.CABLE);
        this.register(registry, RSBlocks.CONSTRUCTOR);
        this.register(registry, RSBlocks.DESTRUCTOR);
        this.register(registry, RSBlocks.IMPORTER);
        this.register(registry, RSBlocks.EXPORTER);
        this.register(registry, RSBlocks.EXTERNAL_STORAGE);
        this.register(registry, RSBlocks.READER);
        this.register(registry, RSBlocks.WRITER);
    }

    private void register(IMultipartRegistry registry, BlockCable block) {
        registry.registerPartWrapper((Block)block, (IMultipart)new PartCable(block));
        registry.registerStackWrapper(Item.func_150898_a((Block)block), s -> true, (Block)block);
    }

    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent<TileEntity> e) {
        TileEntity tile = (TileEntity)e.getObject();
        if (tile instanceof TileCable) {
            this.register(e, "cable");
        } else if (tile instanceof TileConstructor) {
            this.register(e, "constructor");
        } else if (tile instanceof TileDestructor) {
            this.register(e, "destructor");
        } else if (tile instanceof TileImporter) {
            this.register(e, "importer");
        } else if (tile instanceof TileExporter) {
            this.register(e, "exporter");
        } else if (tile instanceof TileExternalStorage) {
            this.register(e, "external_storage");
        } else if (tile instanceof TileReader) {
            this.register(e, "reader");
        } else if (tile instanceof TileWriter) {
            this.register(e, "writer");
        }
    }

    private void register(final AttachCapabilitiesEvent<TileEntity> e, String id) {
        e.addCapability(new ResourceLocation("refinedstorage:" + id), new ICapabilityProvider(){
            private PartCableTile tile;

            public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                return capability == MCMPCapabilities.MULTIPART_TILE;
            }

            @Nullable
            public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                if (capability == MCMPCapabilities.MULTIPART_TILE) {
                    if (this.tile == null) {
                        this.tile = new PartCableTile((TileEntity)e.getObject());
                    }
                    return (T)MCMPCapabilities.MULTIPART_TILE.cast((Object)this.tile);
                }
                return null;
            }
        });
    }

    public static boolean hasObstructingMultipart(TileEntity tile, List<AxisAlignedBB> testBoxes) {
        IMultipartTile multipartTile;
        if (tile != null && tile.hasCapability(MCMPCapabilities.MULTIPART_TILE, null) && (multipartTile = (IMultipartTile)tile.getCapability(MCMPCapabilities.MULTIPART_TILE, null)) instanceof PartCableTile && ((PartCableTile)multipartTile).getInfo() != null) {
            for (IPartInfo info : ((PartCableTile)multipartTile).getInfo().getContainer().getParts().values()) {
                IMultipart multipart = info.getPart();
                if (multipart instanceof PartCable || !MultipartOcclusionHelper.testBoxIntersection(testBoxes, (Collection)multipart.getOcclusionBoxes(info))) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static TileEntity unwrapTile(IBlockAccess world, BlockPos pos) {
        Optional multipartTile;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileMultipartContainer && (multipartTile = ((TileMultipartContainer)tile).getPartTile((IPartSlot)EnumCenterSlot.CENTER)).isPresent()) {
            return ((IMultipartTile)multipartTile.get()).getTileEntity();
        }
        return tile;
    }

    public static Block unwrapBlock(IBlockAccess world, BlockPos pos) {
        Optional info;
        Optional multipartContainer;
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockMultipartContainer && (multipartContainer = BlockMultipartContainer.getTile((IBlockAccess)world, (BlockPos)pos)).isPresent() && (info = ((TileMultipartContainer)multipartContainer.get()).get((IPartSlot)EnumCenterSlot.CENTER)).isPresent()) {
            return ((IPartInfo)info.get()).getPart().getBlock();
        }
        return state.func_177230_c();
    }
}

