/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.integration.storagedrawers;

import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.externalstorage.NetworkNodeExternalStorage;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.externalstorage.StorageItemExternal;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.items.ItemHandlerHelper;

public class StorageItemItemRepository
extends StorageItemExternal {
    @CapabilityInject(value=IItemRepository.class)
    private static final Capability<IItemRepository> ITEM_REPOSITORY_CAPABILITY = null;
    private NetworkNodeExternalStorage externalStorage;
    private Supplier<IDrawerGroup> groupSupplier;

    public StorageItemItemRepository(NetworkNodeExternalStorage externalStorage, Supplier<IDrawerGroup> groupSupplier) {
        this.externalStorage = externalStorage;
        this.groupSupplier = groupSupplier;
    }

    @Override
    public Collection<ItemStack> getStacks() {
        IItemRepository repository = this.getRepositoryFromSupplier();
        if (repository == null) {
            return Collections.emptyList();
        }
        return repository.getAllItems().stream().map(r -> ItemHandlerHelper.copyStackWithSize((ItemStack)r.itemPrototype, (int)r.count)).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public ItemStack insert(@Nonnull ItemStack stack, int size, boolean simulate) {
        IItemRepository repository = this.getRepositoryFromSupplier();
        if (repository == null) {
            return stack;
        }
        return StackUtils.emptyToNull(repository.insertItem(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size), simulate));
    }

    @Override
    @Nullable
    public ItemStack extract(@Nonnull ItemStack stack, int size, int flags, boolean simulate) {
        IItemRepository repository = this.getRepositoryFromSupplier();
        if (repository == null) {
            return null;
        }
        return StackUtils.emptyToNull(repository.extractItem(stack, size, simulate, s -> API.instance().getComparer().isEqual(stack, (ItemStack)s, flags)));
    }

    @Override
    public int getStored() {
        IItemRepository repository = this.getRepositoryFromSupplier();
        if (repository == null) {
            return 0;
        }
        return repository.getAllItems().stream().mapToInt(r -> r.count).sum();
    }

    @Override
    public int getPriority() {
        return this.externalStorage.getPriority();
    }

    @Override
    public AccessType getAccessType() {
        return this.externalStorage.getAccessType();
    }

    @Override
    public int getCapacity() {
        IDrawerGroup group = this.groupSupplier.get();
        if (group == null) {
            return 0;
        }
        long capacity = 0L;
        for (int slot : group.getAccessibleDrawerSlots()) {
            IDrawer drawer = group.getDrawer(slot);
            if (!drawer.isEnabled()) continue;
            capacity += (long)drawer.getMaxCapacity();
        }
        if (capacity >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)capacity;
    }

    private IItemRepository getRepositoryFromSupplier() {
        IDrawerGroup group = this.groupSupplier.get();
        if (group == null) {
            return null;
        }
        return (IItemRepository)group.getCapability(ITEM_REPOSITORY_CAPABILITY, null);
    }
}

