/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.inventory;

import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class ItemHandlerBase
extends ItemStackHandler {
    @Nullable
    private Consumer<Integer> listener;
    private boolean empty = true;
    protected Predicate<ItemStack>[] validators;

    public ItemHandlerBase(int size, @Nullable Consumer<Integer> listener, Predicate<ItemStack> ... validators) {
        super(size);
        this.listener = listener;
        this.validators = validators;
    }

    public ItemHandlerBase(int size, Predicate<ItemStack> ... validators) {
        this(size, (Consumer<Integer>)null, validators);
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.validateSlotIndex(slot);
        this.stacks.set(slot, (Object)stack);
        this.onContentsChanged(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.validators.length > 0) {
            for (Predicate<ItemStack> validator : this.validators) {
                if (!validator.test(stack)) continue;
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        if (this.listener != null) {
            this.listener.accept(slot);
        }
        this.empty = this.stacks.stream().allMatch(ItemStack::func_190926_b);
    }

    public boolean isEmpty() {
        return this.empty;
    }
}

