/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.IStorageTracker;
import com.raoulvdberge.refinedstorage.gui.grid.GuiGrid;
import com.raoulvdberge.refinedstorage.gui.grid.stack.GridStackItem;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.commons.lang3.tuple.Pair;

public class MessageGridItemDelta
implements IMessage,
IMessageHandler<MessageGridItemDelta, IMessage> {
    @Nullable
    private INetwork network;
    private IStorageTracker<ItemStack> storageTracker;
    private List<Pair<ItemStack, Integer>> deltas;
    @Nullable
    private ItemStack stack;
    private int delta;
    @Nullable
    private GridStackItem gridStack;
    private List<Pair<GridStackItem, Integer>> gridStacks;

    public MessageGridItemDelta() {
    }

    public MessageGridItemDelta(@Nullable INetwork network, IStorageTracker<ItemStack> storageTracker, ItemStack stack, int delta) {
        this.network = network;
        this.storageTracker = storageTracker;
        this.stack = stack;
        this.delta = delta;
    }

    public MessageGridItemDelta(@Nullable INetwork network, IStorageTracker<ItemStack> storageTracker, List<Pair<ItemStack, Integer>> deltas) {
        this.network = network;
        this.storageTracker = storageTracker;
        this.deltas = deltas;
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        if (size == 1) {
            this.gridStack = new GridStackItem(buf);
            this.delta = buf.readInt();
        } else {
            this.gridStacks = new LinkedList<Pair<GridStackItem, Integer>>();
            for (int i = 0; i < size; ++i) {
                this.gridStacks.add((Pair<GridStackItem, Integer>)Pair.of((Object)new GridStackItem(buf), (Object)buf.readInt()));
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        if (this.stack != null) {
            buf.writeInt(1);
            StackUtils.writeItemStack(buf, this.stack, this.network, false);
            IStorageTracker.IStorageTrackerEntry entry = this.storageTracker.get(this.stack);
            buf.writeBoolean(entry != null);
            if (entry != null) {
                buf.writeLong(entry.getTime());
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getName());
            }
            buf.writeInt(this.delta);
        } else {
            buf.writeInt(this.deltas.size());
            for (Pair<ItemStack, Integer> delta : this.deltas) {
                StackUtils.writeItemStack(buf, (ItemStack)delta.getLeft(), this.network, false);
                IStorageTracker.IStorageTrackerEntry entry = this.storageTracker.get((ItemStack)delta.getLeft());
                buf.writeBoolean(entry != null);
                if (entry != null) {
                    buf.writeLong(entry.getTime());
                    ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getName());
                }
                buf.writeInt(((Integer)delta.getRight()).intValue());
            }
        }
    }

    public IMessage onMessage(MessageGridItemDelta message, MessageContext ctx) {
        if (message.gridStack != null) {
            this.process(message.gridStack, message.delta);
        } else {
            message.gridStacks.forEach(p -> this.process((GridStackItem)p.getLeft(), (Integer)p.getRight()));
        }
        GuiGrid.scheduleSort();
        return null;
    }

    private void process(GridStackItem gridStack, int delta) {
        Item item = gridStack.getStack().func_77973_b();
        for (GridStackItem stack : GuiGrid.ITEMS.get((Object)item)) {
            if (!stack.equals(gridStack)) continue;
            if (stack.getStack().func_190916_E() + delta <= 0) {
                if (gridStack.isCraftable()) {
                    stack.setDisplayCraftText(true);
                } else {
                    GuiGrid.ITEMS.remove((Object)item, (Object)stack);
                }
            } else if (stack.doesDisplayCraftText()) {
                stack.setDisplayCraftText(false);
                stack.getStack().func_190920_e(delta);
            } else {
                stack.getStack().func_190917_f(delta);
            }
            stack.setTrackerEntry(gridStack.getTrackerEntry());
            return;
        }
        gridStack.getStack().func_190920_e(delta);
        GuiGrid.ITEMS.put((Object)item, (Object)gridStack);
    }
}

