/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.api.network.grid.GridType;
import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.container.ContainerGrid;
import com.raoulvdberge.refinedstorage.network.MessageHandlerPlayerToServer;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MessageGridTransfer
extends MessageHandlerPlayerToServer<MessageGridTransfer>
implements IMessage {
    private NBTTagCompound recipe;

    public MessageGridTransfer() {
    }

    public MessageGridTransfer(NBTTagCompound recipe) {
        this.recipe = recipe;
    }

    public void fromBytes(ByteBuf buf) {
        this.recipe = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.recipe);
    }

    @Override
    public void handle(MessageGridTransfer message, EntityPlayerMP player) {
        IGrid grid;
        if (player.field_71070_bA instanceof ContainerGrid && ((grid = ((ContainerGrid)player.field_71070_bA).getGrid()).getType() == GridType.CRAFTING || grid.getType() == GridType.PATTERN)) {
            ItemStack[][] actualRecipe = new ItemStack[9][];
            for (int x = 0; x < actualRecipe.length; ++x) {
                NBTTagList list = message.recipe.func_150295_c("#" + x, 10);
                if (list.func_74745_c() <= 0) continue;
                actualRecipe[x] = new ItemStack[list.func_74745_c()];
                for (int y = 0; y < list.func_74745_c(); ++y) {
                    actualRecipe[x][y] = new ItemStack(list.func_150305_b(y));
                }
            }
            grid.onRecipeTransfer((EntityPlayer)player, actualRecipe);
        }
    }
}

