/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.IStorageDisk;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.diskdrive.NetworkNodeDiskDrive;
import com.raoulvdberge.refinedstorage.tile.TileNode;
import com.raoulvdberge.refinedstorage.tile.config.IAccessType;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.config.IExcessVoidable;
import com.raoulvdberge.refinedstorage.tile.config.IFilterable;
import com.raoulvdberge.refinedstorage.tile.config.IPrioritizable;
import com.raoulvdberge.refinedstorage.tile.config.IType;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileDiskDrive
extends TileNode<NetworkNodeDiskDrive> {
    public static final TileDataParameter<Integer, TileDiskDrive> PRIORITY = IPrioritizable.createParameter();
    public static final TileDataParameter<Integer, TileDiskDrive> COMPARE = IComparable.createParameter();
    public static final TileDataParameter<Integer, TileDiskDrive> MODE = IFilterable.createParameter();
    public static final TileDataParameter<Integer, TileDiskDrive> TYPE = IType.createParameter();
    public static final TileDataParameter<Boolean, TileDiskDrive> VOID_EXCESS = IExcessVoidable.createParameter();
    public static final TileDataParameter<AccessType, TileDiskDrive> ACCESS_TYPE = IAccessType.createParameter();
    public static final TileDataParameter<Integer, TileDiskDrive> STORED = new TileDataParameter<Integer, TileDiskDrive>(DataSerializers.field_187192_b, 0, t -> {
        int stored = 0;
        for (IStorageDisk storage : ((NetworkNodeDiskDrive)t.getNode()).getItemStorages()) {
            if (storage == null) continue;
            stored += storage.getStored();
        }
        for (IStorageDisk storage : ((NetworkNodeDiskDrive)t.getNode()).getFluidStorages()) {
            if (storage == null) continue;
            stored += storage.getStored();
        }
        return stored;
    });
    public static final TileDataParameter<Integer, TileDiskDrive> CAPACITY = new TileDataParameter<Integer, TileDiskDrive>(DataSerializers.field_187192_b, 0, t -> {
        int capacity = 0;
        for (IStorageDisk storage : ((NetworkNodeDiskDrive)t.getNode()).getItemStorages()) {
            if (storage == null) continue;
            if (storage.getCapacity() == -1) {
                return -1;
            }
            capacity += storage.getCapacity();
        }
        for (IStorageDisk storage : ((NetworkNodeDiskDrive)t.getNode()).getFluidStorages()) {
            if (storage == null) continue;
            if (storage.getCapacity() == -1) {
                return -1;
            }
            capacity += storage.getCapacity();
        }
        return capacity;
    });
    private static final String NBT_DISK_STATE = "DiskState_%d";
    public static final int DISK_STATE_NORMAL = 0;
    public static final int DISK_STATE_NEAR_CAPACITY = 1;
    public static final int DISK_STATE_FULL = 2;
    public static final int DISK_STATE_DISCONNECTED = 3;
    public static final int DISK_STATE_NONE = 4;
    private Integer[] diskState = new Integer[8];

    public TileDiskDrive() {
        this.dataManager.addWatchedParameter(PRIORITY);
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(MODE);
        this.dataManager.addWatchedParameter(TYPE);
        this.dataManager.addWatchedParameter(VOID_EXCESS);
        this.dataManager.addWatchedParameter(ACCESS_TYPE);
        this.dataManager.addWatchedParameter(STORED);
        this.dataManager.addWatchedParameter(CAPACITY);
        TileDiskDrive.initDiskState(this.diskState);
    }

    @Override
    public NBTTagCompound writeUpdate(NBTTagCompound tag) {
        super.writeUpdate(tag);
        TileDiskDrive.writeDiskState(tag, 8, ((NetworkNodeDiskDrive)this.getNode()).getNetwork() != null, ((NetworkNodeDiskDrive)this.getNode()).getItemStorages(), ((NetworkNodeDiskDrive)this.getNode()).getFluidStorages());
        return tag;
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        super.readUpdate(tag);
        TileDiskDrive.readDiskState(tag, this.diskState);
    }

    public Integer[] getDiskState() {
        return this.diskState;
    }

    public static void writeDiskState(NBTTagCompound tag, int disks, boolean connected, IStorageDisk[] itemStorages, IStorageDisk[] fluidStorages) {
        for (int i = 0; i < disks; ++i) {
            int state = 4;
            if (itemStorages[i] != null || fluidStorages[i] != null) {
                state = !connected ? 3 : TileDiskDrive.getDiskState(itemStorages[i] != null ? itemStorages[i].getStored() : fluidStorages[i].getStored(), itemStorages[i] != null ? itemStorages[i].getCapacity() : fluidStorages[i].getCapacity());
            }
            tag.func_74768_a(String.format(NBT_DISK_STATE, i), state);
        }
    }

    public static void readDiskState(NBTTagCompound tag, Integer[] diskState) {
        for (int i = 0; i < diskState.length; ++i) {
            diskState[i] = tag.func_74762_e(String.format(NBT_DISK_STATE, i));
        }
    }

    public static void initDiskState(Integer[] diskState) {
        for (int i = 0; i < diskState.length; ++i) {
            diskState[i] = 4;
        }
    }

    public static int getDiskState(int stored, int capacity) {
        if (stored == capacity) {
            return 2;
        }
        if ((int)((float)stored / (float)capacity * 100.0f) >= 85) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)((NetworkNodeDiskDrive)this.getNode()).getDisks());
        }
        return super.getCapability(capability, facing);
    }

    @Override
    @Nonnull
    public NetworkNodeDiskDrive createNode(World world, BlockPos pos) {
        return new NetworkNodeDiskDrive(world, pos);
    }

    @Override
    public String getNodeId() {
        return "disk_drive";
    }
}

